/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.recipe.RecipeProperties;
import dan200.computercraft.shared.recipe.ShapelessRecipeSpec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3955;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9322;
import net.minecraft.class_9331;
import net.minecraft.class_9694;

public final class PrintoutRecipe
extends class_1867 {
    public static final MapCodec<PrintoutRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShapelessRecipeSpec.CODEC.forGetter(PrintoutRecipe::toSpec), (App)class_1856.field_46096.fieldOf("printout").forGetter(x -> x.printout), (App)class_5699.field_33442.fieldOf("min_printouts").forGetter(x -> x.minPrintouts)).apply((Applicative)instance, PrintoutRecipe::new));
    public static final class_9139<class_9129, PrintoutRecipe> STREAM_CODEC = class_9139.method_56436(ShapelessRecipeSpec.STREAM_CODEC, PrintoutRecipe::toSpec, (class_9139)class_1856.field_48355, x -> x.printout, (class_9139)class_9135.field_48550, x -> x.minPrintouts, PrintoutRecipe::new);
    private final class_2371<class_1856> ingredients;
    private final class_1856 printout;
    private final int minPrintouts;
    private final class_1867 innerRecipe;
    private final class_1799 result;

    public PrintoutRecipe(ShapelessRecipeSpec spec, class_1856 printout, int minPrintouts) {
        super(spec.properties().group(), spec.properties().category(), spec.result(), PrintoutRecipe.concat(spec.ingredients(), printout, minPrintouts));
        this.ingredients = spec.ingredients();
        this.printout = printout;
        this.minPrintouts = minPrintouts;
        this.result = spec.result();
        this.innerRecipe = spec.create();
    }

    private static class_2371<class_1856> concat(class_2371<class_1856> first, class_1856 pages, int pagesRequired) {
        class_2371 result = class_2371.method_10213((int)(first.size() + pagesRequired), (Object)class_1856.field_9017);
        int idx = 0;
        for (class_1856 ingredient : first) {
            result.set(idx++, (Object)ingredient);
        }
        for (int i = 0; i < pagesRequired; ++i) {
            result.set(idx++, (Object)pages);
        }
        return result;
    }

    private ShapelessRecipeSpec toSpec() {
        return new ShapelessRecipeSpec(RecipeProperties.of((class_3955)this), this.ingredients, this.result);
    }

    public boolean method_17730(class_9694 inv, class_1937 world) {
        class_1662 stackedContents = new class_1662();
        int inputs = 0;
        int printouts = 0;
        int pages = 0;
        boolean hasPrintout = false;
        for (int j = 0; j < inv.method_59983(); ++j) {
            class_1799 stack = inv.method_59984(j);
            if (stack.method_7960()) continue;
            if (this.printout.method_8093(stack)) {
                ++printouts;
                PrintoutData printout = (PrintoutData)stack.method_57824((class_9331)ModRegistry.DataComponents.PRINTOUT.get());
                if (printout == null) {
                    ++pages;
                    continue;
                }
                hasPrintout = true;
                pages += printout.pages();
                continue;
            }
            ++inputs;
            stackedContents.method_20478(stack, 1);
        }
        return hasPrintout && printouts >= this.minPrintouts && pages <= 16 && inputs == this.ingredients.size() && stackedContents.method_7402((class_1860)this.innerRecipe, null);
    }

    public class_1799 method_17729(class_9694 inv, class_7225.class_7874 registries) {
        ArrayList<PrintoutData> data = new ArrayList<PrintoutData>();
        for (int j = 0; j < inv.method_59983(); ++j) {
            class_1799 stack = inv.method_59984(j);
            if (stack.method_7960() || !this.printout.method_8093(stack)) continue;
            data.add(PrintoutData.getOrEmpty((class_9322)stack));
        }
        if (data.isEmpty()) {
            throw new IllegalStateException("Printouts must be non-null");
        }
        List<PrintoutData.Line> lines = data.stream().flatMap(x -> x.lines().stream()).toList();
        class_1799 result = super.method_17729(inv, registries);
        result.method_57379((class_9331)ModRegistry.DataComponents.PRINTOUT.get(), (Object)new PrintoutData(((PrintoutData)data.getFirst()).title(), lines));
        return result;
    }

    public class_1865<?> method_8119() {
        return (class_1865)ModRegistry.RecipeSerializers.PRINTOUT.get();
    }
}

