/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.util.StringUtil;
import dan200.computercraft.shared.media.items.DiskItem;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlockEntity;
import dan200.computercraft.shared.peripheral.diskdrive.MediaStack;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9793;

public class DiskDrivePeripheral
implements IPeripheral {
    private final DiskDriveBlockEntity diskDrive;

    DiskDrivePeripheral(DiskDriveBlockEntity diskDrive) {
        this.diskDrive = diskDrive;
    }

    @Override
    public String getType() {
        return "drive";
    }

    @LuaFunction
    public final boolean isDiskPresent() {
        return !this.diskDrive.getMedia().stack().method_7960();
    }

    @Nullable
    @LuaFunction
    public final Object[] getDiskLabel() {
        Object[] objectArray;
        MediaStack media = this.diskDrive.getMedia();
        if (media.media() == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = media.media().getLabel((class_7225.class_7874)this.diskDrive.method_10997().method_30349(), media.stack());
        }
        return objectArray;
    }

    @LuaFunction(mainThread=true)
    public final void setDiskLabel(Optional<String> label) throws LuaException {
        switch (this.diskDrive.setDiskLabel(label.map(StringUtil::normaliseLabel).orElse(null))) {
            case NOT_ALLOWED: {
                throw new LuaException("Disk label cannot be changed");
            }
        }
    }

    @LuaFunction
    public final boolean hasData(IComputerAccess computer) {
        return this.diskDrive.getDiskMountPath(computer) != null;
    }

    @LuaFunction
    @Nullable
    public final String getMountPath(IComputerAccess computer) {
        return this.diskDrive.getDiskMountPath(computer);
    }

    @LuaFunction
    public final boolean hasAudio() {
        return this.diskDrive.getMedia().getAudio((class_7225.class_7874)this.diskDrive.method_10997().method_30349()) != null;
    }

    @LuaFunction
    @Nullable
    public final Object getAudioTitle() {
        MediaStack stack = this.diskDrive.getMedia();
        if (stack.media() == null) {
            return false;
        }
        class_6880<class_9793> audio = stack.getAudio((class_7225.class_7874)this.diskDrive.method_10997().method_30349());
        return audio == null ? null : ((class_9793)audio.comp_349()).comp_2836().getString();
    }

    @LuaFunction
    public final void playAudio() {
        this.diskDrive.playDiskAudio();
    }

    @LuaFunction
    public final void stopAudio() {
        this.diskDrive.stopDiskAudio();
    }

    @LuaFunction
    public final void ejectDisk() {
        this.diskDrive.ejectDisk();
    }

    @Nullable
    @LuaFunction
    public final Object[] getDiskID() {
        Object[] objectArray;
        class_1799 disk = this.diskDrive.getMedia().stack();
        if (disk.method_7909() instanceof DiskItem) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = DiskItem.getDiskID(disk);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.diskDrive.attach(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.diskDrive.detach(computer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable IPeripheral other) {
        if (this == other) return true;
        if (!(other instanceof DiskDrivePeripheral)) return false;
        DiskDrivePeripheral drive = (DiskDrivePeripheral)other;
        if (drive.diskDrive != this.diskDrive) return false;
        return true;
    }

    @Override
    public Object getTarget() {
        return this.diskDrive;
    }
}

