/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import com.google.auto.service.AutoService;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredElementLookup;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralLookup;
import dan200.computercraft.impl.Peripherals;
import dan200.computercraft.mixin.ArgumentTypeInfosAccessor;
import dan200.computercraft.shared.config.ConfigFile;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.FabricConfigFile;
import dan200.computercraft.shared.platform.FabricContainerTransfer;
import dan200.computercraft.shared.platform.FakePlayer;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RecipeIngredients;
import dan200.computercraft.shared.platform.RegistrationHelper;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_1838;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2314;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_9062;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import net.minecraft.class_9695;

@AutoService(value={PlatformHelper.class})
public class PlatformHelperImpl
implements PlatformHelper {
    @Override
    public ConfigFile.Builder createConfigBuilder() {
        return new FabricConfigFile.Builder();
    }

    private static <T> class_2378<T> getRegistry(class_5321<class_2378<T>> id) {
        class_2378 registry = (class_2378)class_7923.field_41167.method_10223(id.method_29177());
        if (registry == null) {
            throw new IllegalArgumentException("Unknown registry " + String.valueOf(id));
        }
        return registry;
    }

    @Override
    public <T> RegistrationHelper<T> createRegistrationHelper(class_5321<class_2378<T>> registry) {
        return new RegistrationHelperImpl<T>(PlatformHelperImpl.getRegistry(registry));
    }

    @Override
    public <A extends ArgumentType<?>, T extends class_2314.class_7217<A>, I extends class_2314<A, T>> I registerArgumentTypeInfo(Class<A> klass, I info) {
        ArgumentTypeInfosAccessor.classMap().put(klass, info);
        return info;
    }

    @Override
    public <C extends class_1703, T extends ContainerData> class_3917<C> createMenuType(class_9139<class_9129, T> codec, ContainerData.Factory<C, T> factory) {
        return new ExtendedScreenHandlerType(factory::create, codec);
    }

    @Override
    public void openMenu(class_1657 player, class_3908 owner, ContainerData menu) {
        player.method_17355(new WrappedMenuProvider<ContainerData>(owner, menu));
    }

    @Override
    public ComponentAccess<IPeripheral> createPeripheralAccess(class_2586 owner, Consumer<class_2350> invalidate) {
        return new PeripheralAccessImpl(owner);
    }

    @Override
    public ComponentAccess<WiredElement> createWiredElementAccess(class_2586 owner, Consumer<class_2350> invalidate) {
        return new ComponentAccessImpl<WiredElement>(owner, WiredElementLookup.get());
    }

    @Override
    public boolean hasWiredElementIn(class_1937 level, class_2338 pos, class_2350 direction) {
        return WiredElementLookup.get().find(level, pos.method_10093(direction), (Object)direction.method_10153()) != null;
    }

    @Override
    public ContainerTransfer.Slotted wrapContainer(class_1263 container) {
        return FabricContainerTransfer.of((SlottedStorage<ItemVariant>)InventoryStorage.of((class_1263)container, null));
    }

    @Override
    @Nullable
    public ContainerTransfer getContainer(class_3218 level, class_2338 pos, class_2350 side) {
        Storage storage = (Storage)ItemStorage.SIDED.find((class_1937)level, pos, (Object)side);
        if (storage != null) {
            return FabricContainerTransfer.of((Storage<ItemVariant>)storage);
        }
        class_1263 entity = InventoryUtil.getEntityContainer(level, pos, side);
        return entity == null ? null : FabricContainerTransfer.of((SlottedStorage<ItemVariant>)InventoryStorage.of((class_1263)entity, (class_2350)side));
    }

    @Override
    public RecipeIngredients getRecipeIngredients() {
        return new RecipeIngredients(class_1856.method_8106((class_6862)ConventionalItemTags.REDSTONE_DUSTS), class_1856.method_8106((class_6862)ConventionalItemTags.STRINGS), class_1856.method_8106((class_6862)ConventionalItemTags.LEATHERS), class_1856.method_8106((class_6862)ConventionalItemTags.GLASS_PANES), class_1856.method_8106((class_6862)ConventionalItemTags.GOLD_INGOTS), class_1856.method_8106((class_6862)ConventionalItemTags.STORAGE_BLOCKS_GOLD), class_1856.method_8106((class_6862)ConventionalItemTags.IRON_INGOTS), class_1856.method_8106((class_6862)ConventionalItemTags.DYES), class_1856.method_8106((class_6862)ConventionalItemTags.ENDER_PEARLS), class_1856.method_8106((class_6862)ConventionalItemTags.WOODEN_CHESTS));
    }

    @Override
    public List<class_6862<class_1792>> getDyeTags() {
        return List.of(ConventionalItemTags.WHITE_DYES, ConventionalItemTags.ORANGE_DYES, ConventionalItemTags.MAGENTA_DYES, ConventionalItemTags.LIGHT_BLUE_DYES, ConventionalItemTags.YELLOW_DYES, ConventionalItemTags.LIME_DYES, ConventionalItemTags.PINK_DYES, ConventionalItemTags.GRAY_DYES, ConventionalItemTags.LIGHT_GRAY_DYES, ConventionalItemTags.CYAN_DYES, ConventionalItemTags.PURPLE_DYES, ConventionalItemTags.BLUE_DYES, ConventionalItemTags.BROWN_DYES, ConventionalItemTags.GREEN_DYES, ConventionalItemTags.RED_DYES, ConventionalItemTags.BLACK_DYES);
    }

    @Override
    public int getBurnTime(class_1799 stack) {
        Integer fuel = (Integer)FuelRegistry.INSTANCE.get((class_1935)stack.method_7909());
        return fuel == null ? 0 : fuel;
    }

    @Override
    public class_1761.class_7913 newCreativeModeTab() {
        return FabricItemGroup.builder();
    }

    @Override
    public class_1799 getCraftingRemainingItem(class_1799 stack) {
        return stack.getRecipeRemainder();
    }

    @Override
    public List<class_1799> getRecipeRemainingItems(class_3222 player, class_1860<class_9694> recipe, class_9694 container) {
        return recipe.method_8111((class_9695)container);
    }

    @Override
    public void onItemCrafted(class_3222 player, class_9694 container, class_1799 stack) {
    }

    @Override
    public boolean onNotifyNeighbour(class_1937 level, class_2338 pos, class_2680 block, class_2350 direction) {
        return true;
    }

    @Override
    public class_3222 createFakePlayer(class_3218 world, GameProfile name) {
        return new FakePlayer(world, name);
    }

    @Override
    public boolean hasToolUsage(class_1799 stack) {
        class_1792 item = stack.method_7909();
        return item instanceof class_1821 || stack.method_31573(class_3489.field_42615) || item instanceof class_1794 || stack.method_31573(class_3489.field_42613);
    }

    @Override
    public class_1269 canAttackEntity(class_3222 player, class_1297 entity) {
        return ((AttackEntityCallback)AttackEntityCallback.EVENT.invoker()).interact((class_1657)player, player.method_37908(), class_1268.field_5808, entity, null);
    }

    @Override
    public boolean interactWithEntity(class_3222 player, class_1297 entity, class_243 hitPos) {
        return ((UseEntityCallback)UseEntityCallback.EVENT.invoker()).interact((class_1657)player, entity.method_37908(), class_1268.field_5808, entity, new class_3966(entity, hitPos)).method_23665() || entity.method_5664((class_1657)player, hitPos.method_1020(entity.method_19538()), class_1268.field_5808).method_23665() || player.method_7287(entity, class_1268.field_5808).method_23665();
    }

    @Override
    public class_1269 useOn(class_3222 player, class_1799 stack, class_3965 hit, Predicate<class_2680> canUseBlock) {
        class_9062 useResult;
        class_1269 result = ((UseBlockCallback)UseBlockCallback.EVENT.invoker()).interact((class_1657)player, player.method_37908(), class_1268.field_5808, hit);
        if (result != class_1269.field_5811) {
            return result;
        }
        class_2680 block = player.method_37908().method_8320(hit.method_17777());
        if (!block.method_26215() && canUseBlock.test(block) && (useResult = block.method_55780(stack, player.method_37908(), (class_1657)player, class_1268.field_5808, hit)).method_55643()) {
            return useResult.method_55645();
        }
        return stack.method_7981(new class_1838((class_1657)player, class_1268.field_5808, hit));
    }

    private static final class RegistrationHelperImpl<T>
    implements RegistrationHelper<T> {
        private final class_2378<T> registry;
        private final List<RegistryEntryImpl<? extends T>> entries = new ArrayList<RegistryEntryImpl<? extends T>>();

        private RegistrationHelperImpl(class_2378<T> registry) {
            this.registry = registry;
        }

        @Override
        public <U extends T> RegistryEntry<U> register(String name, Supplier<U> create) {
            RegistryEntryImpl<U> entry = new RegistryEntryImpl<U>(class_2960.method_60655((String)"computercraft", (String)name), create);
            this.entries.add(entry);
            return entry;
        }

        @Override
        public void register() {
            for (RegistryEntryImpl<T> entry : this.entries) {
                entry.register(this.registry);
            }
        }
    }

    private record WrappedMenuProvider<T extends ContainerData>(class_3908 owner, T menu) implements ExtendedScreenHandlerFactory<T>
    {
        @Nullable
        public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
            return this.owner.createMenu(id, inventory, player);
        }

        public class_2561 method_5476() {
            return this.owner.method_5476();
        }

        public T getScreenOpeningData(class_3222 player) {
            return this.menu;
        }
    }

    private static final class PeripheralAccessImpl
    extends ComponentAccessImpl<IPeripheral> {
        private PeripheralAccessImpl(class_2586 owner) {
            super(owner, PeripheralLookup.get());
        }

        @Override
        @Nullable
        public IPeripheral get(class_2350 direction) {
            IPeripheral result = (IPeripheral)super.get(direction);
            if (result != null) {
                return result;
            }
            BlockApiCache cache = this.caches[direction.ordinal()];
            return Peripherals.getGenericPeripheral(cache.getWorld(), cache.getPos(), direction.method_10153(), cache.getBlockEntity());
        }
    }

    private static class ComponentAccessImpl<T>
    implements ComponentAccess<T> {
        private final class_2586 owner;
        private final BlockApiLookup<T, class_2350> lookup;
        final BlockApiCache<T, class_2350>[] caches = new BlockApiCache[6];

        private ComponentAccessImpl(class_2586 owner, BlockApiLookup<T, class_2350> lookup) {
            this.owner = owner;
            this.lookup = lookup;
        }

        @Override
        @Nullable
        public T get(class_2350 direction) {
            BlockApiCache cache = this.caches[direction.ordinal()];
            if (cache == null) {
                BlockApiCache blockApiCache = BlockApiCache.create(this.lookup, (class_3218)this.getLevel(), (class_2338)this.owner.method_11016().method_10093(direction));
                this.caches[direction.ordinal()] = blockApiCache;
                cache = blockApiCache;
            }
            return (T)cache.find((Object)direction.method_10153());
        }

        private class_3218 getLevel() {
            return Objects.requireNonNull((class_3218)this.owner.method_10997(), "Block entity is not in a level");
        }
    }

    private static final class RegistryEntryImpl<T>
    implements RegistryEntry<T> {
        private final class_2960 id;
        private final Supplier<T> supplier;
        @Nullable
        private T instance;

        RegistryEntryImpl(class_2960 id, Supplier<T> supplier) {
            this.id = id;
            this.supplier = supplier;
        }

        void register(class_2378<? super T> registry) {
            this.instance = this.supplier.get();
            class_2378.method_10230(registry, (class_2960)this.id, this.instance);
        }

        @Override
        public class_2960 id() {
            return this.id;
        }

        @Override
        public T get() {
            if (this.instance == null) {
                throw new IllegalStateException(String.valueOf(this.id) + " has not been constructed yet");
            }
            return this.instance;
        }
    }
}

