/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.network.client.PocketComputerDataMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.pocket.core.PocketHolder;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9282;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

public final class PocketBrain
implements IPocketAccess {
    private final PocketServerComputer computer;
    private PocketHolder holder;
    private class_243 position;
    private boolean dirty = false;
    @Nullable
    private UpgradeData<IPocketUpgrade> upgrade;
    private int colour = -1;
    private int lightColour = -1;

    public PocketBrain(PocketHolder holder, int computerID, @Nullable String label, ComputerFamily family, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        this.computer = new PocketServerComputer(this, holder, computerID, label, family);
        this.holder = holder;
        this.position = holder.pos();
        this.upgrade = upgrade;
        this.invalidatePeripheral();
    }

    public PocketServerComputer computer() {
        return this.computer;
    }

    PocketHolder holder() {
        return this.holder;
    }

    public void updateHolder(PocketHolder newHolder) {
        PocketHolder.PlayerHolder player;
        class_3222 oldPlayer;
        this.position = newHolder.pos();
        this.computer.setPosition(newHolder.level(), newHolder.blockPos());
        PocketHolder oldHolder = this.holder;
        if (this.holder.equals(newHolder)) {
            return;
        }
        this.holder = newHolder;
        if (oldHolder instanceof PocketHolder.PlayerHolder) {
            PocketHolder.PlayerHolder p = (PocketHolder.PlayerHolder)oldHolder;
            v0 = p.entity();
        } else {
            v0 = oldPlayer = null;
        }
        if (newHolder instanceof PocketHolder.PlayerHolder && (player = (PocketHolder.PlayerHolder)newHolder).entity() != oldPlayer) {
            ServerNetworking.sendToPlayer(new PocketComputerDataMessage(this.computer, true), player.entity());
        }
    }

    public boolean updateItem(class_1799 stack) {
        if (!this.dirty) {
            return false;
        }
        this.dirty = false;
        stack.method_57379(class_9334.field_49644, (Object)(this.colour == -1 ? null : new class_9282(this.colour, false)));
        PocketComputerItem.setUpgrade(stack, this.upgrade);
        return true;
    }

    @Override
    public class_3218 getLevel() {
        return this.computer.getLevel();
    }

    @Override
    public class_243 getPosition() {
        return this.position;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public class_1297 getEntity() {
        PocketHolder pocketHolder = this.holder;
        if (!(pocketHolder instanceof PocketHolder.EntityHolder)) return null;
        PocketHolder.EntityHolder entity = (PocketHolder.EntityHolder)pocketHolder;
        if (!this.holder.isValid(this.computer)) return null;
        class_1297 class_12972 = entity.entity();
        return class_12972;
    }

    @Override
    public int getColour() {
        return this.colour;
    }

    @Override
    public void setColour(int colour) {
        if (this.colour == colour) {
            return;
        }
        this.dirty = true;
        this.colour = colour;
    }

    @Override
    public int getLight() {
        return this.lightColour;
    }

    @Override
    public void setLight(int colour) {
        if (colour < 0 || colour > 0xFFFFFF) {
            colour = -1;
        }
        this.lightColour = colour;
    }

    @Override
    public class_9326 getUpgradeData() {
        UpgradeData<IPocketUpgrade> upgrade = this.upgrade;
        return upgrade == null ? class_9326.field_49588 : upgrade.data();
    }

    @Override
    public void setUpgradeData(class_9326 data) {
        UpgradeData<IPocketUpgrade> upgrade = this.upgrade;
        if (upgrade == null) {
            return;
        }
        this.upgrade = UpgradeData.of(upgrade.holder(), data);
    }

    @Override
    public void invalidatePeripheral() {
        IPeripheral peripheral = this.upgrade == null ? null : this.upgrade.upgrade().createPeripheral(this);
        this.computer.setPeripheral(ComputerSide.BACK, peripheral);
    }

    @Override
    @Nullable
    public UpgradeData<IPocketUpgrade> getUpgrade() {
        return this.upgrade;
    }

    @Override
    public void setUpgrade(@Nullable UpgradeData<IPocketUpgrade> upgrade) {
        this.upgrade = upgrade;
        this.dirty = true;
        this.invalidatePeripheral();
    }
}

