/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.recipe.function.RecipeFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9694;

public final class CopyComponents
implements RecipeFunction {
    public static final MapCodec<CopyComponents> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46096.fieldOf("from").forGetter(x -> x.from), (App)class_9331.field_49600.listOf().optionalFieldOf("include").forGetter(x -> x.include), (App)class_9331.field_49600.listOf().optionalFieldOf("exclude").forGetter(x -> x.exclude)).apply((Applicative)instance, CopyComponents::new));
    public static final class_9139<class_9129, CopyComponents> STREAM_CODEC = class_9139.method_56436((class_9139)class_1856.field_48355, x -> x.from, (class_9139)class_9135.method_56382((class_9139)class_9331.field_49601.method_56433(class_9135.method_56363())), x -> x.include, (class_9139)class_9135.method_56382((class_9139)class_9331.field_49601.method_56433(class_9135.method_56363())), x -> x.exclude, CopyComponents::new);
    private final class_1856 from;
    private final Optional<List<class_9331<?>>> include;
    private final Optional<List<class_9331<?>>> exclude;
    @Nullable
    private final Set<class_9331<?>> includeSet;
    @Nullable
    private final Set<class_9331<?>> excludeSet;

    public CopyComponents(class_1856 from) {
        this(from, Optional.empty(), Optional.empty());
    }

    public CopyComponents(class_1935 from) {
        this(class_1856.method_8091((class_1935[])new class_1935[]{from}));
    }

    private CopyComponents(class_1856 from, Optional<List<class_9331<?>>> include, Optional<List<class_9331<?>>> exclude) {
        this.from = from;
        this.include = include.map(List::copyOf);
        this.exclude = exclude.map(List::copyOf);
        this.includeSet = include.map(Set::copyOf).orElse(null);
        this.excludeSet = exclude.map(Set::copyOf).orElse(null);
    }

    @Override
    public RecipeFunction.Type<?> getType() {
        return (RecipeFunction.Type)ModRegistry.RecipeFunctions.COPY_COMPONENTS.get();
    }

    @Override
    public class_1799 apply(class_9694 container, class_1799 result) {
        for (class_1799 item : container.method_59989()) {
            if (!this.from.method_8093(item)) continue;
            this.applyPatch(item.method_57380(), result);
            break;
        }
        return result;
    }

    private void applyPatch(class_9326 patch, class_1799 result) {
        if (this.includeSet == null && this.excludeSet == null) {
            result.method_57366(patch);
            return;
        }
        for (Map.Entry component : patch.method_57846()) {
            class_9331 type = (class_9331)component.getKey();
            if (this.includeSet != null && !this.includeSet.contains(type) || this.excludeSet != null && this.excludeSet.contains(type)) continue;
            CopyComponents.unsafeSetComponent(result, type, ((Optional)component.getValue()).orElse(null));
        }
    }

    private static <T> void unsafeSetComponent(class_1799 stack, class_9331<?> type, @Nullable T value) {
        stack.method_57379(type, value);
    }

    public static Builder builder(class_1856 ingredient) {
        return new Builder(ingredient);
    }

    public static Builder builder(class_1935 ingredient) {
        return new Builder(class_1856.method_8091((class_1935[])new class_1935[]{ingredient}));
    }

    public static final class Builder {
        private final class_1856 from;
        @Nullable
        private List<class_9331<?>> include;
        @Nullable
        private List<class_9331<?>> exclude;

        private Builder(class_1856 from) {
            this.from = from;
        }

        public Builder include(class_9331<?> type) {
            if (this.include == null) {
                this.include = new ArrayList();
            }
            this.include.add(type);
            return this;
        }

        public Builder exclude(class_9331<?> type) {
            if (this.exclude == null) {
                this.exclude = new ArrayList();
            }
            this.exclude.add(type);
            return this;
        }

        public CopyComponents build() {
            return new CopyComponents(this.from, Optional.ofNullable(this.include), Optional.ofNullable(this.exclude));
        }
    }
}

