/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.component.ComputerComponents;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.container.BasicContainer;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.inventory.TurtleMenu;
import dan200.computercraft.shared.util.ComponentMap;
import java.util.Collections;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9282;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class TurtleBlockEntity
extends AbstractComputerBlockEntity
implements BasicContainer {
    public static final int INVENTORY_SIZE = 16;
    public static final int INVENTORY_WIDTH = 4;
    public static final int INVENTORY_HEIGHT = 4;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
    private final class_2371<class_1799> inventorySnapshot = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
    private boolean inventoryChanged = false;
    private final IntSupplier fuelLimit;
    private TurtleBrain brain = new TurtleBrain(this);
    private MoveState moveState = MoveState.NOT_MOVED;
    @Nullable
    private IPeripheral peripheral;

    public TurtleBlockEntity(class_2591<? extends TurtleBlockEntity> type, class_2338 pos, class_2680 state, IntSupplier fuelLimit, ComputerFamily family) {
        super(type, pos, state, family);
        this.fuelLimit = fuelLimit;
    }

    boolean hasMoved() {
        return this.moveState == MoveState.MOVED;
    }

    @Override
    protected ServerComputer createComputer(int id) {
        ServerComputer computer = new ServerComputer((class_3218)this.method_10997(), this.method_11016(), id, this.label, this.getFamily(), 39, 13, ComponentMap.builder().add(ComputerComponents.TURTLE, this.brain).build());
        this.brain.setupComputer(computer);
        return computer;
    }

    @Override
    protected void unload() {
        if (!this.hasMoved()) {
            super.unload();
        }
    }

    @Override
    protected float getInteractRange() {
        return 8.0f;
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        this.brain.update();
        if (this.inventoryChanged) {
            ServerComputer computer = this.getServerComputer();
            if (computer != null) {
                computer.queueEvent("turtle_inventory");
            }
            this.inventoryChanged = false;
        }
    }

    protected void clientTick() {
        this.brain.update();
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
    }

    @Override
    public void neighborChanged(class_2338 neighbour) {
        if (this.moveState == MoveState.NOT_MOVED) {
            super.neighborChanged(neighbour);
        }
    }

    public void notifyMoveStart() {
        if (this.moveState == MoveState.NOT_MOVED) {
            this.moveState = MoveState.IN_PROGRESS;
        }
    }

    public void notifyMoveEnd() {
        if (this.moveState == MoveState.IN_PROGRESS) {
            this.moveState = MoveState.NOT_MOVED;
        }
    }

    @Override
    public void loadServer(class_2487 nbt, class_7225.class_7874 registries) {
        super.loadServer(nbt, registries);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registries);
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventorySnapshot.set(i, (Object)((class_1799)this.inventory.get(i)).method_7972());
        }
        this.brain.readFromNBT(nbt, registries);
    }

    @Override
    public void method_11007(class_2487 nbt, class_7225.class_7874 registries) {
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registries);
        this.brain.writeToNBT(nbt, registries);
        super.method_11007(nbt, registries);
    }

    @Override
    protected void method_57568(class_2586.class_9473 component) {
        super.method_57568(component);
        class_9282 colour = (class_9282)component.method_58694(class_9334.field_49644);
        if (colour != null) {
            this.brain.setColour(colour.comp_2384());
        }
        this.brain.setFuelLevel((Integer)component.method_58695((class_9331)ModRegistry.DataComponents.FUEL.get(), (Object)0));
        this.brain.setOverlay((class_6880<TurtleOverlay>)((class_6880)component.method_58694((class_9331)ModRegistry.DataComponents.OVERLAY.get())));
        this.brain.setUpgrade(TurtleSide.LEFT, (UpgradeData)component.method_58694((class_9331)ModRegistry.DataComponents.LEFT_TURTLE_UPGRADE.get()));
        this.brain.setUpgrade(TurtleSide.RIGHT, (UpgradeData)component.method_58694((class_9331)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get()));
    }

    @Override
    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840(class_9334.field_49644, (Object)(this.brain.getColour() == -1 ? null : new class_9282(this.brain.getColour(), false)));
        builder.method_57840((class_9331)ModRegistry.DataComponents.OVERLAY.get(), this.brain.getOverlay());
        builder.method_57840((class_9331)ModRegistry.DataComponents.FUEL.get(), (Object)this.brain.getFuelLevel());
        builder.method_57840((class_9331)ModRegistry.DataComponents.LEFT_TURTLE_UPGRADE.get(), TurtleBlockEntity.withPersistedData(this.brain.getUpgradeWithData(TurtleSide.LEFT)));
        builder.method_57840((class_9331)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), TurtleBlockEntity.withPersistedData(this.brain.getUpgradeWithData(TurtleSide.RIGHT)));
    }

    @Nullable
    private static UpgradeData<ITurtleUpgrade> withPersistedData(@Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        return upgrade == null ? null : UpgradeData.of(upgrade.holder(), upgrade.upgrade().getPersistedData(upgrade.data()));
    }

    @Override
    @Deprecated
    public void method_57569(class_2487 tag) {
        super.method_57569(tag);
        tag.method_10551("Color");
        tag.method_10551("Fuel");
        tag.method_10551("Overlay");
        tag.method_10551("LeftUpgrade");
        tag.method_10551("RightUpgrade");
    }

    @Override
    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return this.hasPeripheralUpgradeOnSide(localSide);
    }

    @Override
    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)TurtleBlock.FACING);
    }

    public void setDirection(class_2350 dir) {
        if (dir.method_10166() == class_2350.class_2351.field_11052) {
            dir = class_2350.field_11043;
        }
        this.method_10997().method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)TurtleBlock.FACING, (Comparable)dir));
        this.updateRedstone();
        this.updateInputsImmediately();
        this.onTileEntityChange();
    }

    @Nullable
    public ITurtleUpgrade getUpgrade(TurtleSide side) {
        return this.brain.getUpgrade(side);
    }

    public int getColour() {
        return this.brain.getColour();
    }

    @Nullable
    public TurtleOverlay getOverlay() {
        class_6880<TurtleOverlay> overlay = this.brain.getOverlay();
        return overlay == null ? null : (TurtleOverlay)overlay.comp_349();
    }

    public ITurtleAccess getAccess() {
        return this.brain;
    }

    public class_243 getRenderOffset(float f) {
        return this.brain.getRenderOffset(f);
    }

    public float getRenderYaw(float f) {
        return this.brain.getVisualYaw(f);
    }

    public float getToolRenderAngle(TurtleSide side, float f) {
        return this.brain.getToolRenderAngle(side, f);
    }

    void setOwningPlayer(GameProfile player) {
        this.brain.setOwningPlayer(player);
        this.onTileEntityChange();
    }

    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_1799 getItemSnapshot(int slot) {
        return slot >= 0 && slot < this.inventorySnapshot.size() ? (class_1799)this.inventorySnapshot.get(slot) : class_1799.field_8037;
    }

    public void method_5431() {
        super.method_5431();
        for (int slot = 0; slot < this.method_5439(); ++slot) {
            class_1799 item = this.method_5438(slot);
            if (class_1799.method_7973((class_1799)item, (class_1799)((class_1799)this.inventorySnapshot.get(slot)))) continue;
            this.inventoryChanged = true;
            this.inventorySnapshot.set(slot, (Object)item.method_7972());
        }
    }

    public boolean method_5443(class_1657 player) {
        return this.isUsable(player);
    }

    public void onTileEntityChange() {
        super.method_5431();
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 nbt = super.method_16887(registries);
        this.brain.writeDescription(nbt, registries);
        return nbt;
    }

    @Override
    public void loadClient(class_2487 nbt, class_7225.class_7874 registries) {
        super.loadClient(nbt, registries);
        this.brain.readDescription(nbt, registries);
    }

    public int getFuelLimit() {
        return this.fuelLimit.getAsInt();
    }

    private boolean hasPeripheralUpgradeOnSide(ComputerSide side) {
        ITurtleUpgrade upgrade;
        switch (side) {
            case RIGHT: {
                upgrade = this.getUpgrade(TurtleSide.RIGHT);
                break;
            }
            case LEFT: {
                upgrade = this.getUpgrade(TurtleSide.LEFT);
                break;
            }
            default: {
                return false;
            }
        }
        return upgrade != null && upgrade.getUpgradeType().isPeripheral();
    }

    public void transferStateFrom(TurtleBlockEntity copy) {
        super.transferStateFrom(copy);
        Collections.copy(this.inventory, copy.inventory);
        Collections.copy(this.inventorySnapshot, copy.inventorySnapshot);
        this.inventoryChanged = copy.inventoryChanged;
        this.brain = copy.brain;
        this.brain.setOwner(this);
        copy.moveState = MoveState.MOVED;
        PlatformHelper.get().invalidateComponent(this);
    }

    @Nullable
    public IPeripheral peripheral() {
        if (this.hasMoved()) {
            return null;
        }
        if (this.peripheral != null) {
            return this.peripheral;
        }
        this.peripheral = new ComputerPeripheral("turtle", this);
        return this.peripheral;
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return TurtleMenu.ofBrain(id, inventory, this.brain);
    }

    static enum MoveState {
        NOT_MOVED,
        IN_PROGRESS,
        MOVED;

    }
}

