/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.InventoryUtil;
import java.util.List;
import net.minecraft.class_1301;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_3218;

public class TurtleSuckCommand
implements TurtleCommand {
    private final InteractDirection direction;
    private final int quantity;

    public TurtleSuckCommand(InteractDirection direction, int quantity) {
        this.direction = direction;
        this.quantity = quantity;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        if (this.quantity == 0) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        class_2350 direction = this.direction.toWorldDir(turtle);
        class_1937 world = turtle.getLevel();
        class_2338 turtlePosition = turtle.getPosition();
        class_2338 blockPosition = turtlePosition.method_10093(direction);
        class_2350 side = direction.method_10153();
        ContainerTransfer inventory = PlatformHelper.get().getContainer((class_3218)world, blockPosition, side);
        if (inventory != null) {
            int transferred = inventory.moveTo(TurtleUtil.getOffsetInventory(turtle), this.quantity);
            switch (transferred) {
                case -2: {
                    return TurtleCommandResult.failure("No space for items");
                }
                case -1: {
                    return TurtleCommandResult.failure("No items to take");
                }
            }
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        class_238 aabb = new class_238((double)blockPosition.method_10263(), (double)blockPosition.method_10264(), (double)blockPosition.method_10260(), (double)blockPosition.method_10263() + 1.0, (double)blockPosition.method_10264() + 1.0, (double)blockPosition.method_10260() + 1.0);
        List list = world.method_8390(class_1542.class, aabb, class_1301.field_6154);
        if (list.isEmpty()) {
            return TurtleCommandResult.failure("No items to take");
        }
        for (class_1542 entity : list) {
            class_1799 leaveStack;
            class_1799 storeStack;
            class_1799 stack = entity.method_6983().method_7972();
            if (stack.method_7947() > this.quantity) {
                storeStack = stack.method_7971(this.quantity);
                leaveStack = stack;
            } else {
                storeStack = stack;
                leaveStack = class_1799.field_8037;
            }
            int oldCount = storeStack.method_7947();
            class_1799 remainder = InventoryUtil.storeItemsFromOffset(turtle.getInventory(), storeStack, turtle.getSelectedSlot());
            if (remainder.method_7947() == oldCount) continue;
            if (remainder.method_7960() && leaveStack.method_7960()) {
                entity.method_31472();
            } else if (remainder.method_7960()) {
                entity.method_6979(leaveStack);
            } else if (leaveStack.method_7960()) {
                entity.method_6979(remainder);
            } else {
                leaveStack.method_7933(remainder.method_7947());
                entity.method_6979(leaveStack);
            }
            world.method_8474(1000, turtlePosition, 0);
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("No space for items");
    }
}

