/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.api.component.ComputerComponent;
import dan200.computercraft.core.metrics.MetricsObserver;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class ComponentMap {
    public static final ComputerComponent<MetricsObserver> METRICS = ComputerComponent.create("computercraft", "metrics");
    private static final ComponentMap EMPTY = new ComponentMap(Map.of());
    private final Map<ComputerComponent<?>, Object> components;

    private ComponentMap(Map<ComputerComponent<?>, Object> components) {
        this.components = components;
    }

    @Nullable
    public <T> T get(ComputerComponent<T> component) {
        return (T)this.components.get(component);
    }

    public static ComponentMap empty() {
        return EMPTY;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<ComputerComponent<?>, Object> components = new HashMap();

        private Builder() {
        }

        public <T> Builder add(ComputerComponent<T> component, T value) {
            this.addImpl(component, value);
            return this;
        }

        public Builder add(ComponentMap components) {
            for (Map.Entry<ComputerComponent<?>, Object> component : components.components.entrySet()) {
                this.addImpl(component.getKey(), component.getValue());
            }
            return this;
        }

        private void addImpl(ComputerComponent<?> component, Object value) {
            if (this.components.containsKey(component)) {
                throw new IllegalArgumentException(String.valueOf(component) + " is already set");
            }
            this.components.put(component, value);
        }

        public ComponentMap build() {
            return new ComponentMap(Map.copyOf(this.components));
        }
    }
}

