/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import dan200.computercraft.shared.media.items.PrintoutData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1208;
import net.minecraft.class_9267;

public class ComponentizationFixers {
    private static final String TURTLE_NORMAL = "computercraft:turtle_normal";
    private static final String TURTLE_ADVANCED = "computercraft:turtle_advanced";
    private static final Set<String> COMPUTER = Set.of("computercraft:computer_normal", "computercraft:computer_advanced");
    private static final Set<String> TURTLES = Set.of("computercraft:turtle_normal", "computercraft:turtle_advanced");
    private static final Set<String> POCKET_COMPUTERS = Set.of("computercraft:pocket_computer_normal", "computercraft:pocket_computer_advanced");
    private static final Set<String> ALL_COMPUTERS = Stream.of(COMPUTER, TURTLES, POCKET_COMPUTERS).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    private static final Set<String> PRINTOUTS = Set.of("computercraft:printed_page", "computercraft:printed_pages", "computercraft:printed_book");
    private static final String DISK = "computercraft:disk";
    private static final String TREASURE_DISK = "computercraft:treasure_disk";
    private static final Set<String> DYEABLE = Stream.concat(Stream.of(TURTLES, POCKET_COMPUTERS).flatMap(Collection::stream), Stream.of("computercraft:disk")).collect(Collectors.toUnmodifiableSet());

    public static void fixItemComponents(class_9267.class_9268 item, Dynamic<?> ops) {
        if (item.method_57269(ALL_COMPUTERS)) {
            item.method_57266("ComputerId", "computercraft:computer_id");
        }
        if (item.method_57269(DYEABLE)) {
            ComponentizationFixers.moveColourToComponent(item, ops, "Color");
        }
        if (item.method_57269(POCKET_COMPUTERS)) {
            item.method_57266("On", "computercraft:on");
            ComponentizationFixers.moveUpgradeToComponent(item, ops, "Upgrade", "UpgradeInfo", "computercraft:pocket_upgrade");
            item.method_57262("InstanceId");
            item.method_57262("SessionId");
        }
        if (item.method_57269(TURTLES)) {
            item.method_57266("Fuel", "computercraft:fuel");
            item.method_57262("Overlay").result().ifPresent(x -> item.method_57263("computercraft:overlay", ComponentizationFixers.fixOverlay(x)));
            ComponentizationFixers.moveUpgradeToComponent(item, ops, "LeftUpgrade", "LeftUpgradeNbt", "computercraft:left_turtle_upgrade");
            ComponentizationFixers.moveUpgradeToComponent(item, ops, "RightUpgrade", "RightUpgradeNbt", "computercraft:right_turtle_upgrade");
        }
        if (item.method_57270(DISK)) {
            item.method_57266("DiskId", "computercraft:disk_id");
        }
        if (item.method_57270(TREASURE_DISK)) {
            Optional name = item.method_57262("Title").asString().result();
            Optional path = item.method_57262("SubPath").asString().result();
            if (name.isPresent() && path.isPresent()) {
                item.method_57263(TREASURE_DISK, ops.emptyMap().set("name", ops.createString((String)name.get())).set("path", ops.createString((String)path.get())));
            }
            ComponentizationFixers.moveColourToComponent(item, ops, "Colour");
        }
        if (item.method_57269(PRINTOUTS)) {
            ComponentizationFixers.movePrintoutToComponent(item, ops);
        }
    }

    private static void moveUpgradeToComponent(class_9267.class_9268 data, Dynamic<?> ops, String key, String dataKey, String component) {
        String upgrade = data.method_57262(key).asString(null);
        if (upgrade == null) {
            return;
        }
        data.method_57263(component, ComponentizationFixers.createUpgradeData(ops, upgrade, data.method_57262(dataKey)));
    }

    private static void moveColourToComponent(class_9267.class_9268 item, Dynamic<?> ops, String key) {
        item.method_57262(key).asNumber().result().map(Number::intValue).ifPresent(col -> item.method_57263("minecraft:dyed_color", ops.emptyMap().set("rgb", ops.createInt(col.intValue())).set("show_in_tooltip", ops.createBoolean(false))));
    }

    private static void movePrintoutToComponent(class_9267.class_9268 item, Dynamic<?> ops) {
        String title = item.method_57262("Title").asString("");
        int pages = item.method_57262("Pages").asInt(0);
        if (pages <= 0) {
            return;
        }
        ArrayList<Dynamic> lines = new ArrayList<Dynamic>(pages * 21);
        for (int i = 0; i < pages * 21; ++i) {
            String text = item.method_57262("Text" + i).asString(PrintoutData.Line.EMPTY.text());
            String colour = item.method_57262("Color" + i).asString(PrintoutData.Line.EMPTY.foreground());
            lines.add(ops.emptyMap().set("text", ops.createString(text)).set("foreground", ops.createString(colour)));
        }
        item.method_57263("computercraft:printout", ops.emptyMap().set("title", ops.createString(title)).set("lines", ops.createList(lines.stream())));
    }

    public static Function<Typed<?>, Typed<?>> makeBlockEntityRewrites(Schema input, Schema output) {
        return ComponentizationFixers.fixTurtleBlockEntity(input, output, TURTLE_NORMAL).compose(ComponentizationFixers.fixTurtleBlockEntity(input, output, TURTLE_ADVANCED));
    }

    private static Function<Typed<?>, Typed<?>> fixTurtleBlockEntity(Schema inputSchema, Schema outputSchema, String name) {
        OpticFinder input = DSL.namedChoice((String)name, (Type)inputSchema.getChoiceType(class_1208.field_5727, name));
        Type output = outputSchema.getChoiceType(class_1208.field_5727, name);
        return typed -> typed.updateTyped(input, output, typed2 -> typed2.update(DSL.remainderFinder(), x -> {
            x = ComponentizationFixers.moveUpgradeData(x, "LeftUpgrade", "LeftUpgradeNbt");
            x = ComponentizationFixers.moveUpgradeData(x, "RightUpgrade", "RightUpgradeNbt");
            x = x.update("Overlay", ComponentizationFixers::fixOverlay);
            return x;
        }));
    }

    private static Dynamic<?> moveUpgradeData(Dynamic<?> ops, String key, String dataKey) {
        String upgradeId = ops.get(key).asString(null);
        if (upgradeId == null) {
            return ops;
        }
        return ops.set(key, ComponentizationFixers.createUpgradeData(ops, upgradeId, ops.get(dataKey))).remove(dataKey);
    }

    private static Dynamic<?> fixOverlay(Dynamic<?> overlay) {
        String overlayId = overlay.asString(null);
        if (overlayId == null) {
            return overlay;
        }
        return switch (overlayId) {
            case "computercraft:block/turtle_trans_overlay" -> overlay.createString("computercraft:trans_flag");
            case "computercraft:block/turtle_rainbow_overlay" -> overlay.createString("computercraft:rainbow_flag");
            default -> overlay.emptyMap().set("model", overlay);
        };
    }

    private static Dynamic<?> createUpgradeData(Dynamic<?> ops, String upgradeId, OptionalDynamic<?> upgradeData) {
        Dynamic newUpgrade = ops.emptyMap().set("id", ops.createString(upgradeId));
        Dynamic data = upgradeData.result().orElse(null);
        if (data != null && !data.equals((Object)ops.emptyMap())) {
            newUpgrade = newUpgrade.set("components", ops.emptyMap().set("minecraft:custom_data", data));
        }
        return newUpgrade;
    }

    public static TypeTemplate addExtraTypes(TypeTemplate type, Schema schema) {
        TypeTemplate upgradeData = DSL.optionalFields((String)"components", (TypeTemplate)class_1208.field_49205.in(schema));
        return ComponentizationFixers.extraOptionalFields(type, Pair.of((Object)"computercraft:pocket_upgrade", (Object)upgradeData), Pair.of((Object)"computercraft:left_turtle_upgrade", (Object)upgradeData), Pair.of((Object)"computercraft:right_turtle_upgrade", (Object)upgradeData));
    }

    @SafeVarargs
    private static TypeTemplate extraOptionalFields(TypeTemplate base, Pair<String, TypeTemplate> ... fields) {
        return DSL.and(Stream.concat(Arrays.stream(fields).map(entry -> DSL.optional((TypeTemplate)DSL.field((String)((String)entry.getFirst()), (TypeTemplate)((TypeTemplate)entry.getSecond())))), Stream.of(base)).toList());
    }
}

