/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.capability.ChunkLoaderCache;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;

public class ClientChunkLoadingCapability
extends ChunkLoadingCapability {
    public ClientChunkLoadingCapability(class_1937 level) {
        super(level);
    }

    public void addChunkLoader(class_2338 pos, UUID owner, ChunkLoaderType type) {
        class_1923 chunkPos = new class_1923(pos);
        this.chunkLoadersPerChunk.putIfAbsent(chunkPos, new HashSet());
        ((Set)this.chunkLoadersPerChunk.get(chunkPos)).add(pos);
        this.chunkLoadersPerPlayer.putIfAbsent(owner, new HashSet());
        ((Set)this.chunkLoadersPerPlayer.get(owner)).add(pos);
        this.chunkLoaderCacheMap.put(pos, new ChunkLoaderCache(pos, type, owner));
        int centerChunkX = pos.method_10263() >> 4;
        int centerChunkZ = pos.method_10260() >> 4;
        int range = type.getRange();
        this.availableChunksPerPlayer.putIfAbsent(owner, new HashSet());
        for (int x = -range + 1; x < range; ++x) {
            for (int z = -range + 1; z < range; ++z) {
                ((Set)this.availableChunksPerPlayer.get(owner)).add(new class_1923(centerChunkX + x, centerChunkZ + z));
            }
        }
    }

    public void removeChunkLoader(class_2338 pos, UUID owner, ChunkLoaderType type) {
        class_1923 chunkPos = new class_1923(pos);
        Set chunkLoadersPerChunk = (Set)this.chunkLoadersPerChunk.get(chunkPos);
        if (chunkLoadersPerChunk != null && chunkLoadersPerChunk.contains(pos)) {
            chunkLoadersPerChunk.remove(pos);
            if (chunkLoadersPerChunk.isEmpty()) {
                this.chunkLoadersPerChunk.remove(chunkPos);
            }
            Set chunkLoadersPerPlayer = (Set)this.chunkLoadersPerPlayer.get(owner);
            chunkLoadersPerPlayer.remove(pos);
            if (chunkLoadersPerPlayer.isEmpty()) {
                this.chunkLoadersPerPlayer.remove(owner);
            }
            this.chunkLoaderCacheMap.remove(pos);
            Set loadedChunksPerPlayer = (Set)this.loadedChunksPerPlayer.get(owner);
            Set availableChunksPerPlayer = (Set)this.availableChunksPerPlayer.get(owner);
            int radius = type.getRange();
            for (int x = -radius + 1; x < radius; ++x) {
                block1: for (int z = -radius + 1; z < radius; ++z) {
                    Set players;
                    Set inactivePlayer;
                    class_1923 otherChunk = new class_1923(chunkPos.field_9181 + x, chunkPos.field_9180 + z);
                    if (this.chunkLoadersPerPlayer.containsKey(owner)) {
                        for (class_2338 chunkLoaderPos : (Set)this.chunkLoadersPerPlayer.get(owner)) {
                            int chunkLoaderChunkX = chunkLoaderPos.method_10263() >> 4;
                            int chunkLoaderChunkZ = chunkLoaderPos.method_10260() >> 4;
                            ChunkLoaderType otherType = ((ChunkLoaderCache)this.chunkLoaderCacheMap.get((Object)chunkLoaderPos)).chunkLoaderType;
                            if (Math.abs(chunkLoaderChunkX - otherChunk.field_9181) >= otherType.getRange() || Math.abs(chunkLoaderChunkZ - otherChunk.field_9180) >= otherType.getRange()) continue;
                            continue block1;
                        }
                    }
                    if ((inactivePlayer = (Set)this.inactivePlayersPerLoadedChunk.get(chunkPos)) != null) {
                        inactivePlayer.remove(owner);
                        if (inactivePlayer.isEmpty()) {
                            this.inactivePlayersPerLoadedChunk.remove(chunkPos);
                        }
                    }
                    if ((players = (Set)this.activePlayersPerLoadedChunk.get(chunkPos)) != null) {
                        players.remove(owner);
                        if (players.isEmpty()) {
                            this.activePlayersPerLoadedChunk.remove(chunkPos);
                        }
                    }
                    if (loadedChunksPerPlayer != null) {
                        loadedChunksPerPlayer.remove(otherChunk);
                    }
                    if (availableChunksPerPlayer == null) continue;
                    availableChunksPerPlayer.remove(otherChunk);
                }
            }
            if (loadedChunksPerPlayer != null && loadedChunksPerPlayer.isEmpty()) {
                this.loadedChunksPerPlayer.remove(owner);
            }
            if (availableChunksPerPlayer != null && availableChunksPerPlayer.isEmpty()) {
                this.availableChunksPerPlayer.remove(owner);
            }
        }
    }

    public void startLoadingChunk(UUID player, class_1923 chunkPos, boolean active) {
        if (active) {
            this.activePlayersPerLoadedChunk.putIfAbsent(chunkPos, new HashSet());
            ((Set)this.activePlayersPerLoadedChunk.get(chunkPos)).add(player);
        } else {
            this.inactivePlayersPerLoadedChunk.putIfAbsent(chunkPos, new HashSet());
            ((Set)this.inactivePlayersPerLoadedChunk.get(chunkPos)).add(player);
        }
        this.loadedChunksPerPlayer.putIfAbsent(player, new HashSet());
        ((Set)this.loadedChunksPerPlayer.get(player)).add(chunkPos);
    }

    public void stopLoadingChunk(UUID player, class_1923 chunkPos) {
        Set loadedChunksPerPlayer;
        Set players;
        Set inactivePlayer = (Set)this.inactivePlayersPerLoadedChunk.get(chunkPos);
        if (inactivePlayer != null) {
            inactivePlayer.remove(player);
            if (inactivePlayer.isEmpty()) {
                this.inactivePlayersPerLoadedChunk.remove(chunkPos);
            }
        }
        if ((players = (Set)this.activePlayersPerLoadedChunk.get(chunkPos)) != null) {
            players.remove(player);
            if (players.isEmpty()) {
                this.activePlayersPerLoadedChunk.remove(chunkPos);
            }
        }
        if ((loadedChunksPerPlayer = (Set)this.loadedChunksPerPlayer.get(player)) != null) {
            loadedChunksPerPlayer.remove(chunkPos);
            if (loadedChunksPerPlayer.isEmpty()) {
                this.loadedChunksPerPlayer.remove(player);
            }
        }
    }

    public void togglePlayerActivity(UUID player, boolean active) {
        block8: {
            Set chunks = (Set)this.loadedChunksPerPlayer.get(player);
            if (chunks == null) break block8;
            if (active) {
                for (class_1923 chunk : chunks) {
                    Set inactivePlayers = (Set)this.inactivePlayersPerLoadedChunk.get(chunk);
                    if (inactivePlayers != null) {
                        inactivePlayers.remove(player);
                        if (inactivePlayers.isEmpty()) {
                            this.inactivePlayersPerLoadedChunk.remove(chunk);
                        }
                    }
                    this.activePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                    ((Set)this.activePlayersPerLoadedChunk.get(chunk)).add(player);
                }
            } else {
                for (class_1923 chunk : chunks) {
                    Set activePlayers = (Set)this.activePlayersPerLoadedChunk.get(chunk);
                    if (activePlayers != null) {
                        activePlayers.remove(player);
                        if (activePlayers.isEmpty()) {
                            this.activePlayersPerLoadedChunk.remove(chunk);
                        }
                    }
                    this.inactivePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                    ((Set)this.inactivePlayersPerLoadedChunk.get(chunk)).add(player);
                }
            }
        }
    }

    public void readServerInfo(class_2487 compound) {
        class_2499 chunkLoaderCachesTag = compound.method_10554("chunkLoaderCaches", 10);
        chunkLoaderCachesTag.stream().map(class_2487.class::cast).map(ChunkLoaderCache::read).forEach(cache -> {
            this.chunkLoaderCacheMap.put(cache.chunkLoaderPos, cache);
            this.chunkLoadersPerChunk.putIfAbsent(cache.chunkPos, new HashSet());
            ((Set)this.chunkLoadersPerChunk.get(cache.chunkPos)).add(cache.chunkLoaderPos);
            this.chunkLoadersPerPlayer.putIfAbsent(cache.owner, new HashSet());
            ((Set)this.chunkLoadersPerPlayer.get(cache.owner)).add(cache.chunkLoaderPos);
            int range = cache.chunkLoaderType.getRange();
            this.availableChunksPerPlayer.putIfAbsent(cache.owner, new HashSet());
            for (int x = -range + 1; x < range; ++x) {
                for (int z = -range + 1; z < range; ++z) {
                    ((Set)this.availableChunksPerPlayer.get(cache.owner)).add(new class_1923(cache.chunkPos.field_9181 + x, cache.chunkPos.field_9180 + z));
                }
            }
        });
        class_2499 loadedChunksPerActivePlayerTag = compound.method_10554("loadedChunksPerActivePlayer", 10);
        loadedChunksPerActivePlayerTag.stream().map(class_2487.class::cast).forEach(playerTag -> {
            UUID player = playerTag.method_25926("player");
            Collection chunks = Arrays.stream(playerTag.method_10565("chunks")).mapToObj(class_1923::new).collect(Collectors.toList());
            this.loadedChunksPerPlayer.putIfAbsent(player, new HashSet());
            ((Set)this.loadedChunksPerPlayer.get(player)).addAll(chunks);
            for (class_1923 chunk : chunks) {
                this.activePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                ((Set)this.activePlayersPerLoadedChunk.get(chunk)).add(player);
            }
        });
        class_2499 loadedChunksPerInactivePlayerTag = compound.method_10554("loadedChunksPerInactivePlayer", 10);
        loadedChunksPerInactivePlayerTag.stream().map(class_2487.class::cast).forEach(playerTag -> {
            UUID player = playerTag.method_25926("player");
            Collection chunks = Arrays.stream(playerTag.method_10565("chunks")).mapToObj(class_1923::new).collect(Collectors.toList());
            this.loadedChunksPerPlayer.putIfAbsent(player, new HashSet());
            ((Set)this.loadedChunksPerPlayer.get(player)).addAll(chunks);
            for (class_1923 chunk : chunks) {
                this.inactivePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                ((Set)this.inactivePlayersPerLoadedChunk.get(chunk)).add(player);
            }
        });
    }
}

