/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class PlayerActivityTracker {
    private static final Set<UUID> activePlayers = new LinkedHashSet<UUID>();
    private static final Set<UUID> onlinePlayers = new LinkedHashSet<UUID>();
    private static final Map<UUID, ActiveTime> lastActiveTimePerPlayer = new HashMap<UUID, ActiveTime>();
    private static final SortedSet<ActiveTime> sortedActiveTimes = new TreeSet<ActiveTime>();
    private static boolean dirty = false;

    public static void registerCallbacks() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> PlayerActivityTracker.onPlayerJoin((class_1657)handler.method_32311()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> PlayerActivityTracker.onPlayerLeave((class_1657)handler.method_32311()));
        ServerTickEvents.START_SERVER_TICK.register(PlayerActivityTracker::onServerTick);
        ServerLifecycleEvents.SERVER_STARTING.register(PlayerActivityTracker::onServerStarting);
    }

    public static void onPlayerJoin(class_1657 player) {
        ActiveTime lastActiveTime;
        UUID playerId = player.method_5667();
        onlinePlayers.add(playerId);
        if (!activePlayers.contains(playerId)) {
            activePlayers.add(playerId);
            if (PlayerActivityTracker.isInactivityTimeOutEnabled()) {
                player.method_5682().method_3738().forEach(level -> ChunkLoadingCapability.get((class_1937)level).castServer().togglePlayerActivity(playerId, true));
            }
        }
        if ((lastActiveTime = lastActiveTimePerPlayer.remove(playerId)) != null) {
            sortedActiveTimes.remove(lastActiveTime);
        }
        dirty = true;
    }

    public static void onPlayerLeave(class_1657 player) {
        UUID playerId = player.method_5667();
        onlinePlayers.remove(playerId);
        ActiveTime lastActiveTime = new ActiveTime(playerId, System.currentTimeMillis());
        lastActiveTimePerPlayer.put(playerId, lastActiveTime);
        sortedActiveTimes.add(lastActiveTime);
        dirty = true;
    }

    public static void onServerTick(MinecraftServer server) {
        long timeoutTime = System.currentTimeMillis() - PlayerActivityTracker.getInactivityTimeout();
        while (!sortedActiveTimes.isEmpty()) {
            ActiveTime earliestExpiringTime = sortedActiveTimes.first();
            if (earliestExpiringTime.lastActiveTime >= timeoutTime) break;
            sortedActiveTimes.remove(earliestExpiringTime);
            lastActiveTimePerPlayer.remove(earliestExpiringTime.player);
            activePlayers.remove(earliestExpiringTime.player);
            dirty = true;
            ActiveTime finalEarliestExpiringTime = earliestExpiringTime;
            if (!PlayerActivityTracker.isInactivityTimeOutEnabled()) continue;
            server.method_3738().forEach(level -> ChunkLoadingCapability.get((class_1937)level).castServer().togglePlayerActivity(finalEarliestExpiringTime.player, false));
        }
    }

    public static void onServerStarting(MinecraftServer server) {
        activePlayers.clear();
        onlinePlayers.clear();
        lastActiveTimePerPlayer.clear();
        sortedActiveTimes.clear();
        dirty = false;
        Path path = server.method_27050(class_5218.field_24188).resolve("chunkloaders/active_players.nbt");
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try {
            class_2487 data = class_2507.method_10633((Path)path);
            if (data != null) {
                PlayerActivityTracker.read(data);
            }
        }
        catch (IOException exception) {
            ChunkLoaders.LOGGER.error("Failed to load player activity data!", (Throwable)exception);
        }
    }

    public static void onWorldSave(class_3218 level) {
        if (dirty) {
            class_2487 data = PlayerActivityTracker.write();
            Path path = level.method_8503().method_27050(class_5218.field_24188).resolve("chunkloaders/active_players.nbt");
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                class_2507.method_10630((class_2487)data, (Path)path);
            }
            catch (IOException exception) {
                ChunkLoaders.LOGGER.error("Failed to write active player data!", (Throwable)exception);
                return;
            }
            dirty = false;
        }
    }

    public static boolean isPlayerActive(UUID player) {
        return !PlayerActivityTracker.isInactivityTimeOutEnabled() || activePlayers.contains(player);
    }

    private static boolean isInactivityTimeOutEnabled() {
        return ChunkLoadersConfig.inactivityTimeout.get() > 0L;
    }

    private static long getInactivityTimeout() {
        return ChunkLoadersConfig.inactivityTimeout.get() * 60L * 1000L;
    }

    private static class_2487 write() {
        class_2487 tag;
        class_2499 activeTimes = new class_2499();
        for (UUID player : onlinePlayers) {
            tag = new class_2487();
            tag.method_25927("player", player);
            tag.method_10544("time", System.currentTimeMillis());
            activeTimes.add((Object)tag);
        }
        for (ActiveTime activeTime : lastActiveTimePerPlayer.values()) {
            tag = new class_2487();
            tag.method_25927("player", activeTime.player);
            tag.method_10544("time", activeTime.lastActiveTime);
            activeTimes.add((Object)tag);
        }
        class_2487 tag2 = new class_2487();
        tag2.method_10566("times", (class_2520)activeTimes);
        return tag2;
    }

    private static void read(class_2487 tag) {
        class_2499 activeTimes = tag.method_10554("times", 10);
        for (class_2520 nbt : activeTimes) {
            class_2487 timeTag;
            if (!(nbt instanceof class_2487) || !(timeTag = (class_2487)nbt).method_10573("player", 11) || !timeTag.method_10573("time", 4)) continue;
            ActiveTime activeTime = new ActiveTime(timeTag.method_25926("player"), timeTag.method_10537("time"));
            activePlayers.add(activeTime.player);
            sortedActiveTimes.add(activeTime);
        }
    }

    private static class ActiveTime
    implements Comparable<ActiveTime> {
        public final UUID player;
        public long lastActiveTime;

        public ActiveTime(UUID player, long lastActiveTime) {
            this.player = player;
            this.lastActiveTime = lastActiveTime;
        }

        @Override
        public int compareTo(ActiveTime other) {
            return Long.compare(this.lastActiveTime, other.lastActiveTime);
        }
    }
}

