/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.chunkloaders.packet.PacketToggleChunk;
import com.supermartijn642.chunkloaders.screen.ChunkImage;
import com.supermartijn642.chunkloaders.screen.PlayerRenderer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.core.network.BasePacket;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class ChunkGridCell
extends BaseWidget {
    private static final class_2960 CELL_OVERLAY = class_2960.method_60655((String)"chunkloaders", (String)"textures/gui/cell_overlay.png");
    private final class_1923 pos;
    private final UUID player;
    private final BiFunction<Integer, Integer, Boolean> isLoaded;
    private final BiFunction<Integer, Integer, Boolean> isWithinRange;
    private final BiFunction<Integer, Integer, Boolean> isLoadedByOtherPlayer;
    private final ChunkImage image;

    public ChunkGridCell(int x, int y, class_1923 chunk, int loaderYLevel, UUID player, BiFunction<Integer, Integer, Boolean> isLoaded, BiFunction<Integer, Integer, Boolean> isWithinRange, BiFunction<Integer, Integer, Boolean> isLoadedByOtherPlayer) {
        super(x, y, 18, 18);
        this.pos = chunk;
        this.player = player;
        this.isLoaded = isLoaded;
        this.isWithinRange = isWithinRange;
        this.isLoadedByOtherPlayer = isLoadedByOtherPlayer;
        this.image = new ChunkImage(ClientUtils.getWorld(), chunk, loaderYLevel);
    }

    public class_2561 getNarrationMessage() {
        if (this.isLoaded.apply(0, 0).booleanValue()) {
            return TextComponents.translation((String)"chunkloaders.gui.chunk.loaded").get();
        }
        if (this.isWithinRange.apply(0, 0).booleanValue()) {
            return TextComponents.translation((String)"chunkloaders.gui.chunk.available").get();
        }
        if (this.isLoadedByOtherPlayer.apply(0, 0).booleanValue()) {
            return TextComponents.translation((String)"chunkloaders.gui.speech.chunk.others").get();
        }
        return TextComponents.translation((String)"chunkloaders.gui.speech.chunk.not_loaded").get();
    }

    public void renderBackground(WidgetRenderContext context, int mouseX, int mouseY) {
        this.image.bindTexture();
        ScreenUtils.drawTexture((class_4587)context.poseStack(), (float)(this.x + 1), (float)(this.y + 1), (float)16.0f, (float)16.0f);
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        this.drawOutline(context.poseStack(), this.isLoadedByOtherPlayer, 0.15686275f, 0.15686275f, 0.15686275f, 0.76862746f, 0.76862746f, 0.76862746f, 0.38039216f);
        this.drawOutline(context.poseStack(), this.isWithinRange, 0.0f, 0.32156864f, 0.76862746f, 0.0f, 0.32156864f, 0.76862746f, 0.22745098f);
        this.drawOutline(context.poseStack(), this.isLoaded, 0.0f, 0.3882353f, 0.043137256f, 0.0f, 0.3882353f, 0.043137256f, 0.45490196f);
    }

    public void renderForeground(WidgetRenderContext context, int mouseX, int mouseY) {
        if (this.isFocused() && this.canPlayerToggleChunk()) {
            ScreenUtils.bindTexture((class_2960)CELL_OVERLAY);
            ScreenUtils.drawTexture((class_4587)context.poseStack(), (float)(this.x - 1), (float)(this.y - 1), (float)(this.width + 2), (float)(this.height + 2));
        }
    }

    private void drawOutline(class_4587 poseStack, BiFunction<Integer, Integer, Boolean> shouldConnect, float redBorder, float greenBorder, float blueBorder, float redFiller, float greenFiller, float blueFiller, float alphaFiller) {
        if (!shouldConnect.apply(0, 0).booleanValue()) {
            return;
        }
        ScreenUtils.fillRect((class_4587)poseStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)redFiller, (float)greenFiller, (float)blueFiller, (float)alphaFiller);
        if (!shouldConnect.apply(0, -1).booleanValue()) {
            ScreenUtils.fillRect((class_4587)poseStack, (float)this.x, (float)this.y, (float)this.width, (float)1.0f, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (!shouldConnect.apply(1, 0).booleanValue()) {
            ScreenUtils.fillRect((class_4587)poseStack, (float)(this.x + this.width - 1), (float)this.y, (float)1.0f, (float)this.height, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (!shouldConnect.apply(0, 1).booleanValue()) {
            ScreenUtils.fillRect((class_4587)poseStack, (float)this.x, (float)(this.y + this.height - 1), (float)this.width, (float)1.0f, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (!shouldConnect.apply(-1, 0).booleanValue()) {
            ScreenUtils.fillRect((class_4587)poseStack, (float)this.x, (float)this.y, (float)1.0f, (float)this.height, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (shouldConnect.apply(0, -1).booleanValue() && shouldConnect.apply(-1, 0).booleanValue() && !shouldConnect.apply(-1, -1).booleanValue()) {
            ScreenUtils.fillRect((class_4587)poseStack, (float)this.x, (float)this.y, (float)1.0f, (float)1.0f, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (shouldConnect.apply(0, -1).booleanValue() && shouldConnect.apply(1, 0).booleanValue() && !shouldConnect.apply(1, -1).booleanValue()) {
            ScreenUtils.fillRect((class_4587)poseStack, (float)(this.x + this.width - 1), (float)this.y, (float)1.0f, (float)1.0f, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (shouldConnect.apply(0, 1).booleanValue() && shouldConnect.apply(-1, 0).booleanValue() && !shouldConnect.apply(-1, 1).booleanValue()) {
            ScreenUtils.fillRect((class_4587)poseStack, (float)this.x, (float)(this.y + this.height - 1), (float)1.0f, (float)1.0f, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
        if (shouldConnect.apply(0, 1).booleanValue() && shouldConnect.apply(1, 0).booleanValue() && !shouldConnect.apply(1, 1).booleanValue()) {
            ScreenUtils.fillRect((class_4587)poseStack, (float)(this.x + this.width - 1), (float)(this.y + this.height - 1), (float)1.0f, (float)1.0f, (float)redBorder, (float)greenBorder, (float)blueBorder, (float)1.0f);
        }
    }

    protected void getTooltips(Consumer<class_2561> tooltipConsumer) {
        if (this.isFocused()) {
            ArrayList<class_5250> tooltips = new ArrayList<class_5250>();
            boolean canToggleChunk = this.canPlayerToggleChunk();
            if (canToggleChunk) {
                if (this.isLoaded.apply(0, 0).booleanValue()) {
                    tooltips.add(TextComponents.translation((String)"chunkloaders.gui.chunk.loaded").color(class_124.field_1065).get());
                } else if (this.isWithinRange.apply(0, 0).booleanValue()) {
                    tooltips.add(TextComponents.translation((String)"chunkloaders.gui.chunk.available").color(class_124.field_1065).get());
                }
            }
            ChunkLoadingCapability capability = ChunkLoadingCapability.get(ClientUtils.getWorld());
            capability.getActivePlayersLoadingChunk(this.pos).stream().filter(uuid -> !canToggleChunk || !uuid.equals(this.player)).map(PlayerRenderer::getPlayerUsername).filter(Objects::nonNull).map(name -> TextComponents.string((String)(" " + name)).color(class_124.field_1080).italic().get()).forEach(tooltips::add);
            capability.getInactivePlayersLoadingChunk(this.pos).stream().filter(uuid -> !canToggleChunk || !uuid.equals(this.player)).map(PlayerRenderer::getPlayerUsername).filter(Objects::nonNull).map(name -> TextComponents.string((String)" ").string(name).color(class_124.field_1080).italic().strikethrough().get()).forEach(tooltips::add);
            if (tooltips.size() > (canToggleChunk ? 1 : 0)) {
                tooltips.add(canToggleChunk ? 1 : 0, TextComponents.translation((String)"chunkloaders.gui.chunk.others").color(class_124.field_1068).get());
            }
            if (!ClientUtils.getPlayer().method_5667().equals(this.player) && ClientUtils.getPlayer().method_5687(2) && !class_437.method_25442() && (this.isWithinRange.apply(0, 0).booleanValue() || this.isLoaded.apply(0, 0).booleanValue())) {
                class_5250 keyName = TextComponents.translation((String)"key.keyboard.left.shift").color(class_124.field_1065).get();
                tooltips.add(TextComponents.translation((String)"chunkloaders.gui.chunk.overwrite", (Object[])new Object[]{keyName}).color(class_124.field_1068).get());
            }
            tooltips.forEach(tooltipConsumer);
        }
    }

    public void onPress() {
        if (this.canPlayerToggleChunk()) {
            AbstractButtonWidget.playClickSound();
            ChunkLoaders.CHANNEL.sendToServer((BasePacket)new PacketToggleChunk(this.player, this.pos));
        }
    }

    private boolean canPlayerToggleChunk() {
        class_1657 player = ClientUtils.getPlayer();
        return (player.method_5667().equals(this.player) || player.method_5687(2) && class_437.method_25442()) && (this.isWithinRange.apply(0, 0) != false || this.isLoaded.apply(0, 0) != false);
    }

    public boolean isLoaded() {
        return this.isLoaded.apply(0, 0);
    }

    public void discard() {
        this.image.dispose();
    }
}

