/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.blending;

import net.coderbot.iris.gl.blending.AlphaTestFunction;

public class AlphaTest {
    public static final AlphaTest ALWAYS = new AlphaTest(AlphaTestFunction.ALWAYS, 0.0f);
    private final AlphaTestFunction function;
    private final float reference;

    public AlphaTest(AlphaTestFunction function, float reference) {
        this.function = function;
        this.reference = reference;
    }

    public String toExpression(String indentation) {
        if (this.function == AlphaTestFunction.ALWAYS) {
            return "// alpha test disabled\n";
        }
        if (this.function == AlphaTestFunction.NEVER) {
            return "discard;\n";
        }
        String expr = this.function.getExpression();
        return indentation + "if (!(gl_FragData[0].a " + expr + " " + this.reference + ")) {\n" + indentation + "    discard;\n" + indentation + "}\n";
    }

    public void setup() {
        throw new IllegalStateException("Cannot setup alpha state on core profile");
    }

    public static void teardown() {
        throw new IllegalStateException("Cannot teardown alpha state on core profile");
    }

    public String toString() {
        return "AlphaTestOverride { " + (Object)((Object)this.function) + " " + this.reference + " }";
    }
}

