/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.IntSupplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.rendertarget.NativeImageBackedCustomTexture;
import net.coderbot.iris.rendertarget.NativeImageBackedNoiseTexture;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.texture.CustomTextureData;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1060;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class CustomTextureManager {
    private final Object2ObjectMap<TextureStage, Object2ObjectMap<String, IntSupplier>> customTextureIdMap = new Object2ObjectOpenHashMap();
    private final IntSupplier noise;
    private final NativeImageBackedSingleColorTexture normals;
    private final NativeImageBackedSingleColorTexture specular;
    private final List<class_1044> ownedTextures = new ArrayList<class_1044>();

    public CustomTextureManager(PackDirectives packDirectives, Object2ObjectMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> customTextureDataMap, Optional<CustomTextureData> customNoiseTextureData) {
        customTextureDataMap.forEach((textureStage, customTextureStageDataMap) -> {
            Object2ObjectOpenHashMap customTextureIds = new Object2ObjectOpenHashMap();
            customTextureStageDataMap.forEach((arg_0, arg_1) -> this.lambda$new$0((Object2ObjectMap)customTextureIds, textureStage, arg_0, arg_1));
            this.customTextureIdMap.put((Object)textureStage, (Object)customTextureIds);
        });
        this.noise = customNoiseTextureData.flatMap(textureData -> {
            try {
                return Optional.of(this.createCustomTexture((CustomTextureData)textureData));
            }
            catch (IOException | class_151 e) {
                Iris.logger.error("Unable to parse the image data for the custom noise texture", e);
                return Optional.empty();
            }
        }).orElseGet(() -> {
            int noiseTextureResolution = packDirectives.getNoiseTextureResolution();
            NativeImageBackedNoiseTexture texture = new NativeImageBackedNoiseTexture(noiseTextureResolution);
            this.ownedTextures.add((class_1044)texture);
            return () -> ((class_1044)texture).method_4624();
        });
        this.normals = new NativeImageBackedSingleColorTexture(127, 127, 255, 255);
        this.specular = new NativeImageBackedSingleColorTexture(0, 0, 0, 0);
        this.ownedTextures.add((class_1044)this.normals);
        this.ownedTextures.add((class_1044)this.specular);
    }

    private IntSupplier createCustomTexture(CustomTextureData textureData) throws IOException, class_151 {
        if (textureData instanceof CustomTextureData.PngData) {
            NativeImageBackedCustomTexture texture = new NativeImageBackedCustomTexture((CustomTextureData.PngData)textureData);
            this.ownedTextures.add((class_1044)texture);
            return () -> ((class_1044)texture).method_4624();
        }
        if (textureData instanceof CustomTextureData.ResourceData) {
            CustomTextureData.ResourceData resourceData = (CustomTextureData.ResourceData)textureData;
            String namespace = resourceData.getNamespace();
            String location = resourceData.getLocation();
            class_2960 textureLocation = new class_2960(namespace, location);
            class_1060 textureManager = class_310.method_1551().method_1531();
            return () -> {
                class_1044 texture = textureManager.method_4619(textureLocation);
                return texture != null ? texture.method_4624() : class_1047.method_4540().method_4624();
            };
        }
        throw new IllegalArgumentException("Unable to handle custom texture data " + textureData);
    }

    public Object2ObjectMap<TextureStage, Object2ObjectMap<String, IntSupplier>> getCustomTextureIdMap() {
        return this.customTextureIdMap;
    }

    public IntSupplier getNoiseTexture() {
        return this.noise;
    }

    public NativeImageBackedSingleColorTexture getNormals() {
        return this.normals;
    }

    public NativeImageBackedSingleColorTexture getSpecular() {
        return this.specular;
    }

    public void destroy() {
        this.ownedTextures.forEach(class_1044::close);
    }

    private /* synthetic */ void lambda$new$0(Object2ObjectMap customTextureIds, TextureStage textureStage, String samplerName, CustomTextureData textureData) {
        try {
            customTextureIds.put((Object)samplerName, (Object)this.createCustomTexture(textureData));
        }
        catch (IOException | class_151 e) {
            Iris.logger.error("Unable to parse the image data for the custom texture on stage " + (Object)((Object)textureStage) + ", sampler " + samplerName, e);
        }
    }
}

