/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.newshader.ExtendedShader;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.newshader.TriforcePatcher;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.builtin.BuiltinReplacementUniforms;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import org.jetbrains.annotations.Nullable;

public class NewShaderTests {
    public static ExtendedShader create(String name, ProgramSource source, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, GlFramebuffer baseline, AlphaTest fallbackAlpha, class_293 vertexFormat, FrameUpdateNotifier updateNotifier, NewWorldRenderingPipeline parent, FogMode fogMode) throws IOException {
        AlphaTest alpha = source.getDirectives().getAlphaTestOverride().orElse(fallbackAlpha);
        BlendModeOverride blendModeOverride = source.getDirectives().getBlendModeOverride();
        ShaderAttributeInputs inputs = new ShaderAttributeInputs(vertexFormat);
        String vertex = TriforcePatcher.patch(source.getVertexSource().orElseThrow(RuntimeException::new), ShaderType.VERTEX, alpha, true, inputs);
        String fragment = TriforcePatcher.patch(source.getFragmentSource().orElseThrow(RuntimeException::new), ShaderType.FRAGMENT, alpha, true, inputs);
        StringBuilder shaderJson = new StringBuilder("{\n    \"blend\": {\n        \"func\": \"add\",\n        \"srcrgb\": \"srcalpha\",\n        \"dstrgb\": \"1-srcalpha\"\n    },\n    \"vertex\": \"" + name + "\",\n    \"fragment\": \"" + name + "\",\n    \"attributes\": [\n        \"Position\",\n        \"Color\",\n        \"UV0\",\n        \"UV2\",\n        \"Normal\"\n    ],\n    \"samplers\": [\n        { \"name\": \"gtexture\" },\n        { \"name\": \"texture\" },\n        { \"name\": \"tex\" },\n        { \"name\": \"lightmap\" },\n        { \"name\": \"normals\" },\n        { \"name\": \"specular\" },\n        { \"name\": \"shadow\" },\n        { \"name\": \"watershadow\" },\n        { \"name\": \"shadowtex0\" },\n        { \"name\": \"shadowtex1\" },\n        { \"name\": \"depthtex0\" },\n        { \"name\": \"depthtex1\" },\n        { \"name\": \"noisetex\" },\n");
        for (int buffer : PackRenderTargetDirectives.BASELINE_SUPPORTED_RENDER_TARGETS) {
            if (buffer >= 4 && buffer < PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.size()) {
                shaderJson.append("        { \"name\": \"");
                shaderJson.append((String)PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.get(buffer));
                shaderJson.append("\" },\n");
            }
            shaderJson.append("        { \"name\": \"colortex");
            shaderJson.append(buffer);
            shaderJson.append("\" },\n");
        }
        shaderJson.append("        { \"name\": \"shadowcolor\" },\n        { \"name\": \"shadowcolor0\" },\n        { \"name\": \"shadowcolor1\" }\n    ],\n    \"uniforms\": [\n        { \"name\": \"iris_TextureMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"iris_ChunkOffset\", \"type\": \"float\", \"count\": 3, \"values\": [ 0.0, 0.0, 0.0 ] },\n        { \"name\": \"iris_ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n        { \"name\": \"iris_FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        { \"name\": \"iris_FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"iris_LineWidth\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"iris_ScreenSize\", \"type\": \"float\", \"count\": 2, \"values\": [ 1.0, 1.0 ] },\n        { \"name\": \"iris_FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] }\n    ]\n}");
        String shaderJsonString = shaderJson.toString();
        IrisProgramResourceFactory shaderResourceFactory = new IrisProgramResourceFactory(shaderJsonString, vertex, fragment);
        Path debugOutDir = FabricLoader.getInstance().getGameDir().resolve("patched_shaders");
        Files.write(debugOutDir.resolve(name + ".vsh"), vertex.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(debugOutDir.resolve(name + ".fsh"), fragment.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(debugOutDir.resolve(name + ".json"), shaderJsonString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return new ExtendedShader(shaderResourceFactory, name, vertexFormat, writingToBeforeTranslucent, writingToAfterTranslucent, baseline, blendModeOverride, uniforms -> {
            CommonUniforms.addCommonUniforms(uniforms, source.getParent().getPack().getIdMap(), source.getParent().getPackDirectives(), updateNotifier, fogMode);
            BuiltinReplacementUniforms.addBuiltinReplacementUniforms(uniforms);
        }, parent);
    }

    private static class IrisProgramResourceFactory
    implements class_5912 {
        private final String json;
        private final String vertex;
        private final String fragment;

        public IrisProgramResourceFactory(String json, String vertex, String fragment) {
            this.json = json;
            this.vertex = vertex;
            this.fragment = fragment;
        }

        public class_3298 method_14486(class_2960 id) throws IOException {
            String path = id.method_12832();
            if (path.endsWith("json")) {
                return new StringResource(id, this.json);
            }
            if (path.endsWith("vsh")) {
                return new StringResource(id, this.vertex);
            }
            if (path.endsWith("fsh")) {
                return new StringResource(id, this.fragment);
            }
            throw new IOException("Couldn't load " + id);
        }
    }

    private static class StringResource
    implements class_3298 {
        private final class_2960 id;
        private final String content;

        private StringResource(class_2960 id, String content) {
            this.id = id;
            this.content = content;
        }

        public class_2960 method_14483() {
            return this.id;
        }

        public InputStream method_14482() {
            return new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8));
        }

        public boolean method_14484() {
            return false;
        }

        @Nullable
        public <T> T method_14481(class_3270<T> metaReader) {
            return null;
        }

        public String method_14480() {
            return "<iris shaderpack shaders>";
        }

        public void close() throws IOException {
        }
    }
}

