/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.shaderpack.transform.StringTransformations;
import net.coderbot.iris.shaderpack.transform.Transformations;

public class TriforceCompositePatcher {
    public static String patch(String source, ShaderType type) {
        int i;
        if (source.contains("moj_import")) {
            throw new IllegalStateException("Iris shader programs may not use moj_import directives.");
        }
        if (source.contains("iris_")) {
            throw new IllegalStateException("Detected a potential reference to unstable and internal Iris shader interfaces (iris_). This isn't currently supported.");
        }
        StringTransformations transformations = new StringTransformations(source);
        TriforceCompositePatcher.fixVersion(transformations);
        for (i = 0; i < 8; ++i) {
            transformations.replaceExact("gl_TextureMatrix[" + i + "]", "mat4(1.0)");
            transformations.replaceExact("gl_TextureMatrix [" + i + "]", "mat4(1.0)");
        }
        transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "uniform float iris_FogDensity;\nuniform float iris_FogStart;\nuniform float iris_FogEnd;\nuniform vec4 iris_FogColor;\n\nstruct iris_FogParameters {\n    vec4 color;\n    float density;\n    float start;\n    float end;\n    float scale;\n};\n\niris_FogParameters iris_Fog = iris_FogParameters(iris_FogColor, iris_FogDensity, iris_FogStart, iris_FogEnd, 1.0 / (iris_FogEnd - iris_FogStart));\n\n#define gl_Fog iris_Fog");
        transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_FogFragCoord iris_FogFragCoord");
        if (type == ShaderType.VERTEX) {
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "out float iris_FogFragCoord;");
        } else if (type == ShaderType.FRAGMENT) {
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in float iris_FogFragCoord;");
        }
        transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_ProjectionMatrix mat4(vec4(2.0, 0.0, 0.0, 0.0), vec4(0.0, 2.0, 0.0, 0.0), vec4(0.0), vec4(-1.0, -1.0, 0.0, 1.0))");
        if (type == ShaderType.VERTEX) {
            transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_MultiTexCoord0 vec4(UV0, 0.0, 1.0)");
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec2 UV0;");
            for (i = 1; i < 8; ++i) {
                transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_MultiTexCoord" + i + " vec4(0.0, 0.0, 0.0, 1.0)");
            }
        }
        transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_Color vec4(1.0, 1.0, 1.0, 1.0)");
        if (type == ShaderType.VERTEX) {
            transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_Normal vec3(0.0, 0.0, 1.0)");
        }
        transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_NormalMatrix mat3(1.0)");
        transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_ModelViewMatrix mat4(1.0)");
        transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_ModelViewProjectionMatrix (gl_ProjectionMatrix * gl_ModelViewMatrix)");
        if (type == ShaderType.VERTEX) {
            transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_Vertex vec4(Position, 1.0)");
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "in vec3 Position;");
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 ftransform() { return gl_ModelViewProjectionMatrix * gl_Vertex; }");
        }
        if (type == ShaderType.VERTEX) {
            transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define attribute in");
            transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define varying out");
        } else if (type == ShaderType.FRAGMENT) {
            transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define varying in");
        }
        if (type == ShaderType.FRAGMENT) {
            if (transformations.contains("gl_FragColor")) {
                Iris.logger.warn("[Triforce Patcher] gl_FragColor is not supported yet, please use gl_FragData! Assuming that the shaderpack author intended to use gl_FragData[0]...");
                transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_FragColor iris_FragData[0]");
            }
            transformations.injectLine(Transformations.InjectionPoint.DEFINES, "#define gl_FragData iris_FragData");
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "out vec4 iris_FragData[8];");
        }
        transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texture2D(sampler2D sampler, vec2 coord) { return texture(sampler, coord); }");
        if (type == ShaderType.FRAGMENT) {
            transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texture2D(sampler2D sampler, vec2 coord, float bias) { return texture(sampler, coord, bias); }");
        }
        transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 texture2DLod(sampler2D sampler, vec2 coord, float lod) { return textureLod(sampler, coord, lod); }");
        transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 shadow2D(sampler2DShadow sampler, vec3 coord) { return vec4(texture(sampler, coord)); }");
        transformations.injectLine(Transformations.InjectionPoint.BEFORE_CODE, "vec4 shadow2DLod(sampler2DShadow sampler, vec3 coord, float lod) { return vec4(textureLod(sampler, coord, lod)); }");
        return transformations.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fixVersion(Transformations transformations) {
        String prefix = transformations.getPrefix();
        int split = prefix.indexOf("#version");
        String beforeVersion = prefix.substring(0, split);
        String actualVersion = prefix.substring(split + "#version".length()).trim();
        if (actualVersion.endsWith(" core")) {
            throw new IllegalStateException("Transforming a shader that is already built against the core profile???");
        }
        if (!actualVersion.startsWith("1")) {
            if (!actualVersion.endsWith("compatibility")) throw new IllegalStateException("Expected \"compatibility\" after the GLSL version: #version " + actualVersion);
            actualVersion = actualVersion.substring(0, actualVersion.length() - "compatibility".length()).trim() + " core";
        } else {
            actualVersion = "150 core";
        }
        beforeVersion = beforeVersion.trim();
        if (!beforeVersion.isEmpty()) {
            beforeVersion = beforeVersion + "\n";
        }
        transformations.setPrefix(beforeVersion + "#version " + actualVersion + "\n");
    }
}

