/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.postprocess;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.sampler.SamplerLimits;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.TriforceCompositePatcher;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.rendertarget.FramebufferBlitter;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shadows.ShadowMapRenderer;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FogUniforms117;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_276;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;

public class FinalPassRenderer {
    private final RenderTargets renderTargets;
    @Nullable
    private final Pass finalPass;
    private final ImmutableList<SwapPass> swapPasses;
    private final GlFramebuffer baseline;
    private final IntSupplier noiseTexture;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final Object2ObjectMap<String, IntSupplier> customTextureIds;

    public FinalPassRenderer(ProgramSet pack, RenderTargets renderTargets, IntSupplier noiseTexture, FrameUpdateNotifier updateNotifier, ImmutableSet<Integer> flippedBuffers, CenterDepthSampler centerDepthSampler, Supplier<ShadowMapRenderer> shadowMapRendererSupplier, Object2ObjectMap<String, IntSupplier> customTextureIds, ImmutableSet<Integer> flippedAtLeastOnce) {
        this.updateNotifier = updateNotifier;
        this.centerDepthSampler = centerDepthSampler;
        this.customTextureIds = customTextureIds;
        PackRenderTargetDirectives renderTargetDirectives = pack.getPackDirectives().getRenderTargetDirectives();
        Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> renderTargetSettings = renderTargetDirectives.getRenderTargetSettings();
        this.noiseTexture = noiseTexture;
        this.renderTargets = renderTargets;
        this.finalPass = pack.getCompositeFinal().map(source -> {
            Pass pass = new Pass();
            ProgramDirectives directives = source.getDirectives();
            pass.program = this.createProgram((ProgramSource)source, flippedBuffers, flippedAtLeastOnce, shadowMapRendererSupplier);
            pass.stageReadsFromAlt = flippedBuffers;
            pass.mipmappedBuffers = directives.getMipmappedBuffers();
            return pass;
        }).orElse(null);
        IntList buffersToBeCleared = pack.getPackDirectives().getRenderTargetDirectives().getBuffersToBeCleared();
        this.baseline = renderTargets.createGbufferFramebuffer(flippedBuffers, new int[]{0});
        ImmutableList.Builder swapPasses = ImmutableList.builder();
        flippedBuffers.forEach(i -> {
            int target = i;
            if (buffersToBeCleared.contains(target)) {
                return;
            }
            SwapPass swap = new SwapPass();
            swap.from = renderTargets.createFramebufferWritingToAlt(new int[]{target});
            swap.targetTexture = renderTargets.get(target).getMainTexture();
            swapPasses.add((Object)swap);
        });
        this.swapPasses = swapPasses.build();
        GL30C.glBindFramebuffer((int)36008, (int)0);
    }

    public void renderFinalPass() {
        RenderSystem.disableBlend();
        class_276 main = class_310.method_1551().method_1522();
        int baseWidth = main.field_1482;
        int baseHeight = main.field_1481;
        FullScreenQuadRenderer.INSTANCE.begin();
        main.method_1235(true);
        if (this.finalPass != null) {
            if (!this.finalPass.mipmappedBuffers.isEmpty()) {
                RenderSystem.activeTexture((int)33984);
                UnmodifiableIterator unmodifiableIterator = this.finalPass.mipmappedBuffers.iterator();
                while (unmodifiableIterator.hasNext()) {
                    int index = (Integer)unmodifiableIterator.next();
                    FinalPassRenderer.setupMipmapping(this.renderTargets.get(index), this.finalPass.stageReadsFromAlt.contains((Object)index));
                }
            }
            this.finalPass.program.use();
            FullScreenQuadRenderer.INSTANCE.renderQuad();
        }
        FullScreenQuadRenderer.INSTANCE.end();
        if (this.finalPass == null) {
            FramebufferBlitter.copyFramebufferContent(this.baseline, main);
        } else {
            FramebufferBlitter.copyDepthBufferContent(this.baseline, main);
        }
        RenderSystem.activeTexture((int)33984);
        for (int i = 0; i < this.renderTargets.getRenderTargetCount(); ++i) {
            FinalPassRenderer.resetRenderTarget(this.renderTargets.get(i));
        }
        for (SwapPass swapPass : this.swapPasses) {
            swapPass.from.bindAsReadBuffer();
            RenderSystem.bindTexture((int)swapPass.targetTexture);
            GL20C.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)baseWidth, (int)baseHeight);
            RenderSystem.bindTexture((int)0);
            GlStateManager._glBindFramebuffer((int)36008, (int)0);
        }
        main.method_1235(true);
        GlStateManager._glUseProgram((int)0);
        for (int i = 0; i < SamplerLimits.get().getMaxTextureUnits(); ++i) {
            RenderSystem.activeTexture((int)(33984 + i));
            RenderSystem.bindTexture((int)0);
        }
        RenderSystem.activeTexture((int)33984);
    }

    private static void setupMipmapping(RenderTarget target, boolean readFromAlt) {
        RenderSystem.bindTexture((int)(readFromAlt ? target.getAltTexture() : target.getMainTexture()));
        GL30C.glGenerateMipmap((int)3553);
        GL30C.glTexParameteri((int)3553, (int)10241, (int)9987);
    }

    private static void resetRenderTarget(RenderTarget target) {
        RenderSystem.bindTexture((int)target.getMainTexture());
        GL30C.glTexParameteri((int)3553, (int)10241, (int)9729);
        RenderSystem.bindTexture((int)target.getAltTexture());
        GL30C.glTexParameteri((int)3553, (int)10241, (int)9729);
        RenderSystem.bindTexture((int)0);
    }

    private Program createProgram(ProgramSource source, ImmutableSet<Integer> flipped, ImmutableSet<Integer> flippedAtLeastOnceSnapshot, Supplier<ShadowMapRenderer> shadowMapRendererSupplier) {
        ProgramBuilder builder;
        String vertex = TriforceCompositePatcher.patch(source.getVertexSource().orElseThrow(RuntimeException::new), ShaderType.VERTEX);
        if (source.getGeometrySource().isPresent()) {
            throw new RuntimeException("Geometry shaders are not supported yet.");
        }
        String fragment = TriforceCompositePatcher.patch(source.getFragmentSource().orElseThrow(RuntimeException::new), ShaderType.FRAGMENT);
        Objects.requireNonNull(flipped);
        try {
            builder = ProgramBuilder.begin(source.getName(), vertex, null, fragment, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Shader compilation failed!", e);
        }
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureIds, flippedAtLeastOnceSnapshot);
        FogUniforms117.addFogUniforms(builder);
        CommonUniforms.addCommonUniforms(builder, source.getParent().getPack().getIdMap(), source.getParent().getPackDirectives(), this.updateNotifier, FogMode.OFF);
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> flipped, this.renderTargets, true);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noiseTexture);
        IrisSamplers.addCompositeSamplers(customTextureSamplerInterceptor, this.renderTargets);
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, shadowMapRendererSupplier.get());
        }
        builder.uniform1f(UniformUpdateFrequency.PER_FRAME, "centerDepthSmooth", this.centerDepthSampler::getCenterDepthSmoothSample);
        Path debugOutDir = FabricLoader.getInstance().getGameDir().resolve("patched_shaders");
        try {
            Files.write(debugOutDir.resolve(source.getName() + ".vsh"), vertex.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.write(debugOutDir.resolve(source.getName() + ".fsh"), fragment.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            Iris.logger.warn("Failed to write debug patched shader source", (Throwable)e);
        }
        return builder.build();
    }

    public void destroy() {
        if (this.finalPass != null) {
            this.finalPass.destroy();
        }
    }

    private static final class Pass {
        Program program;
        ImmutableSet<Integer> stageReadsFromAlt;
        ImmutableSet<Integer> mipmappedBuffers;

        private Pass() {
        }

        private void destroy() {
            this.program.destroy();
        }
    }

    private static final class SwapPass {
        GlFramebuffer from;
        int targetTexture;

        private SwapPass() {
        }
    }
}

