/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.ConstDirectiveParser;
import net.coderbot.iris.shaderpack.DispatchingDirectiveHolder;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;

public class ProgramSet {
    private final PackDirectives packDirectives;
    private final ProgramSource shadow;
    private final ProgramSource[] shadowcomp;
    private final ProgramSource[] prepare;
    private final ProgramSource gbuffersBasic;
    private final ProgramSource gbuffersBeaconBeam;
    private final ProgramSource gbuffersTextured;
    private final ProgramSource gbuffersTexturedLit;
    private final ProgramSource gbuffersTerrain;
    private final ProgramSource gbuffersDamagedBlock;
    private final ProgramSource gbuffersSkyBasic;
    private final ProgramSource gbuffersSkyTextured;
    private final ProgramSource gbuffersClouds;
    private final ProgramSource gbuffersWeather;
    private final ProgramSource gbuffersEntities;
    private final ProgramSource gbuffersEntitiesGlowing;
    private final ProgramSource gbuffersGlint;
    private final ProgramSource gbuffersEntityEyes;
    private final ProgramSource gbuffersBlock;
    private final ProgramSource gbuffersHand;
    private final ProgramSource[] deferred;
    private final ProgramSource gbuffersWater;
    private final ProgramSource gbuffersHandWater;
    private final ProgramSource[] composite;
    private final ProgramSource compositeFinal;
    private final ShaderPack pack;

    public ProgramSet(AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider, ShaderProperties shaderProperties, ShaderPack pack) {
        this.packDirectives = new PackDirectives(PackRenderTargetDirectives.BASELINE_SUPPORTED_RENDER_TARGETS, shaderProperties);
        this.pack = pack;
        this.shadow = ProgramSet.readProgramSource(directory, sourceProvider, "shadow", this, shaderProperties);
        this.shadowcomp = this.readProgramArray(directory, sourceProvider, "shadowcomp", shaderProperties);
        this.prepare = this.readProgramArray(directory, sourceProvider, "prepare", shaderProperties);
        this.gbuffersBasic = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_basic", this, shaderProperties);
        this.gbuffersBeaconBeam = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_beaconbeam", this, shaderProperties);
        this.gbuffersTextured = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_textured", this, shaderProperties);
        this.gbuffersTexturedLit = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_textured_lit", this, shaderProperties);
        this.gbuffersTerrain = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_terrain", this, shaderProperties);
        this.gbuffersDamagedBlock = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_damagedblock", this, shaderProperties);
        this.gbuffersSkyBasic = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_skybasic", this, shaderProperties);
        this.gbuffersSkyTextured = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_skytextured", this, shaderProperties);
        this.gbuffersClouds = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_clouds", this, shaderProperties);
        this.gbuffersWeather = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_weather", this, shaderProperties);
        this.gbuffersEntities = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_entities", this, shaderProperties);
        this.gbuffersEntitiesGlowing = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_entities_glowing", this, shaderProperties);
        this.gbuffersGlint = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_armor_glint", this, shaderProperties);
        this.gbuffersEntityEyes = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_spidereyes", this, shaderProperties);
        this.gbuffersBlock = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_block", this, shaderProperties);
        this.gbuffersHand = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_hand", this, shaderProperties);
        this.deferred = this.readProgramArray(directory, sourceProvider, "deferred", shaderProperties);
        this.gbuffersWater = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_water", this, shaderProperties);
        this.gbuffersHandWater = ProgramSet.readProgramSource(directory, sourceProvider, "gbuffers_hand_water", this, shaderProperties);
        this.composite = this.readProgramArray(directory, sourceProvider, "composite", shaderProperties);
        this.compositeFinal = ProgramSet.readProgramSource(directory, sourceProvider, "final", this, shaderProperties);
        this.locateDirectives();
    }

    private ProgramSource[] readProgramArray(AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider, String name, ShaderProperties shaderProperties) {
        ProgramSource[] programs = new ProgramSource[16];
        for (int i = 0; i < programs.length; ++i) {
            String suffix = i == 0 ? "" : Integer.toString(i);
            programs[i] = ProgramSet.readProgramSource(directory, sourceProvider, name + suffix, this, shaderProperties);
        }
        return programs;
    }

    private void locateDirectives() {
        ArrayList<ProgramSource> programs = new ArrayList<ProgramSource>();
        programs.add(this.shadow);
        programs.addAll(Arrays.asList(this.shadowcomp));
        programs.addAll(Arrays.asList(this.prepare));
        programs.addAll(Arrays.asList(this.gbuffersBasic, this.gbuffersBeaconBeam, this.gbuffersTextured, this.gbuffersTexturedLit, this.gbuffersTerrain, this.gbuffersDamagedBlock, this.gbuffersSkyBasic, this.gbuffersSkyTextured, this.gbuffersClouds, this.gbuffersWeather, this.gbuffersEntities, this.gbuffersEntitiesGlowing, this.gbuffersGlint, this.gbuffersEntityEyes, this.gbuffersBlock, this.gbuffersHand));
        programs.addAll(Arrays.asList(this.deferred));
        programs.add(this.gbuffersWater);
        programs.add(this.gbuffersHandWater);
        programs.addAll(Arrays.asList(this.composite));
        programs.add(this.compositeFinal);
        DispatchingDirectiveHolder packDirectiveHolder = new DispatchingDirectiveHolder();
        this.packDirectives.acceptDirectivesFrom(packDirectiveHolder);
        for (ProgramSource source : programs) {
            if (source == null) continue;
            source.getFragmentSource().map(ConstDirectiveParser::findDirectives).ifPresent(directives -> {
                for (ConstDirectiveParser.ConstDirective directive : directives) {
                    packDirectiveHolder.processDirective(directive);
                }
            });
        }
        this.packDirectives.getRenderTargetDirectives().getRenderTargetSettings().forEach((index, settings) -> Iris.logger.debug("Render target settings for colortex" + index + ": " + settings));
    }

    public Optional<ProgramSource> getShadow() {
        return this.shadow.requireValid();
    }

    public ProgramSource[] getShadowComposite() {
        return this.shadowcomp;
    }

    public ProgramSource[] getPrepare() {
        return this.prepare;
    }

    public Optional<ProgramSource> getGbuffersBasic() {
        return this.gbuffersBasic.requireValid();
    }

    public Optional<ProgramSource> getGbuffersBeaconBeam() {
        return this.gbuffersBeaconBeam.requireValid();
    }

    public Optional<ProgramSource> getGbuffersTextured() {
        return this.gbuffersTextured.requireValid();
    }

    public Optional<ProgramSource> getGbuffersTexturedLit() {
        return this.gbuffersTexturedLit.requireValid();
    }

    public Optional<ProgramSource> getGbuffersTerrain() {
        return this.gbuffersTerrain.requireValid();
    }

    public Optional<ProgramSource> getGbuffersDamagedBlock() {
        return this.gbuffersDamagedBlock.requireValid();
    }

    public Optional<ProgramSource> getGbuffersSkyBasic() {
        return this.gbuffersSkyBasic.requireValid();
    }

    public Optional<ProgramSource> getGbuffersSkyTextured() {
        return this.gbuffersSkyTextured.requireValid();
    }

    public Optional<ProgramSource> getGbuffersClouds() {
        return this.gbuffersClouds.requireValid();
    }

    public Optional<ProgramSource> getGbuffersWeather() {
        return this.gbuffersWeather.requireValid();
    }

    public Optional<ProgramSource> getGbuffersEntities() {
        return this.gbuffersEntities.requireValid();
    }

    public Optional<ProgramSource> getGbuffersEntitiesGlowing() {
        return this.gbuffersEntitiesGlowing.requireValid();
    }

    public Optional<ProgramSource> getGbuffersGlint() {
        return this.gbuffersGlint.requireValid();
    }

    public Optional<ProgramSource> getGbuffersEntityEyes() {
        return this.gbuffersEntityEyes.requireValid();
    }

    public Optional<ProgramSource> getGbuffersBlock() {
        return this.gbuffersBlock.requireValid();
    }

    public Optional<ProgramSource> getGbuffersHand() {
        return this.gbuffersHand.requireValid();
    }

    public ProgramSource[] getDeferred() {
        return this.deferred;
    }

    public Optional<ProgramSource> getGbuffersWater() {
        return this.gbuffersWater.requireValid();
    }

    public Optional<ProgramSource> getGbuffersHandWater() {
        return this.gbuffersHandWater.requireValid();
    }

    public ProgramSource[] getComposite() {
        return this.composite;
    }

    public Optional<ProgramSource> getCompositeFinal() {
        return this.compositeFinal.requireValid();
    }

    public PackDirectives getPackDirectives() {
        return this.packDirectives;
    }

    public ShaderPack getPack() {
        return this.pack;
    }

    private static ProgramSource readProgramSource(AbsolutePackPath directory, Function<AbsolutePackPath, String> sourceProvider, String program, ProgramSet programSet, ShaderProperties properties) {
        AbsolutePackPath vertexPath = directory.resolve(program + ".vsh");
        String vertexSource = sourceProvider.apply(vertexPath);
        AbsolutePackPath geometryPath = directory.resolve(program + ".gsh");
        String geometrySource = sourceProvider.apply(geometryPath);
        AbsolutePackPath fragmentPath = directory.resolve(program + ".fsh");
        String fragmentSource = sourceProvider.apply(fragmentPath);
        return new ProgramSource(program, vertexSource, geometrySource, fragmentSource, programSet, properties);
    }
}

