/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.shader.GlShader;
import net.coderbot.iris.gl.shader.ShaderConstants;
import net.coderbot.iris.shaderpack.DimensionId;
import net.coderbot.iris.shaderpack.IdMap;
import net.coderbot.iris.shaderpack.LanguageMap;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.PropertiesPreprocessor;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;
import net.coderbot.iris.shaderpack.include.IncludeGraph;
import net.coderbot.iris.shaderpack.include.IncludeProcessor;
import net.coderbot.iris.shaderpack.include.ShaderPackSourceNames;
import net.coderbot.iris.shaderpack.preprocessor.JcppProcessor;
import net.coderbot.iris.shaderpack.texture.CustomTextureData;
import net.coderbot.iris.shaderpack.texture.TextureFilteringData;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shaderpack.transform.line.LineTransform;
import net.coderbot.iris.shaderpack.transform.line.VersionDirectiveNormalizer;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class ShaderPack {
    private static final Gson GSON = new Gson();
    private final ProgramSet base;
    @Nullable
    private final ProgramSet overworld;
    private final ProgramSet nether;
    private final ProgramSet end;
    private final IdMap idMap;
    private final LanguageMap languageMap;
    private final Object2ObjectMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> customTextureDataMap = new Object2ObjectOpenHashMap();
    private final CustomTextureData customNoiseTexture;

    public ShaderPack(Path root) throws IOException {
        Objects.requireNonNull(root);
        ShaderProperties shaderProperties = ShaderPack.loadProperties(root, "shaders.properties").map(ShaderProperties::new).orElseGet(ShaderProperties::empty);
        ImmutableList.Builder starts = ImmutableList.builder();
        ImmutableList<String> potentialFileNames = ShaderPackSourceNames.POTENTIAL_STARTS;
        ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)starts, root, AbsolutePackPath.fromAbsolutePath("/"), potentialFileNames);
        boolean hasWorld0 = ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)starts, root, AbsolutePackPath.fromAbsolutePath("/world0"), potentialFileNames);
        boolean hasNether = ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)starts, root, AbsolutePackPath.fromAbsolutePath("/world-1"), potentialFileNames);
        boolean hasEnd = ShaderPackSourceNames.findPresentSources((ImmutableList.Builder<AbsolutePackPath>)starts, root, AbsolutePackPath.fromAbsolutePath("/world1"), potentialFileNames);
        IncludeGraph graph = new IncludeGraph(root, (ImmutableList<AbsolutePackPath>)starts.build());
        IncludeProcessor includeProcessor = new IncludeProcessor(graph);
        Function<AbsolutePackPath, String> sourceProvider = path -> {
            ImmutableList<String> lines = includeProcessor.getIncludedFile((AbsolutePackPath)path);
            if (lines == null) {
                return null;
            }
            lines = LineTransform.apply(lines, VersionDirectiveNormalizer.INSTANCE);
            StringBuilder builder = new StringBuilder();
            for (String line : lines) {
                builder.append(line);
                builder.append('\n');
            }
            ShaderConstants constants = ProgramBuilder.MACRO_CONSTANTS;
            String source = GlShader.processShader(builder.toString(), constants);
            source = JcppProcessor.glslPreprocessSource(source);
            return source;
        };
        this.base = new ProgramSet(AbsolutePackPath.fromAbsolutePath("/"), sourceProvider, shaderProperties, this);
        this.overworld = ShaderPack.loadOverrides(hasWorld0, AbsolutePackPath.fromAbsolutePath("/world0"), sourceProvider, shaderProperties, this);
        this.nether = ShaderPack.loadOverrides(hasNether, AbsolutePackPath.fromAbsolutePath("/world-1"), sourceProvider, shaderProperties, this);
        this.end = ShaderPack.loadOverrides(hasEnd, AbsolutePackPath.fromAbsolutePath("/world1"), sourceProvider, shaderProperties, this);
        this.idMap = new IdMap(root);
        this.languageMap = new LanguageMap(root.resolve("lang"));
        this.customNoiseTexture = shaderProperties.getNoiseTexturePath().map(path -> {
            try {
                return this.readTexture(root, (String)path);
            }
            catch (IOException e) {
                Iris.logger.error("Unable to read the custom noise texture at " + path, (Throwable)e);
                return null;
            }
        }).orElse(null);
        shaderProperties.getCustomTextures().forEach((textureStage, customTexturePropertiesMap) -> {
            Object2ObjectOpenHashMap innerCustomTextureDataMap = new Object2ObjectOpenHashMap();
            customTexturePropertiesMap.forEach((arg_0, arg_1) -> this.lambda$new$2((Object2ObjectMap)innerCustomTextureDataMap, root, arg_0, arg_1));
            this.customTextureDataMap.put((Object)textureStage, (Object)innerCustomTextureDataMap);
        });
    }

    @Nullable
    private static ProgramSet loadOverrides(boolean has, AbsolutePackPath path, Function<AbsolutePackPath, String> sourceProvider, ShaderProperties shaderProperties, ShaderPack pack) {
        if (has) {
            return new ProgramSet(path, sourceProvider, shaderProperties, pack);
        }
        return null;
    }

    private static Optional<Properties> loadProperties(Path shaderPath, String name) {
        String fileContents = ShaderPack.readProperties(shaderPath, name);
        if (fileContents == null) {
            return Optional.empty();
        }
        String processed = PropertiesPreprocessor.process(shaderPath.getParent(), shaderPath, fileContents);
        StringReader propertiesReader = new StringReader(processed);
        Properties properties = new Properties();
        try {
            properties.load(propertiesReader);
        }
        catch (IOException e) {
            Iris.logger.error("Error loading " + name + " at " + shaderPath);
            Iris.logger.catching(Level.ERROR, (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(properties);
    }

    public CustomTextureData readTexture(Path root, String path) throws IOException {
        CustomTextureData customTextureData;
        if (path.contains(":")) {
            String[] parts = path.split(":");
            if (parts.length > 2) {
                Iris.logger.warn("Resource location " + path + " contained more than two parts?");
            }
            customTextureData = new CustomTextureData.ResourceData(parts[0], parts[1]);
        } else {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            boolean blur = false;
            boolean clamp = false;
            String mcMetaPath = path + ".mcmeta";
            Path mcMetaResolvedPath = root.resolve(mcMetaPath);
            if (Files.exists(mcMetaResolvedPath, new LinkOption[0])) {
                JsonObject meta = this.loadMcMeta(mcMetaResolvedPath);
                blur = meta.get("texture").getAsJsonObject().get("blur").getAsBoolean();
                clamp = meta.get("texture").getAsJsonObject().get("clamp").getAsBoolean();
            }
            byte[] content = Files.readAllBytes(root.resolve(path));
            customTextureData = new CustomTextureData.PngData(new TextureFilteringData(blur, clamp), content);
        }
        return customTextureData;
    }

    private JsonObject loadMcMeta(Path mcMetaPath) throws IOException, JsonParseException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(mcMetaPath, new OpenOption[0]), StandardCharsets.UTF_8));
        JsonReader jsonReader = new JsonReader((Reader)reader);
        return (JsonObject)GSON.getAdapter(JsonObject.class).read(jsonReader);
    }

    private static String readProperties(Path shaderPath, String name) {
        try {
            return new String(Files.readAllBytes(shaderPath.resolve(name)), StandardCharsets.UTF_8);
        }
        catch (NoSuchFileException e) {
            Iris.logger.debug("An " + name + " file was not found in the current shaderpack");
            return null;
        }
        catch (IOException e) {
            Iris.logger.error("An IOException occurred reading " + name + " from the current shaderpack");
            Iris.logger.catching(Level.ERROR, (Throwable)e);
            return null;
        }
    }

    public ProgramSet getProgramSet(DimensionId dimension) {
        ProgramSet overrides;
        switch (dimension) {
            case OVERWORLD: {
                overrides = this.overworld;
                break;
            }
            case NETHER: {
                overrides = this.nether;
                break;
            }
            case END: {
                overrides = this.end;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown dimension " + (Object)((Object)dimension));
            }
        }
        if (overrides != null) {
            return overrides;
        }
        return this.base;
    }

    public IdMap getIdMap() {
        return this.idMap;
    }

    public Object2ObjectMap<TextureStage, Object2ObjectMap<String, CustomTextureData>> getCustomTextureDataMap() {
        return this.customTextureDataMap;
    }

    public Optional<CustomTextureData> getCustomNoiseTexture() {
        return Optional.ofNullable(this.customNoiseTexture);
    }

    public LanguageMap getLanguageMap() {
        return this.languageMap;
    }

    private /* synthetic */ void lambda$new$2(Object2ObjectMap innerCustomTextureDataMap, Path root, String samplerName, String path) {
        try {
            innerCustomTextureDataMap.put((Object)samplerName, (Object)this.readTexture(root, path));
        }
        catch (IOException e) {
            Iris.logger.error("Unable to read the custom texture at " + path, (Throwable)e);
        }
    }
}

