/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows.frustum.advanced;

import net.coderbot.iris.shadows.frustum.BoxCuller;
import net.coderbot.iris.shadows.frustum.advanced.BaseClippingPlanes;
import net.coderbot.iris.shadows.frustum.advanced.NeighboringPlaneSet;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_238;
import net.minecraft.class_4604;

public class AdvancedShadowCullingFrustum
extends class_4604 {
    private static final int MAX_CLIPPING_PLANES = 30;
    private final class_1162[] planes = new class_1162[30];
    private int planeCount = 0;
    private double x;
    private double y;
    private double z;
    private final class_1160 shadowLightVectorFromOrigin;
    private final BoxCuller boxCuller;

    public AdvancedShadowCullingFrustum(class_1159 playerView, class_1159 playerProjection, class_1160 shadowLightVectorFromOrigin, BoxCuller boxCuller) {
        super(new class_1159(), new class_1159());
        this.shadowLightVectorFromOrigin = shadowLightVectorFromOrigin;
        BaseClippingPlanes baseClippingPlanes = new BaseClippingPlanes(playerView, playerProjection);
        boolean[] isBack = this.addBackPlanes(baseClippingPlanes);
        this.addEdgePlanes(baseClippingPlanes, isBack);
        this.boxCuller = boxCuller;
    }

    private void addPlane(class_1162 plane) {
        this.planes[this.planeCount] = plane;
        ++this.planeCount;
    }

    private boolean[] addBackPlanes(BaseClippingPlanes baseClippingPlanes) {
        class_1162[] planes = baseClippingPlanes.getPlanes();
        boolean[] isBack = new boolean[planes.length];
        for (int planeIndex = 0; planeIndex < planes.length; ++planeIndex) {
            class_1162 plane = planes[planeIndex];
            class_1160 planeNormal = this.truncate(plane);
            float dot = planeNormal.method_4950(this.shadowLightVectorFromOrigin);
            boolean back = (double)dot > 0.0;
            boolean edge = (double)dot == 0.0;
            isBack[planeIndex] = back;
            if (!back && !edge) continue;
            this.addPlane(plane);
        }
        return isBack;
    }

    private void addEdgePlanes(BaseClippingPlanes baseClippingPlanes, boolean[] isBack) {
        class_1162[] planes = baseClippingPlanes.getPlanes();
        for (int planeIndex = 0; planeIndex < planes.length; ++planeIndex) {
            if (!isBack[planeIndex]) continue;
            class_1162 plane = planes[planeIndex];
            NeighboringPlaneSet neighbors = NeighboringPlaneSet.forPlane(planeIndex);
            if (!isBack[neighbors.getPlane0()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane0()]);
            }
            if (!isBack[neighbors.getPlane1()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane1()]);
            }
            if (!isBack[neighbors.getPlane2()]) {
                this.addEdgePlane(plane, planes[neighbors.getPlane2()]);
            }
            if (isBack[neighbors.getPlane3()]) continue;
            this.addEdgePlane(plane, planes[neighbors.getPlane3()]);
        }
    }

    private class_1160 truncate(class_1162 base) {
        return new class_1160(base.method_4953(), base.method_4956(), base.method_4957());
    }

    private class_1162 extend(class_1160 base, float w) {
        return new class_1162(base.method_4943(), base.method_4945(), base.method_4947(), w);
    }

    private float lengthSquared(class_1160 v) {
        float x = v.method_4943();
        float y = v.method_4945();
        float z = v.method_4947();
        return x * x + y * y + z * z;
    }

    private class_1160 cross(class_1160 first, class_1160 second) {
        class_1160 result = new class_1160(first.method_4943(), first.method_4945(), first.method_4947());
        result.method_4951(second);
        return result;
    }

    private void addEdgePlane(class_1162 backPlane4, class_1162 frontPlane4) {
        class_1160 backPlaneNormal = this.truncate(backPlane4);
        class_1160 frontPlaneNormal = this.truncate(frontPlane4);
        class_1160 intersection = this.cross(backPlaneNormal, frontPlaneNormal);
        class_1160 edgePlaneNormal = this.cross(intersection, this.shadowLightVectorFromOrigin);
        class_1160 ixb = this.cross(intersection, backPlaneNormal);
        class_1160 fxi = this.cross(frontPlaneNormal, intersection);
        ixb.method_4942(-frontPlane4.method_23853());
        fxi.method_4942(-backPlane4.method_23853());
        ixb.method_23846(fxi);
        class_1160 point = ixb;
        point.method_4942(1.0f / this.lengthSquared(intersection));
        float d = edgePlaneNormal.method_4950(point);
        float w = -d;
        class_1162 plane = this.extend(edgePlaneNormal, w);
        this.addPlane(plane);
    }

    public void method_23088(double cameraX, double cameraY, double cameraZ) {
        if (this.boxCuller != null) {
            this.boxCuller.setPosition(cameraX, cameraY, cameraZ);
        }
        this.x = cameraX;
        this.y = cameraY;
        this.z = cameraZ;
    }

    public boolean method_23093(class_238 aabb) {
        if (this.boxCuller != null && this.boxCuller.isCulled(aabb)) {
            return false;
        }
        return this.isVisible(aabb.field_1323, aabb.field_1322, aabb.field_1321, aabb.field_1320, aabb.field_1325, aabb.field_1324);
    }

    public boolean fastAabbTest(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (this.boxCuller != null && this.boxCuller.isCulled(minX, minY, minZ, maxX, maxY, maxZ)) {
            return false;
        }
        return this.isVisible(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean canDetermineInvisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return false;
    }

    private boolean isVisible(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        float f = (float)(minX - this.x);
        float g = (float)(minY - this.y);
        float h = (float)(minZ - this.z);
        float i = (float)(maxX - this.x);
        float j = (float)(maxY - this.y);
        float k = (float)(maxZ - this.z);
        return this.isAnyCornerVisible(f, g, h, i, j, k);
    }

    private boolean isAnyCornerVisible(float x1, float y1, float z1, float x2, float y2, float z2) {
        for (int i = 0; i < this.planeCount; ++i) {
            class_1162 plane = this.planes[i];
            if (plane.method_23217(new class_1162(x1, y1, z1, 1.0f)) > 0.0f || plane.method_23217(new class_1162(x2, y1, z1, 1.0f)) > 0.0f || plane.method_23217(new class_1162(x1, y2, z1, 1.0f)) > 0.0f || plane.method_23217(new class_1162(x2, y2, z1, 1.0f)) > 0.0f || plane.method_23217(new class_1162(x1, y1, z2, 1.0f)) > 0.0f || plane.method_23217(new class_1162(x2, y1, z2, 1.0f)) > 0.0f || plane.method_23217(new class_1162(x1, y2, z2, 1.0f)) > 0.0f || plane.method_23217(new class_1162(x2, y2, z2, 1.0f)) > 0.0f) continue;
            return false;
        }
        return true;
    }
}

