/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texunits;

public enum TextureUnit {
    TERRAIN(0),
    LIGHTMAP(2),
    OVERLAY(1);

    private final int samplerId;
    private final int unitId;

    private TextureUnit(int samplerId) {
        this.samplerId = samplerId;
        this.unitId = 33984 + samplerId;
    }

    public int getSamplerId() {
        return this.samplerId;
    }

    public int getUnitId() {
        return this.unitId;
    }

    static {
        if (TERRAIN.getSamplerId() != 0) {
            throw new IllegalStateException("The texture unit number of TERRAIN is not configurable.");
        }
    }
}

