/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.network.PacketConsumer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.impl.networking.ClientSidePacketRegistryImpl;
import net.fabricmc.fabric.impl.resource.loader.ResourceManagerHelperImpl;
import net.fabricmc.loader.ModContainer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.map.CrashHandler;
import xaero.map.MapLimiter;
import xaero.map.MapProcessor;
import xaero.map.MapRunner;
import xaero.map.WorldMapClient;
import xaero.map.cache.UnknownBlockStateCache;
import xaero.map.controls.ControlsRegister;
import xaero.map.events.Events;
import xaero.map.events.FMLEvents;
import xaero.map.events.ModCommonEvents;
import xaero.map.events.ModEvents;
import xaero.map.file.OldFormatSupport;
import xaero.map.file.PNGExporter;
import xaero.map.graphics.GLObjectDeleter;
import xaero.map.graphics.TextureUploadBenchmark;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.WorldMapPacketConsumer;
import xaero.map.misc.Internet;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointSymbolCreator;
import xaero.map.patreon.Patreon;
import xaero.map.pool.MapTilePool;
import xaero.map.pool.TextureUploadPool;
import xaero.map.region.OverlayManager;
import xaero.map.resource.ShaderResourceReloadListener;
import xaero.map.server.WorldMapServer;
import xaero.map.server.core.XaeroWorldMapServerCore;
import xaero.map.settings.ModOptions;
import xaero.map.settings.ModSettings;
import xaero.map.task.MapRunnerTask;

public class WorldMap
implements ClientModInitializer,
DedicatedServerModInitializer {
    private static boolean loaded = false;
    public static WorldMap INSTANCE;
    public static int MINIMAP_COMPATIBILITY_VERSION;
    public static Logger LOGGER;
    private static final String versionID_minecraft = "1.18";
    private static final String versionID_mod = "1.18.6.1";
    public static final String versionID = "1.18_1.18.6.1_fabric";
    public static int newestUpdateID;
    public static boolean isOutdated;
    public static String fileLayoutID;
    public static String latestVersion;
    public static String latestVersionMD5;
    public static Events events;
    public static FMLEvents fmlEvents;
    public static ModEvents modEvents;
    public static ControlsRegister controlsRegister;
    public static WaypointSymbolCreator waypointSymbolCreator;
    public static ByteBufferDeallocator bufferDeallocator;
    public static TextureUploadBenchmark textureUploadBenchmark;
    public static OverlayManager overlayManager;
    public static OldFormatSupport oldFormatSupport;
    public static PNGExporter pngExporter;
    public static TextureUploadPool.Normal normalTextureUploadPool;
    public static TextureUploadPool.NormalWithDownload normalWithDownloadTextureUploadPool;
    public static TextureUploadPool.Compressed compressedTextureUploadPool;
    public static TextureUploadPool.BranchUpdate branchUpdatePool;
    public static TextureUploadPool.BranchUpdate branchUpdateAllocatePool;
    public static TextureUploadPool.BranchDownload branchDownloadPool;
    public static MapTilePool tilePool;
    public static MapLimiter mapLimiter;
    public static UnknownBlockStateCache unknownBlockStateCache;
    public static GLObjectDeleter glObjectDeleter;
    public static MapRunner mapRunner;
    public static Thread mapRunnerThread;
    public static CrashHandler crashHandler;
    public static final class_2960 guiTextures;
    public static File oldOptionsFile;
    public static File oldSaveFolder;
    public static File oldSaveFolder2;
    public static ModSettings settings;
    public static int globalVersion;
    public static WorldMapClient worldMapClient;
    private boolean loadLaterDone;
    public static WorldMapServer worldmapServer;
    private Throwable firstStageError;
    public static File modJAR;
    public static File configFolder;
    public static File optionsFile;
    public static File saveFolder;

    public void onInitializeClient() {
        INSTANCE = this;
        try {
            this.loadCommon();
            this.loadClient();
        }
        catch (Throwable e) {
            this.firstStageError = e;
        }
    }

    public void onInitializeServer() {
        INSTANCE = this;
        try {
            this.loadCommon();
            this.loadServer();
        }
        catch (Throwable e) {
            this.firstStageError = e;
        }
    }

    private void loadClient() throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Object patreonEntry;
        Path gameDir;
        Path modFile;
        LOGGER.info("Loading Xaero's World Map - Stage 1/2");
        events = new Events();
        fmlEvents = new FMLEvents();
        modEvents = new ModEvents();
        ModOptions.init();
        ModContainer modContainer = FabricLoader.getInstance().getModContainer("xaeroworldmap").orElse(null);
        if (modContainer == null) {
            modContainer = FabricLoader.getInstance().getModContainer("xaerodev").orElse(null);
        }
        try {
            modFile = UrlUtil.asPath((URL)modContainer.getOriginUrl());
        }
        catch (UrlConversionException e) {
            throw new RuntimeException("Weird... Couldn't convert URL to Path.", e);
        }
        worldMapClient = new WorldMapClient();
        worldMapClient.preInit(modContainer.getInfo().getId());
        String fileName = modFile.getFileName().toString();
        if (fileName.endsWith(".jar")) {
            modJAR = modFile.toFile();
        }
        if ((gameDir = FabricLoader.getInstance().getGameDirectory().toPath()).getFileName().toString().equals(".")) {
            gameDir = gameDir.getParent();
        }
        Path config = FabricLoader.getInstance().getConfigDirectory().toPath();
        configFolder = config.toFile();
        optionsFile = config.resolve("xaeroworldmap.txt").toFile();
        saveFolder = gameDir.resolve("XaeroWorldMap").toFile();
        Path oldSaveFolder3 = config.getParent().resolve("XaeroWorldMap");
        if (oldOptionsFile.exists() && !optionsFile.exists()) {
            Files.move(oldOptionsFile.toPath(), optionsFile.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder.exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder.toPath(), saveFolder.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder2.exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder2.toPath(), saveFolder.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder3.toFile().exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder3, saveFolder.toPath(), new CopyOption[0]);
        }
        if (!saveFolder.exists()) {
            Files.createDirectories(saveFolder.toPath(), new FileAttribute[0]);
        }
        Patreon.checkPatreon();
        Patreon.setRendersCapes(fileLayoutID);
        settings = new ModSettings();
        settings.loadSettings();
        Internet.checkModVersion();
        if (isOutdated && (patreonEntry = Patreon.getMods().get(fileLayoutID)) != null) {
            Patreon.setModInfo(patreonEntry, modJAR, versionID, latestVersion, latestVersionMD5, () -> {
                ModSettings.ignoreUpdate = newestUpdateID;
                try {
                    settings.saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            Patreon.addOutdatedMod(patreonEntry);
        }
        waypointSymbolCreator = new WaypointSymbolCreator();
        controlsRegister = new ControlsRegister();
        bufferDeallocator = new ByteBufferDeallocator();
        tilePool = new MapTilePool();
        overlayManager = new OverlayManager();
        oldFormatSupport = new OldFormatSupport();
        pngExporter = new PNGExporter(configFolder.toPath().getParent().resolve("map exports"));
        mapLimiter = new MapLimiter();
        normalTextureUploadPool = new TextureUploadPool.Normal(256);
        normalWithDownloadTextureUploadPool = new TextureUploadPool.NormalWithDownload(256);
        compressedTextureUploadPool = new TextureUploadPool.Compressed(256);
        branchUpdatePool = new TextureUploadPool.BranchUpdate(256, false);
        branchUpdateAllocatePool = new TextureUploadPool.BranchUpdate(256, true);
        branchDownloadPool = new TextureUploadPool.BranchDownload(256);
        textureUploadBenchmark = new TextureUploadBenchmark(512, 512, 512, 256, 256, 256);
        unknownBlockStateCache = new UnknownBlockStateCache();
        glObjectDeleter = new GLObjectDeleter();
        crashHandler = new CrashHandler();
        ClientSidePacketRegistryImpl.INSTANCE.register(WorldMapMessage.MAIN_CHANNEL, (PacketConsumer)new WorldMapPacketConsumer());
        ResourceManagerHelperImpl.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ShaderResourceReloadListener());
        mapRunner = new MapRunner();
        mapRunnerThread = new Thread(mapRunner);
        mapRunnerThread.start();
    }

    public void tryLoadLater() {
        if (this.loadLaterDone) {
            return;
        }
        if (this.firstStageError != null) {
            throw new RuntimeException(this.firstStageError);
        }
        this.loadLaterDone = true;
        LOGGER.info("Loading Xaero's World Map - Stage 2/2");
        try {
            settings.findMapItem();
            worldMapClient.postInit();
            settings.updateRegionCacheHashCode();
            SupportMods.load();
            oldFormatSupport.loadStates();
        }
        catch (Throwable e) {
            crashHandler.setCrashedBy(e);
        }
        loaded = true;
    }

    public static void incrementGlobalVersion() {
        mapRunner.addTask(new MapRunnerTask(){

            @Override
            public void run(MapProcessor mapProcessor) {
                ++globalVersion;
                if (mapProcessor != null) {
                    mapProcessor.getMapSaveLoad().updateCacheFolderList(mapProcessor.getMapSaveLoad().getMWSubFolder(mapProcessor.getCurrentWorldId(), mapProcessor.getCurrentDimId(), mapProcessor.getCurrentMWId()));
                }
                if (WorldMap.settings.debug) {
                    LOGGER.info("Version incremented to " + globalVersion);
                }
                try {
                    settings.saveSettings();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    private void loadServer() {
        worldmapServer = new WorldMapServer();
        worldmapServer.load();
        XaeroWorldMapServerCore.worldmapServer = worldmapServer;
    }

    private void loadCommon() {
        ModCommonEvents modEvents = new ModCommonEvents();
        modEvents.handleRegisterEffectsEvent();
    }

    public void tryLoadLaterServer() {
        if (this.loadLaterDone) {
            return;
        }
        if (this.firstStageError != null) {
            throw new RuntimeException(this.firstStageError);
        }
        this.loadLaterDone = true;
        worldmapServer.loadLater();
    }

    public boolean isLoaded() {
        return loaded;
    }

    static {
        MINIMAP_COMPATIBILITY_VERSION = 10;
        LOGGER = LogManager.getLogger();
        isOutdated = true;
        fileLayoutID = "worldmap_fabric";
        guiTextures = new class_2960("xaeroworldmap", "gui/gui.png");
        oldOptionsFile = new File("./xaeroworldmap.txt");
        oldSaveFolder = new File("./mods/XaeroWorldMap");
        oldSaveFolder2 = new File("./config/XaeroWorldMap");
        globalVersion = 1;
        modJAR = null;
    }
}

