/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file;

import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import xaero.map.MapProcessor;
import xaero.map.file.MapRegionInfo;
import xaero.map.region.MapRegion;
import xaero.map.region.texture.LeafRegionTexture;

public class RegionDetection
implements MapRegionInfo {
    private int initialVersion;
    private String worldId;
    private String dimId;
    private String mwId;
    private int regionX;
    private int regionZ;
    private boolean shouldCache;
    private File cacheFile;
    private File regionFile;
    private int[][] cachedTextureVersions;
    private int cacheHashCode;
    private int reloadVersion;

    public RegionDetection(String worldId, String dimId, String mwId, int regionX, int regionZ, File regionFile, int globalVersion) {
        this.worldId = worldId;
        this.dimId = dimId;
        this.mwId = mwId;
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.regionFile = regionFile;
        this.initialVersion = globalVersion;
    }

    public int getInitialVersion() {
        return this.initialVersion;
    }

    @Override
    public boolean shouldCache() {
        return this.shouldCache;
    }

    @Override
    public File getCacheFile() {
        return this.cacheFile;
    }

    @Override
    public void setShouldCache(boolean shouldCache, String fsdfs) {
        this.shouldCache = shouldCache;
    }

    @Override
    public void setCacheFile(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    @Override
    public String getWorldId() {
        return this.worldId;
    }

    @Override
    public String getDimId() {
        return this.dimId;
    }

    @Override
    public String getMwId() {
        return this.mwId;
    }

    @Override
    public int getRegionX() {
        return this.regionX;
    }

    @Override
    public int getRegionZ() {
        return this.regionZ;
    }

    public void transferInfoTo(MapRegion to) {
        to.setShouldCache(this.shouldCache, "transfer");
        to.setCacheFile(this.cacheFile);
        to.setInitialVersion(this.initialVersion);
        to.setRegionFile(this.regionFile);
    }

    public void transferInfoPostAddTo(MapRegion to, MapProcessor mapProcessor) {
        to.restoreMetaData(this.cachedTextureVersions, this.cacheHashCode, this.reloadVersion, mapProcessor);
    }

    public void transferInfoFrom(MapRegion from) {
        this.shouldCache = from.shouldCache();
        this.cacheFile = from.getCacheFile();
        this.initialVersion = from.getInitialVersion();
        this.regionFile = from.getRegionFile();
        if (from.getLoadState() >= 4) {
            this.cacheHashCode = from.getCacheHashCode();
            this.reloadVersion = from.getReloadVersion();
            this.cachedTextureVersions = new int[8][8];
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    LeafRegionTexture regTex = from.getTexture(i, j);
                    if (regTex == null) continue;
                    this.cachedTextureVersions[i][j] = regTex.getTextureVersion();
                }
            }
        }
    }

    public BufferedImage getRegionTexture() {
        try {
            return ImageIO.read(this.cacheFile);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public File getRegionFile() {
        return this.regionFile;
    }
}

