/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.okzoomer.config;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.ennuil.libzoomer.api.MouseModifier;
import io.github.ennuil.libzoomer.api.TransitionMode;
import io.github.ennuil.libzoomer.api.ZoomOverlay;
import io.github.ennuil.libzoomer.api.modifiers.CinematicCameraMouseModifier;
import io.github.ennuil.libzoomer.api.modifiers.ContainingMouseModifier;
import io.github.ennuil.libzoomer.api.modifiers.ZoomDivisorMouseModifier;
import io.github.ennuil.libzoomer.api.overlays.SpyglassZoomOverlay;
import io.github.ennuil.libzoomer.api.transitions.InstantTransitionMode;
import io.github.ennuil.libzoomer.api.transitions.SmoothTransitionMode;
import io.github.ennuil.okzoomer.config.ConfigEnums;
import io.github.ennuil.okzoomer.config.codec.FeaturesConfig;
import io.github.ennuil.okzoomer.config.codec.OkZoomerConfig;
import io.github.ennuil.okzoomer.config.codec.TweaksConfig;
import io.github.ennuil.okzoomer.config.codec.ValuesConfig;
import io.github.ennuil.okzoomer.config.json5.Json5Helper;
import io.github.ennuil.okzoomer.packets.ZoomPackets;
import io.github.ennuil.okzoomer.utils.ZoomUtils;
import io.github.ennuil.okzoomer.zoom.LinearTransitionMode;
import io.github.ennuil.okzoomer.zoom.MultipliedCinematicCameraMouseModifier;
import io.github.ennuil.okzoomer.zoom.ZoomerZoomOverlay;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.quiltmc.json5.JsonReader;
import org.quiltmc.json5.JsonWriter;
import org.quiltmc.json5.exception.MalformedSyntaxException;

public class OkZoomerConfigManager {
    public static Optional<Boolean> isConfigLoaded = Optional.empty();
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("okzoomer.json5");
    public static OkZoomerConfig INSTANCE = OkZoomerConfig.getDefaultSettings();

    public static void loadModConfig() {
        block5: {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                try {
                    JsonReader reader = JsonReader.json5((Path)CONFIG_PATH);
                    Optional result = OkZoomerConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)Json5Helper.parseJson5Reader(reader)).result();
                    reader.close();
                    if (result.isPresent()) {
                        INSTANCE = (OkZoomerConfig)result.get();
                        OkZoomerConfigManager.configureZoomInstance();
                        isConfigLoaded = Optional.of(true);
                        break block5;
                    }
                    ZoomUtils.LOGGER.error("Failed to load the settings!");
                    isConfigLoaded = Optional.of(false);
                }
                catch (IOException | MalformedSyntaxException e) {
                    ZoomUtils.LOGGER.error("Failed to load the settings!\n" + e.toString());
                }
            } else {
                OkZoomerConfigManager.saveModConfig();
                isConfigLoaded = Optional.of(true);
            }
        }
    }

    public static void saveModConfig() {
        Optional result = OkZoomerConfig.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)INSTANCE).result();
        if (result.isPresent()) {
            try {
                JsonWriter writer = JsonWriter.json5((Path)CONFIG_PATH);
                writer.beginObject().name("features").beginObject().comment("Defines the cinematic camera while zooming.\n\"OFF\" disables the cinematic camera.\n\"VANILLA\" uses Vanilla's cinematic camera.\n\"MULTIPLIED\" is a multiplied variant of \"VANILLA\".\n").name("cinematic_camera").value(INSTANCE.features().cinematicCamera().method_15434()).comment("Reduces the mouse sensitivity when zooming.").name("reduce_sensitivity").value(INSTANCE.features().reduceSensitivity()).comment("Adds transitions between zooms.\n\"OFF\" disables transitions.\n\"SMOOTH\" replicates Vanilla's dynamic FOV.\n\"LINEAR\" removes the smoothiness.\n").name("zoom_transition").value(INSTANCE.features().zoomTransition().method_15434()).comment("The behavior of the zoom key.\n\"HOLD\" needs the zoom key to be hold.\n\"TOGGLE\" has the zoom key toggle the zoom.\n\"PERSISTENT\" makes the zoom permanent.\n").name("zoom_mode").value(INSTANCE.features().zoomMode().method_15434()).comment("Allows to increase or decrease zoom by scrolling.").name("zoom_scrolling").value(INSTANCE.features().zoomScrolling()).comment("Adds zoom manipulation keys along with the zoom key.").name("extra_keybinds").value(INSTANCE.features().extraKeybinds()).comment("Adds an overlay in the screen during zoom.\n\"VIGNETTE\" uses a vignette as the overlay.\n\"SPYGLASS\" uses the spyglass overlay with the vignette texture.\nThe vignette texture can be found at: assets/okzoomer/textures/misc/zoom_overlay.png\n").name("zoom_overlay").value(INSTANCE.features().zoomOverlay().method_15434()).endObject().name("values").beginObject().comment("The divisor applied to the FOV when zooming.").name("zoom_divisor").value(INSTANCE.values().zoomDivisor()).comment("The minimum value that you can scroll down.").name("minimum_zoom_divisor").value(INSTANCE.values().minimumZoomDivisor()).comment("The maximum value that you can scroll down.").name("maximum_zoom_divisor").value(INSTANCE.values().maximumZoomDivisor()).comment("The number which is decremented or incremented by zoom scrolling.\nUsed when the zoom divisor is above the starting point.\n").name("scroll_step").value(INSTANCE.values().scrollStep()).comment("The number which is decremented or incremented by zoom scrolling.\nUsed when the zoom divisor is below the starting point.\n").name("lesser_scroll_step").value(INSTANCE.values().lesserScrollStep()).comment("The multiplier used for smooth transitions.").name("smooth_multiplier").value(INSTANCE.values().smoothMultiplier()).comment("The multiplier used for the multiplied cinematic camera.").name("cinematic_multiplier").value(INSTANCE.values().cinematicMultiplier()).comment("The minimum value which the linear transition step can reach.").name("minimum_linear_step").value(INSTANCE.values().minimumLinearStep()).comment("The maximum value which the linear transition step can reach.").name("maximum_linear_step").value(INSTANCE.values().maximumLinearStep()).endObject().name("tweaks").beginObject().comment("Allows for resetting the zoom with the middle mouse button.").name("reset_zoom_with_mouse").value(INSTANCE.tweaks().resetZoomWithMouse()).comment("If pressed, the \"Save Toolbar Activator\" keybind will be unbound if there's a conflict with the zoom key.").name("unbind_conflicting_key").value(INSTANCE.tweaks().unbindConflictingKey()).comment("If enabled, the spyglass overlay texture is used instead of Ok Zoomer's overlay texture.").name("use_spyglass_texture").value(INSTANCE.tweaks().useSpyglassTexture()).comment("If enabled, the zoom will use spyglass sounds on zooming in and out.").name("use_spyglass_sounds").value(INSTANCE.tweaks().useSpyglassSounds()).comment("Shows toasts when the server imposes a restriction.").name("show_restriction_toasts").value(INSTANCE.tweaks().showRestrictionToasts()).comment("Prints a random owo in the console when the game starts. Enabled by default until full release.").name("print_owo_on_start").value(INSTANCE.tweaks().printOwoOnStart()).endObject().endObject();
                writer.close();
                OkZoomerConfigManager.configureZoomInstance();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void configureZoomInstance() {
        ZoomUtils.zoomerZoom.setTransitionMode((TransitionMode)(switch (INSTANCE.features().zoomTransition()) {
            case ConfigEnums.ZoomTransitionOptions.SMOOTH -> new SmoothTransitionMode((float)INSTANCE.values().smoothMultiplier());
            case ConfigEnums.ZoomTransitionOptions.LINEAR -> new LinearTransitionMode(INSTANCE.values().minimumLinearStep(), INSTANCE.values().maximumLinearStep());
            default -> new InstantTransitionMode();
        }));
        if (ZoomPackets.getForceClassicMode()) {
            ZoomUtils.zoomerZoom.setDefaultZoomDivisor(4.0);
            ZoomUtils.zoomerZoom.setMouseModifier((MouseModifier)new CinematicCameraMouseModifier());
            ZoomUtils.zoomerZoom.setZoomOverlay(null);
            return;
        }
        ZoomUtils.zoomerZoom.setDefaultZoomDivisor(INSTANCE.values().zoomDivisor());
        OkZoomerConfigManager.configureZoomModifier();
        class_2960 overlayTextureId = new class_2960(INSTANCE.tweaks().useSpyglassTexture() ? "textures/misc/spyglass_scope.png" : "okzoomer:textures/misc/zoom_overlay.png");
        ZoomUtils.zoomerZoom.setZoomOverlay((ZoomOverlay)(switch (INSTANCE.features().zoomOverlay()) {
            case ConfigEnums.ZoomOverlays.VIGNETTE -> new ZoomerZoomOverlay(overlayTextureId);
            case ConfigEnums.ZoomOverlays.SPYGLASS -> new SpyglassZoomOverlay(overlayTextureId);
            default -> null;
        }));
    }

    public static void configureZoomModifier() {
        ConfigEnums.CinematicCameraOptions cinematicCamera = INSTANCE.features().cinematicCamera();
        boolean reduceSensitivity = INSTANCE.features().reduceSensitivity();
        if (cinematicCamera != ConfigEnums.CinematicCameraOptions.OFF) {
            Object cinematicModifier = switch (cinematicCamera) {
                case ConfigEnums.CinematicCameraOptions.VANILLA -> new CinematicCameraMouseModifier();
                case ConfigEnums.CinematicCameraOptions.MULTIPLIED -> new MultipliedCinematicCameraMouseModifier(INSTANCE.values().cinematicMultiplier());
                default -> null;
            };
            ZoomUtils.zoomerZoom.setMouseModifier((MouseModifier)(reduceSensitivity ? new ContainingMouseModifier(new MouseModifier[]{cinematicModifier, new ZoomDivisorMouseModifier()}) : cinematicModifier));
        } else {
            ZoomUtils.zoomerZoom.setMouseModifier((MouseModifier)(reduceSensitivity ? new ZoomDivisorMouseModifier() : null));
        }
    }

    public static void resetToPreset(ZoomPresets preset) {
        ConfigEnums.CinematicCameraOptions cinematicCameraOptions = preset == ZoomPresets.CLASSIC ? ConfigEnums.CinematicCameraOptions.VANILLA : ConfigEnums.CinematicCameraOptions.OFF;
        boolean bl = preset != ZoomPresets.CLASSIC;
        ConfigEnums.ZoomTransitionOptions zoomTransitionOptions = preset == ZoomPresets.CLASSIC ? ConfigEnums.ZoomTransitionOptions.OFF : ConfigEnums.ZoomTransitionOptions.SMOOTH;
        ConfigEnums.ZoomModes zoomModes = preset == ZoomPresets.PERSISTENT ? ConfigEnums.ZoomModes.PERSISTENT : ConfigEnums.ZoomModes.HOLD;
        FeaturesConfig featuresConfig = new FeaturesConfig(cinematicCameraOptions, bl, zoomTransitionOptions, zoomModes, switch (preset) {
            case ZoomPresets.CLASSIC -> false;
            case ZoomPresets.SPYGLASS -> false;
            default -> true;
        }, preset != ZoomPresets.CLASSIC, preset == ZoomPresets.SPYGLASS ? ConfigEnums.ZoomOverlays.SPYGLASS : ConfigEnums.ZoomOverlays.OFF);
        INSTANCE = new OkZoomerConfig(featuresConfig, new ValuesConfig(switch (preset) {
            case ZoomPresets.PERSISTENT -> 1.0;
            case ZoomPresets.SPYGLASS -> 10.0;
            default -> 4.0;
        }, 1.0, 50.0, 1.0, 0.5, preset == ZoomPresets.SPYGLASS ? 0.5 : 0.75, 4.0, 0.125, 0.25), new TweaksConfig(preset != ZoomPresets.CLASSIC, false, preset == ZoomPresets.SPYGLASS, preset == ZoomPresets.SPYGLASS, true, preset != ZoomPresets.CLASSIC));
    }

    public static enum ZoomPresets {
        DEFAULT,
        CLASSIC,
        PERSISTENT,
        SPYGLASS;

    }
}

