/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.okzoomer.packets;

import io.github.ennuil.okzoomer.config.OkZoomerConfigManager;
import io.github.ennuil.okzoomer.utils.ZoomUtils;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;

public class ZoomPackets {
    public static final class_2960 DISABLE_ZOOM_PACKET_ID = new class_2960("okzoomer", "disable_zoom");
    public static final class_2960 DISABLE_ZOOM_SCROLLING_PACKET_ID = new class_2960("okzoomer", "disable_zoom_scrolling");
    public static final class_2960 FORCE_CLASSIC_MODE_PACKET_ID = new class_2960("okzoomer", "force_classic_mode");
    public static final class_2960 FORCE_ZOOM_DIVISOR_PACKET_ID = new class_2960("okzoomer", "force_zoom_divisor");
    public static final class_2960 ACKNOWLEDGE_MOD_PACKET_ID = new class_2960("okzoomer", "acknowledge_mod");
    public static final class_2960 FORCE_SPYGLASS_PACKET_ID = new class_2960("okzoomer", "force_spyglass");
    private static boolean disableZoom = false;
    private static boolean disableZoomScrolling = false;
    private static boolean forceClassicMode = false;
    private static boolean forceZoomDivisors = false;
    public static double maximumZoomDivisor = 0.0;
    public static double minimumZoomDivisor = 0.0;
    private static class_2588 toastTitle = new class_2588("toast.okzoomer.title");

    private static void sendToast(class_310 client, class_2561 description) {
        if (OkZoomerConfigManager.INSTANCE.tweaks().showRestrictionToasts()) {
            client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_371)class_370.class_371.field_2218, (class_2561)toastTitle, (class_2561)description));
        }
    }

    public static void registerPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DISABLE_ZOOM_PACKET_ID, (client, handler, buf, sender) -> client.execute(() -> {
            ZoomPackets.sendToast(client, (class_2561)new class_2588("toast.okzoomer.disable_zoom"));
            ZoomUtils.LOGGER.info("[Ok Zoomer] This server has disabled zooming");
            disableZoom = true;
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DISABLE_ZOOM_SCROLLING_PACKET_ID, (client, handler, buf, sender) -> client.execute(() -> {
            ZoomPackets.sendToast(client, (class_2561)new class_2588("toast.okzoomer.disable_zoom_scrolling"));
            ZoomUtils.LOGGER.info("[Ok Zoomer] This server has disabled zoom scrolling");
            disableZoomScrolling = true;
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FORCE_CLASSIC_MODE_PACKET_ID, (client, handler, buf, sender) -> client.execute(() -> {
            ZoomUtils.LOGGER.info("[Ok Zoomer] This server has imposed classic mode");
            ZoomPackets.sendToast(client, (class_2561)new class_2588("toast.okzoomer.force_classic_mode"));
            disableZoomScrolling = true;
            forceClassicMode = true;
            OkZoomerConfigManager.configureZoomInstance();
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FORCE_ZOOM_DIVISOR_PACKET_ID, (client, handler, buf, sender) -> {
            int readableBytes = buf.readableBytes();
            if (readableBytes == 8 || readableBytes == 16) {
                double maxDouble = buf.readDouble();
                double minDouble = readableBytes == 16 ? buf.readDouble() : maxDouble;
                client.execute(() -> {
                    if (minimumZoomDivisor != 0.0 || maximumZoomDivisor != 0.0) {
                        ZoomUtils.LOGGER.info("[Ok Zoomer] This server has attempted to set invalid divisor values! (min %s, max %s)", (Object)minDouble, (Object)maxDouble);
                    } else {
                        ZoomUtils.LOGGER.info("[Ok Zoomer] This server has set the zoom divisors to minimum %s and maximum %s", (Object)minDouble, (Object)maxDouble);
                        ZoomPackets.sendToast(client, (class_2561)new class_2588("toast.okzoomer.force_zoom_divisor"));
                        maximumZoomDivisor = maxDouble;
                        minimumZoomDivisor = minDouble;
                        forceZoomDivisors = true;
                        OkZoomerConfigManager.configureZoomInstance();
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ACKNOWLEDGE_MOD_PACKET_ID, (client, handler, buf, sender) -> {
            boolean restricting = buf.readBoolean();
            client.execute(() -> {
                if (restricting) {
                    ZoomUtils.LOGGER.info("[Ok Zoomer] This server acknowledges the mod and has established some restrictions");
                    ZoomPackets.sendToast(client, (class_2561)new class_2588("toast.okzoomer.acknowledge_mod_restrictions"));
                } else {
                    ZoomUtils.LOGGER.info("[Ok Zoomer] This server acknowledges the mod and establishes no restrictions");
                    ZoomPackets.sendToast(client, (class_2561)new class_2588("toast.okzoomer.acknowledge_mod"));
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FORCE_SPYGLASS_PACKET_ID, (client, handler, buf, sender) -> client.execute(() -> {
            ZoomUtils.LOGGER.info("[Ok Zoomer] This server has forced the spyglass mode, but it hasn't been implemented on this version! Disabling zoom");
            ZoomPackets.sendToast(client, (class_2561)new class_2588("toast.okzoomer.disable_zoom"));
            disableZoom = true;
        }));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (disableZoom || disableZoomScrolling || forceClassicMode) {
                ZoomPackets.resetPacketSignals();
            }
        });
    }

    public static boolean getDisableZoom() {
        return disableZoom;
    }

    public static boolean getDisableZoomScrolling() {
        return disableZoomScrolling;
    }

    public static boolean getForceClassicMode() {
        return forceClassicMode;
    }

    public static boolean getForceZoomDivisors() {
        return forceZoomDivisors;
    }

    public static double getMaximumZoomDivisor() {
        return maximumZoomDivisor;
    }

    public static double getMinimumZoomDivisor() {
        return minimumZoomDivisor;
    }

    private static void resetPacketSignals() {
        disableZoom = false;
        disableZoomScrolling = false;
        forceZoomDivisors = false;
        maximumZoomDivisor = 0.0;
        minimumZoomDivisor = 0.0;
        if (forceClassicMode) {
            forceClassicMode = false;
            OkZoomerConfigManager.configureZoomInstance();
        }
    }
}

