/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.IMixinBeaconBlockEntity;
import fi.dy.masa.minihud.mixin.IMixinWorld;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5562;
import net.minecraft.class_6603;
import net.minecraft.class_757;

public class OverlayRendererBeaconRange
extends OverlayRendererBase {
    private static final Set<class_2338> BEACON_POSITIONS = new HashSet<class_2338>();
    private static final LongOpenHashSet BEACON_CHUNKS = new LongOpenHashSet();
    private static boolean needsUpdate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Set<class_2338> set = BEACON_POSITIONS;
        synchronized (set) {
            BEACON_CHUNKS.clear();
            BEACON_POSITIONS.clear();
        }
    }

    public static void setNeedsUpdate() {
        if (!RendererToggle.OVERLAY_BEACON_RANGE.getBooleanValue()) {
            OverlayRendererBeaconRange.clear();
        }
        needsUpdate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkNeedsUpdate(class_2338 pos, class_2680 state) {
        Set<class_2338> set = BEACON_POSITIONS;
        synchronized (set) {
            if (RendererToggle.OVERLAY_BEACON_RANGE.getBooleanValue() && Configs.Generic.BEACON_RANGE_AUTO_UPDATE.getBooleanValue() && (state.method_26204() == class_2246.field_10327 || BEACON_POSITIONS.contains(pos))) {
                OverlayRendererBeaconRange.setNeedsUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkNeedsUpdate(int chunkX, int chunkZ) {
        Set<class_2338> set = BEACON_POSITIONS;
        synchronized (set) {
            if (RendererToggle.OVERLAY_BEACON_RANGE.getBooleanValue() && Configs.Generic.BEACON_RANGE_AUTO_UPDATE.getBooleanValue() && BEACON_CHUNKS.contains(class_1923.method_8331((int)chunkX, (int)chunkZ))) {
                OverlayRendererBeaconRange.setNeedsUpdate();
            }
        }
        return needsUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkNeedsUpdate(int chunkX, int chunkZ, class_6603 data) {
        Set<class_2338> set = BEACON_POSITIONS;
        synchronized (set) {
            if (RendererToggle.OVERLAY_BEACON_RANGE.getBooleanValue() && Configs.Generic.BEACON_RANGE_AUTO_UPDATE.getBooleanValue()) {
                data.method_38587(chunkX, chunkZ).accept((pos, type, nbt) -> OverlayRendererBeaconRange.checkNeedsUpdate(type));
            }
        }
        return needsUpdate;
    }

    private static void checkNeedsUpdate(class_2591<?> type) {
        if (type == class_2591.field_11890) {
            OverlayRendererBeaconRange.setNeedsUpdate();
        }
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return RendererToggle.OVERLAY_BEACON_RANGE.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        return needsUpdate || this.lastUpdatePos == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        OverlayRendererBeaconRange.clear();
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.method_1328(renderQuads.getGlMode(), class_290.field_1576);
        BUFFER_2.method_1328(renderLines.getGlMode(), class_290.field_1576);
        Set<class_2338> set = BEACON_POSITIONS;
        synchronized (set) {
            this.renderBeaconRanges(entity.method_5770(), cameraPos, BUFFER_1, BUFFER_2);
        }
        BUFFER_1.method_1326();
        BUFFER_2.method_1326();
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        needsUpdate = false;
    }

    protected static Color4f getColorForLevel(int level) {
        switch (level) {
            case 1: {
                return Configs.Colors.BEACON_RANGE_LVL1_OVERLAY_COLOR.getColor();
            }
            case 2: {
                return Configs.Colors.BEACON_RANGE_LVL2_OVERLAY_COLOR.getColor();
            }
            case 3: {
                return Configs.Colors.BEACON_RANGE_LVL2_OVERLAY_COLOR.getColor();
            }
        }
        return Configs.Colors.BEACON_RANGE_LVL4_OVERLAY_COLOR.getColor();
    }

    protected void renderBeaconRanges(class_1937 world, class_243 cameraPos, class_287 bufferQuads, class_287 bufferLines) {
        for (class_5562 ticker : ((IMixinWorld)world).minihud_getBlockEntityTickers()) {
            class_2586 be = world.method_8321(ticker.method_31705());
            if (!(be instanceof class_2580)) continue;
            class_2338 pos = be.method_11016();
            int level = ((IMixinBeaconBlockEntity)be).minihud_getLevel();
            if (level < 1 || level > 4) continue;
            this.renderBeaconBox(world, pos, level, cameraPos, OverlayRendererBeaconRange.getColorForLevel(level), bufferQuads, bufferLines);
        }
    }

    protected void renderBeaconBox(class_1937 world, class_2338 pos, int level, class_243 cameraPos, Color4f color, class_287 bufferQuads, class_287 bufferLines) {
        double x = (double)pos.method_10263() - cameraPos.field_1352;
        double y = (double)pos.method_10264() - cameraPos.field_1351;
        double z = (double)pos.method_10260() - cameraPos.field_1350;
        int range = level * 10 + 10;
        double minX = x - (double)range;
        double minY = y - (double)range;
        double minZ = z - (double)range;
        double maxX = x + (double)range + 1.0;
        double maxY = this.getMaxHeight(world, pos, range);
        double maxZ = z + (double)range + 1.0;
        RenderUtils.drawBoxAllSidesBatchedQuads((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (class_287)bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)Color4f.fromColor((Color4f)color, (float)1.0f), (class_287)bufferLines);
        BEACON_POSITIONS.add(pos);
        BEACON_CHUNKS.add(class_1923.method_8331((int)(pos.method_10263() >> 4), (int)(pos.method_10260() >> 4)));
    }

    protected int getMaxHeight(class_1937 world, class_2338 pos, int range) {
        int minX = pos.method_10263() - range;
        int minZ = pos.method_10260() - range;
        int maxX = pos.method_10263() + range;
        int maxZ = pos.method_10260() + range;
        int minCX = minX >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCZ = maxZ >> 4;
        int maxY = 0;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                class_2818 chunk = world.method_8497(cx, cz);
                int height = chunk.method_12031() + 15;
                if (height <= maxY) continue;
                maxY = height;
            }
        }
        return maxY + 4;
    }

    public static void renderBeaconBoxForPlayerIfHoldingItem(class_1297 entity, class_4587 matrixStack, class_1159 projMatrix, class_310 mc) {
        class_1792 item = mc.field_1724.method_6047().method_7909();
        if (item instanceof class_1747 && ((class_1747)item).method_7711() == class_2246.field_10327) {
            OverlayRendererBeaconRange.renderBeaconBoxForPlayer(entity, matrixStack, projMatrix, mc);
            return;
        }
        item = mc.field_1724.method_6047().method_7909();
        if (item instanceof class_1747 && ((class_1747)item).method_7711() == class_2246.field_10327) {
            OverlayRendererBeaconRange.renderBeaconBoxForPlayer(entity, matrixStack, projMatrix, mc);
        }
    }

    private static void renderBeaconBoxForPlayer(class_1297 entity, class_4587 matrixStack, class_1159 projMatrix, class_310 mc) {
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double x = Math.floor(entity.method_23317()) - cameraPos.field_1352;
        double y = Math.floor(entity.method_23318()) - cameraPos.field_1351;
        double z = Math.floor(entity.method_23321()) - cameraPos.field_1350;
        int level = mc.field_1724.method_5715() ? Math.min(4, mc.field_1724.method_31548().field_7545 + 1) : 4;
        double range = level * 10 + 10;
        double minX = x - range;
        double minY = y - range;
        double minZ = z - range;
        double maxX = x + range + 1.0;
        double maxY = y + 4.0;
        double maxZ = z + range + 1.0;
        Color4f color = OverlayRendererBeaconRange.getColorForLevel(level);
        RenderSystem.disableTexture();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderUtils.setupBlend();
        RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.applyModelViewMatrix();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        RenderUtils.drawBoxAllSidesBatchedQuads((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)Color4f.fromColor((Color4f)color, (float)0.3f), (class_287)buffer);
        tessellator.method_1350();
        buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        RenderUtils.drawBoxAllEdgesBatchedLines((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)Color4f.fromColor((Color4f)color, (float)1.0f), (class_287)buffer);
        tessellator.method_1350();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.enableCull();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }
}

