/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.util.ShapeRenderType;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_293;
import net.minecraft.class_4587;

public abstract class ShapeCircleBase
extends ShapeBase {
    protected static final class_2350[] FACING_ALL = new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};
    protected BlockSnap snap = BlockSnap.CENTER;
    protected class_2350 mainAxis = class_2350.field_11036;
    protected double radius;
    protected double radiusSq;
    protected double maxRadius = 256.0;
    protected class_243 center = class_243.field_1353;
    protected class_243 effectiveCenter = class_243.field_1353;
    protected class_243 lastUpdatePos = class_243.field_1353;
    protected long lastUpdateTime;

    public ShapeCircleBase(ShapeType type, Color4f color, double radius) {
        super(type, color);
        this.setRadius(radius);
        class_1297 entity = EntityUtils.getCameraEntity();
        if (entity != null) {
            class_243 center = entity.method_19538();
            center = new class_243(Math.floor(center.field_1352) + 0.5, Math.floor(center.field_1351), Math.floor(center.field_1350) + 0.5);
            this.setCenter(center);
        } else {
            this.setCenter(class_243.field_1353);
        }
    }

    public class_243 getCenter() {
        return this.center;
    }

    public void setCenter(class_243 center) {
        this.center = center;
        this.updateEffectiveCenter();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        if (radius >= 0.0 && radius <= this.maxRadius) {
            this.radius = radius;
            this.radiusSq = radius * radius;
            this.setNeedsUpdate();
        }
    }

    public class_2350 getMainAxis() {
        return this.mainAxis;
    }

    public void setMainAxis(class_2350 mainAxis) {
        this.mainAxis = mainAxis;
        this.setNeedsUpdate();
    }

    protected class_2338 getCenterBlock() {
        return new class_2338(this.center);
    }

    public BlockSnap getBlockSnap() {
        return this.snap;
    }

    public void setBlockSnap(BlockSnap snap) {
        this.snap = snap;
        this.updateEffectiveCenter();
    }

    protected void updateEffectiveCenter() {
        class_243 center = this.center;
        this.effectiveCenter = this.snap == BlockSnap.CENTER ? new class_243(Math.floor(center.field_1352) + 0.5, Math.floor(center.field_1351), Math.floor(center.field_1350) + 0.5) : (this.snap == BlockSnap.CORNER ? new class_243(Math.floor(center.field_1352), Math.floor(center.field_1351), Math.floor(center.field_1350)) : center);
        this.center = this.effectiveCenter;
        this.setNeedsUpdate();
    }

    protected void onPostUpdate(class_243 updatePosition) {
        this.needsUpdate = false;
        this.lastUpdatePos = updatePosition;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(class_293.class_5596.field_27382);
    }

    @Override
    public void draw(class_4587 matrixStack, class_1159 projMatrix) {
        this.preRender();
        ((RenderObjectBase)this.renderObjects.get(0)).draw(matrixStack, projMatrix);
        RenderSystem.polygonMode((int)1032, (int)6913);
        RenderSystem.disableBlend();
        ((RenderObjectBase)this.renderObjects.get(0)).draw(matrixStack, projMatrix);
        RenderSystem.polygonMode((int)1032, (int)6914);
        RenderSystem.enableBlend();
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("center", (JsonElement)JsonUtils.vec3dToJson((class_243)this.center));
        obj.add("main_axis", (JsonElement)new JsonPrimitive(this.mainAxis.name()));
        obj.add("snap", (JsonElement)new JsonPrimitive(this.snap.getStringValue()));
        obj.add("radius", (JsonElement)new JsonPrimitive((Number)this.radius));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        class_243 center;
        class_2350 facing;
        super.fromJson(obj);
        if (JsonUtils.hasString((JsonObject)obj, (String)"snap")) {
            this.snap = BlockSnap.fromStringStatic((String)JsonUtils.getString((JsonObject)obj, (String)"snap"));
        }
        if (JsonUtils.hasString((JsonObject)obj, (String)"main_axis") && (facing = class_2350.valueOf((String)obj.get("main_axis").getAsString())) != null) {
            this.setMainAxis(facing);
        }
        if (JsonUtils.hasDouble((JsonObject)obj, (String)"radius")) {
            this.setRadius(JsonUtils.getDouble((JsonObject)obj, (String)"radius"));
        }
        if ((center = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"center")) != null) {
            this.setCenter(center);
        }
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        class_243 c = this.center;
        String aq = GuiBase.TXT_AQUA;
        String bl = GuiBase.TXT_BLUE;
        String gl = GuiBase.TXT_GOLD;
        String gr = GuiBase.TXT_GRAY;
        String rst = GuiBase.TXT_GRAY;
        lines.add(gr + StringUtils.translate((String)"minihud.gui.label.radius_value", (Object[])new Object[]{gl + String.valueOf(this.getRadius()) + rst}));
        lines.add(gr + StringUtils.translate((String)"minihud.gui.label.center_value", (Object[])new Object[]{String.format("x: %s%.2f%s, y: %s%.2f%s, z: %s%.2f%s", bl, c.field_1352, rst, bl, c.field_1351, rst, bl, c.field_1350, rst)}));
        lines.add(gr + StringUtils.translate((String)"minihud.gui.label.block_snap", (Object[])new Object[]{aq + this.snap.getDisplayName() + rst}));
        if (this.snap != BlockSnap.NONE) {
            c = this.effectiveCenter;
            lines.add(gr + StringUtils.translate((String)"minihud.gui.label.effective_center_value", (Object[])new Object[]{String.format("x: %s%.2f%s, y: %s%.2f%s, z: %s%.2f%s", bl, c.field_1352, rst, bl, c.field_1351, rst, bl, c.field_1350, rst)}));
        }
        return lines;
    }

    protected void renderPositions(HashSet<class_2338> positions, class_2350[] sides, class_2350 mainAxis, Color4f color, class_243 cameraPos) {
        boolean full = this.renderType == ShapeRenderType.FULL_BLOCK;
        boolean outer = this.renderType == ShapeRenderType.OUTER_EDGE;
        boolean inner = this.renderType == ShapeRenderType.INNER_EDGE;
        LayerRange range = this.layerRange;
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        for (class_2338 pos : positions) {
            if (!range.isPositionWithinRange(pos)) continue;
            for (int i = 0; i < sides.length; ++i) {
                class_2350 side = sides[i];
                posMutable.method_10103(pos.method_10263() + side.method_10148(), pos.method_10264() + side.method_10164(), pos.method_10260() + side.method_10165());
                if (positions.contains(posMutable)) continue;
                boolean render = full;
                if (!full) {
                    boolean onOrIn = this.isPositionOnOrInsideRing(posMutable.method_10263(), posMutable.method_10264(), posMutable.method_10260(), side, mainAxis);
                    render |= outer && !onOrIn || inner && onOrIn;
                }
                if (!render) continue;
                ShapeCircleBase.drawBlockSpaceSideBatchedQuads(pos, side, color, 0.0, cameraPos, BUFFER_1);
            }
        }
    }

    protected void addPositionsOnHorizontalRing(HashSet<class_2338> positions, class_2338.class_2339 posMutable, class_2350 direction) {
        if (this.movePositionToRing(posMutable, direction, class_2350.field_11036)) {
            class_2338 posFirst = posMutable.method_10062();
            positions.add(posFirst);
            double r = this.radius;
            int failsafe = (int)(7.853981633974483 * r);
            while (--failsafe > 0 && (direction = this.getNextPositionOnHorizontalRing(posMutable, direction)) != null && !posMutable.equals((Object)posFirst)) {
                positions.add(posMutable.method_10062());
            }
        }
    }

    protected void addPositionsOnVerticalRing(HashSet<class_2338> positions, class_2338.class_2339 posMutable, class_2350 direction, class_2350 mainAxis) {
        if (this.movePositionToRing(posMutable, direction, mainAxis)) {
            class_2338 posFirst = posMutable.method_10062();
            positions.add(posFirst);
            double r = this.radius;
            int failsafe = (int)(7.853981633974483 * r);
            while (--failsafe > 0 && (direction = this.getNextPositionOnVerticalRing(posMutable, direction, mainAxis)) != null && !posMutable.equals((Object)posFirst)) {
                positions.add(posMutable.method_10062());
            }
        }
    }

    protected boolean movePositionToRing(class_2338.class_2339 posMutable, class_2350 dir, class_2350 mainAxis) {
        int x = posMutable.method_10263();
        int y = posMutable.method_10264();
        int z = posMutable.method_10260();
        int xNext = x;
        int yNext = y;
        int zNext = z;
        int failsafe = 0;
        int failsafeMax = (int)this.radius + 5;
        while (this.isPositionOnOrInsideRing(xNext, yNext, zNext, dir, mainAxis) && ++failsafe < failsafeMax) {
            x = xNext;
            y = yNext;
            z = zNext;
            xNext += dir.method_10148();
            yNext += dir.method_10164();
            zNext += dir.method_10165();
        }
        if (failsafe > 0) {
            posMutable.method_10103(x, y, z);
            return true;
        }
        return false;
    }

    @Nullable
    protected class_2350 getNextPositionOnHorizontalRing(class_2338.class_2339 posMutable, class_2350 dir) {
        class_2350 dirOut = dir;
        class_2350 ccw90 = ShapeCircleBase.getNextDirRotating(dir);
        int y = posMutable.method_10264();
        for (int i = 0; i < 4; ++i) {
            int z;
            int x = posMutable.method_10263() + dir.method_10148();
            if (this.isPositionOnOrInsideRing(x, y, z = posMutable.method_10260() + dir.method_10165(), dir, class_2350.field_11036)) {
                posMutable.method_10103(x, y, z);
                return dirOut;
            }
            if (this.isPositionOnOrInsideRing(x += ccw90.method_10148(), y, z += ccw90.method_10165(), dir, class_2350.field_11036)) {
                posMutable.method_10103(x, y, z);
                return dirOut;
            }
            dirOut = dir;
            dir = ShapeCircleBase.getNextDirRotating(dir);
            ccw90 = ShapeCircleBase.getNextDirRotating(dir);
        }
        return null;
    }

    @Nullable
    protected class_2350 getNextPositionOnVerticalRing(class_2338.class_2339 posMutable, class_2350 dir, class_2350 mainAxis) {
        class_2350 dirOut = dir;
        class_2350 ccw90 = ShapeCircleBase.getNextDirRotatingVertical(dir, mainAxis);
        for (int i = 0; i < 4; ++i) {
            int z;
            int y;
            int x = posMutable.method_10263() + dir.method_10148();
            if (this.isPositionOnOrInsideRing(x, y = posMutable.method_10264() + dir.method_10164(), z = posMutable.method_10260() + dir.method_10165(), dir, mainAxis)) {
                posMutable.method_10103(x, y, z);
                return dirOut;
            }
            if (this.isPositionOnOrInsideRing(x += ccw90.method_10148(), y += ccw90.method_10164(), z += ccw90.method_10165(), dir, mainAxis)) {
                posMutable.method_10103(x, y, z);
                return dirOut;
            }
            dirOut = dir;
            dir = ShapeCircleBase.getNextDirRotatingVertical(dir, mainAxis);
            ccw90 = ShapeCircleBase.getNextDirRotatingVertical(dir, mainAxis);
        }
        return null;
    }

    protected boolean isPositionOnOrInsideRing(int blockX, int blockY, int blockZ, class_2350 outSide, class_2350 mainAxis) {
        double zAdj;
        double yAdj;
        double x = (double)blockX + 0.5;
        double y = (double)blockY + 0.5;
        double z = (double)blockZ + 0.5;
        double dist = this.effectiveCenter.method_1028(x, y, z);
        double diff = this.radiusSq - dist;
        if (diff > 0.0) {
            return true;
        }
        double xAdj = (double)blockX + (double)outSide.method_10148() + 0.5;
        double distAdj = this.effectiveCenter.method_1028(xAdj, yAdj = (double)blockY + (double)outSide.method_10164() + 0.5, zAdj = (double)blockZ + (double)outSide.method_10165() + 0.5);
        double diffAdj = this.radiusSq - distAdj;
        return diffAdj > 0.0 && Math.abs(diff) < Math.abs(diffAdj);
    }

    protected boolean isAdjacentPositionOutside(class_2338 pos, class_2350 dir, class_2350 mainAxis) {
        return !this.isPositionOnOrInsideRing(pos.method_10263() + dir.method_10148(), pos.method_10264() + dir.method_10164(), pos.method_10260() + dir.method_10165(), dir, mainAxis);
    }

    protected static class_2350 getNextDirRotating(class_2350 dirIn) {
        switch (dirIn) {
            case field_11034: {
                return class_2350.field_11043;
            }
            case field_11043: {
                return class_2350.field_11039;
            }
            case field_11039: {
                return class_2350.field_11035;
            }
            case field_11035: {
                return class_2350.field_11034;
            }
        }
        return class_2350.field_11043;
    }

    protected static class_2350 getNextDirRotatingVertical(class_2350 dirIn, class_2350 mainAxis) {
        switch (mainAxis) {
            case field_11036: 
            case field_11033: {
                switch (dirIn) {
                    case field_11036: {
                        return class_2350.field_11043;
                    }
                    case field_11043: {
                        return class_2350.field_11033;
                    }
                    case field_11033: {
                        return class_2350.field_11035;
                    }
                    case field_11035: {
                        return class_2350.field_11036;
                    }
                }
                return class_2350.field_11043;
            }
            case field_11043: 
            case field_11035: {
                switch (dirIn) {
                    case field_11036: {
                        return class_2350.field_11034;
                    }
                    case field_11034: {
                        return class_2350.field_11033;
                    }
                    case field_11033: {
                        return class_2350.field_11039;
                    }
                    case field_11039: {
                        return class_2350.field_11036;
                    }
                }
                return class_2350.field_11034;
            }
            case field_11034: 
            case field_11039: {
                switch (dirIn) {
                    case field_11036: {
                        return class_2350.field_11035;
                    }
                    case field_11035: {
                        return class_2350.field_11033;
                    }
                    case field_11033: {
                        return class_2350.field_11043;
                    }
                    case field_11043: {
                        return class_2350.field_11036;
                    }
                }
                return class_2350.field_11035;
            }
        }
        return class_2350.field_11036;
    }

    public static void drawBlockSpaceSideBatchedQuads(class_2338 pos, class_2350 side, Color4f color, double expand, class_243 cameraPos, class_287 buffer) {
        double minX = (double)pos.method_10263() - expand - cameraPos.field_1352;
        double minY = (double)pos.method_10264() - expand - cameraPos.field_1351;
        double minZ = (double)pos.method_10260() - expand - cameraPos.field_1350;
        double maxX = (double)pos.method_10263() + expand + 1.0 - cameraPos.field_1352;
        double maxY = (double)pos.method_10264() + expand + 1.0 - cameraPos.field_1351;
        double maxZ = (double)pos.method_10260() + expand + 1.0 - cameraPos.field_1350;
        switch (side) {
            case field_11033: {
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11036: {
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11043: {
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11035: {
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11039: {
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11034: {
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_1344();
            }
        }
    }
}

