/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import fi.dy.masa.minihud.config.StructureToggle;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.class_2378;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3195;

public enum StructureType {
    BURIED_TREASURE(StructureToggle.OVERLAY_STRUCTURE_BURIED_TREASURE, "buried_treasure", class_2874.field_26752),
    DESERT_PYRAMID(StructureToggle.OVERLAY_STRUCTURE_DESERT_PYRAMID, "desert_pyramid", class_2874.field_26752),
    IGLOO(StructureToggle.OVERLAY_STRUCTURE_IGLOO, "igloo", class_2874.field_26752),
    JUNGLE_TEMPLE(StructureToggle.OVERLAY_STRUCTURE_JUNGLE_TEMPLE, "jungle_pyramid", class_2874.field_26752),
    MANSION(StructureToggle.OVERLAY_STRUCTURE_MANSION, "mansion", class_2874.field_26752),
    MINESHAFT(StructureToggle.OVERLAY_STRUCTURE_MINESHAFT, "mineshaft", class_2874.field_26752),
    OCEAN_MONUMENT(StructureToggle.OVERLAY_STRUCTURE_OCEAN_MONUMENT, "monument", class_2874.field_26752),
    OCEAN_RUIN(StructureToggle.OVERLAY_STRUCTURE_OCEAN_RUIN, "ocean_ruin", class_2874.field_26752),
    PILLAGER_OUTPOST(StructureToggle.OVERLAY_STRUCTURE_PILLAGER_OUTPOST, "pillager_outpost", class_2874.field_26752),
    SHIPWRECK(StructureToggle.OVERLAY_STRUCTURE_SHIPWRECK, "shipwreck", class_2874.field_26752),
    STRONGHOLD(StructureToggle.OVERLAY_STRUCTURE_STRONGHOLD, "stronghold", class_2874.field_26752),
    VILLAGE(StructureToggle.OVERLAY_STRUCTURE_VILLAGE, "village", class_2874.field_26752),
    WITCH_HUT(StructureToggle.OVERLAY_STRUCTURE_WITCH_HUT, "swamp_hut", class_2874.field_26752),
    RUINED_PORTAL(StructureToggle.OVERLAY_STRUCTURE_RUINED_PORTAL, "ruined_portal", class_2874.field_26752, class_2874.field_26753),
    BASTION_REMNANT(StructureToggle.OVERLAY_STRUCTURE_BASTION_REMNANT, "bastion_remnant", class_2874.field_26753),
    NETHER_FOSSIL(StructureToggle.OVERLAY_STRUCTURE_NETHER_FOSSIL, "nether_fossil", class_2874.field_26753),
    NETHER_FORTRESS(StructureToggle.OVERLAY_STRUCTURE_NETHER_FORTRESS, "fortress", class_2874.field_26753),
    END_CITY(StructureToggle.OVERLAY_STRUCTURE_END_CITY, "endcity", class_2874.field_26754);

    public static final ImmutableList<StructureType> VALUES;
    private static final HashMap<String, StructureType> ID_TO_TYPE;
    private final StructureToggle toggle;
    private final String structureName;
    private final class_3195<?> feature;
    private final ImmutableSet<class_2960> dims;

    @Nullable
    public static StructureType byStructureId(String id) {
        return ID_TO_TYPE.get(id);
    }

    private StructureType(StructureToggle toggle, String structureName, class_2960 ... dims) {
        this.toggle = toggle;
        this.structureName = structureName;
        this.feature = (class_3195)class_3195.field_24842.get((Object)structureName.toLowerCase(Locale.ROOT));
        this.dims = ImmutableSet.copyOf((Object[])dims);
    }

    public boolean existsInDimension(class_2874 dimId) {
        return this.dims.contains((Object)dimId.method_31181());
    }

    public String getStructureName() {
        return this.structureName;
    }

    public class_3195<?> getFeature() {
        return this.feature;
    }

    public StructureToggle getToggle() {
        return this.toggle;
    }

    public boolean isEnabled() {
        return this.toggle.getToggleOption().getBooleanValue();
    }

    static {
        ID_TO_TYPE = new HashMap();
        VALUES = ImmutableList.copyOf((Object[])StructureType.values());
        for (StructureType type : VALUES) {
            class_2960 key;
            if (type.feature == null || (key = class_2378.field_16644.method_10221(type.feature)) == null) continue;
            ID_TO_TYPE.put(key.toString(), type);
        }
    }
}

