/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetIcon;
import fi.dy.masa.malilib.render.RenderUtils;
import net.minecraft.class_155;
import net.minecraft.class_4587;

public class WidgetSearchBar
extends WidgetBase {
    protected final WidgetIcon iconSearch;
    protected final LeftRight iconAlignment;
    protected final GuiTextFieldGeneric searchBox;
    protected boolean searchOpen;

    public WidgetSearchBar(int x, int y, int width, int height, int searchBarOffsetX, IGuiIcon iconSearch, LeftRight iconAlignment) {
        super(x, y, width, height);
        int iw = iconSearch.getWidth();
        int ix = iconAlignment == LeftRight.RIGHT ? x + width - iw - 1 : x + 2;
        int tx = iconAlignment == LeftRight.RIGHT ? x - searchBarOffsetX + 1 : x + iw + 6 + searchBarOffsetX;
        this.iconSearch = new WidgetIcon(ix, y + 1, iconSearch);
        this.iconAlignment = iconAlignment;
        this.searchBox = new GuiTextFieldGeneric(tx, y, width - iw - 7 - Math.abs(searchBarOffsetX), height, this.textRenderer);
        this.searchBox.setZLevel(this.zLevel);
    }

    public String getFilter() {
        return this.searchOpen ? this.searchBox.method_1882() : "";
    }

    public boolean hasFilter() {
        return this.searchOpen && !this.searchBox.method_1882().isEmpty();
    }

    public boolean isSearchOpen() {
        return this.searchOpen;
    }

    public void setSearchOpen(boolean isOpen) {
        this.searchOpen = isOpen;
        if (this.searchOpen) {
            this.searchBox.method_25365(true);
        }
    }

    @Override
    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (this.searchOpen && this.searchBox.method_25402(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.iconSearch.isMouseOver(mouseX, mouseY)) {
            this.setSearchOpen(!this.searchOpen);
            return true;
        }
        return false;
    }

    @Override
    protected boolean onKeyTypedImpl(int keyCode, int scanCode, int modifiers) {
        if (this.searchOpen) {
            if (this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 256) {
                if (GuiBase.isShiftDown()) {
                    this.mc.field_1755.method_25419();
                }
                this.searchOpen = false;
                this.searchBox.method_25365(false);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean onCharTypedImpl(char charIn, int modifiers) {
        if (this.searchOpen) {
            if (this.searchBox.method_25400(charIn, modifiers)) {
                return true;
            }
        } else if (class_155.method_643((char)charIn)) {
            this.searchOpen = true;
            this.searchBox.method_25365(true);
            this.searchBox.method_1852("");
            this.searchBox.method_25400(charIn, modifiers);
            return true;
        }
        return false;
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected, class_4587 matrixStack) {
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.iconSearch.render(false, this.iconSearch.isMouseOver(mouseX, mouseY));
        if (this.searchOpen) {
            this.searchBox.method_25394(matrixStack, mouseX, mouseY, 0.0f);
        }
    }
}

