/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.util.color.ColorARGB;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_6539;

public class BiomeColorCache {
    private static final int BLENDED_COLORS_DIM = 20;
    private final class_6539 resolver;
    private final WorldSlice slice;
    private final int[] blendedColors;
    private final int[] cache;
    private final int radius;
    private final int dim;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int blendedColorsMinX;
    private final int blendedColorsMinY;
    private final int blendedColorsMinZ;

    public BiomeColorCache(class_6539 resolver, WorldSlice slice) {
        this.resolver = resolver;
        this.slice = slice;
        this.radius = class_310.method_1551().field_1690.field_1878;
        class_4076 origin = this.slice.getOrigin();
        this.minX = origin.method_19527() - (this.radius + 2);
        this.minY = origin.method_19528() - (this.radius + 2);
        this.minZ = origin.method_19529() - (this.radius + 2);
        this.dim = 16 + (this.radius + 2) * 2;
        this.blendedColorsMinX = origin.method_19527() - 2;
        this.blendedColorsMinY = origin.method_19528() - 2;
        this.blendedColorsMinZ = origin.method_19529() - 2;
        this.cache = new int[this.dim * this.dim * this.dim];
        this.blendedColors = new int[8000];
        Arrays.fill(this.cache, -1);
        Arrays.fill(this.blendedColors, -1);
    }

    public int getBlendedColor(class_2338 pos) {
        int z2;
        int x2 = pos.method_10263() - this.blendedColorsMinX;
        int y2 = pos.method_10264() - this.blendedColorsMinY;
        int index = y2 * 20 * 20 + x2 * 20 + (z2 = pos.method_10260() - this.blendedColorsMinZ);
        int color = this.blendedColors[index];
        if (color == -1) {
            this.blendedColors[index] = color = this.calculateBlendedColor(pos.method_10263(), pos.method_10264(), pos.method_10260());
        }
        return color;
    }

    private int calculateBlendedColor(int posX, int posY, int posZ) {
        if (this.radius == 0) {
            return this.getColor(posX, posY, posZ);
        }
        int diameter = this.radius * 2 + 1;
        int area = diameter * diameter * diameter;
        int r = 0;
        int g = 0;
        int b = 0;
        int minX = posX - this.radius;
        int minY = posY - this.radius;
        int minZ = posZ - this.radius;
        int maxX = posX + this.radius;
        int maxY = posY + this.radius;
        int maxZ = posZ + this.radius;
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int y2 = minY; y2 <= maxY; ++y2) {
                for (int z2 = minZ; z2 <= maxZ; ++z2) {
                    int color = this.getColor(x2, y2, z2);
                    r += ColorARGB.unpackRed(color);
                    g += ColorARGB.unpackGreen(color);
                    b += ColorARGB.unpackBlue(color);
                }
            }
        }
        return ColorARGB.pack(r / area, g / area, b / area, 255);
    }

    private int getColor(int x, int y, int z) {
        int index = (y - this.minY) * this.dim * this.dim + (x - this.minX) * this.dim + (z - this.minZ);
        int color = this.cache[index];
        if (color == -1) {
            this.cache[index] = color = this.calculateColor(x, y, z);
        }
        return color;
    }

    private int calculateColor(int x, int y, int z) {
        return this.resolver.getColor(this.slice.getBiome(x, y, z), (double)x, (double)z);
    }
}

