/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.data.rule;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.class_1074;
import net.minecraft.class_339;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.data.GuiCategoryUIEditorSimpleDeletableWrapperData;
import xaero.common.category.ui.data.GuiCategoryUIEditorSimpleWrapperData;
import xaero.common.category.ui.data.options.text.GuiCategoryUIEditorTextFieldOptionsData;
import xaero.common.category.ui.entry.CategorySettingsListEntryWidget;
import xaero.common.category.ui.entry.CategorySettingsListEntryWrapper;
import xaero.common.category.ui.entry.CategorySettingsListMainEntryFactory;
import xaero.common.category.ui.entry.widget.CategorySettingsButton;
import xaero.common.graphics.CursorBox;
import xaero.common.misc.ListFactory;

abstract class GuiCategoryListUIEditorData
extends GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> {
    protected final List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>> list;
    private final GuiCategoryUIEditorTextFieldOptionsData topAdder;
    private final GuiCategoryUIEditorTextFieldOptionsData bottomAdder;
    private final ListFactory listFactory;
    private final GuiCategoryUIEditorSimpleDeletableWrapperData.DeletionCallback deletionCallback;

    protected GuiCategoryListUIEditorData(@Nonnull List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>> list, @Nonnull ListFactory listFactory, @Nonnull GuiCategoryUIEditorTextFieldOptionsData topAdder, @Nonnull GuiCategoryUIEditorTextFieldOptionsData bottomAdder, boolean movable, @Nonnull CategorySettingsListMainEntryFactory listEntryFactory, BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>> tooltipSupplier, @Nonnull GuiCategoryUIEditorSimpleDeletableWrapperData.DeletionCallback deletionCallback) {
        super(movable, listEntryFactory, tooltipSupplier);
        this.list = list;
        this.listFactory = listFactory;
        this.topAdder = topAdder;
        this.bottomAdder = bottomAdder;
        this.deletionCallback = deletionCallback;
    }

    public List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>> getList() {
        return this.list;
    }

    public GuiCategoryUIEditorSimpleDeletableWrapperData.DeletionCallback getDeletionCallback() {
        return this.deletionCallback;
    }

    private Consumer<GuiCategoryUIEditorTextFieldOptionsData> getAdderHandler() {
        return adder -> {
            String adderRequest = adder.getResult();
            if (!adderRequest.isEmpty()) {
                GuiCategoryUIEditorSimpleWrapperData element = ((GuiCategoryUIEditorSimpleDeletableWrapperData.Builder)GuiCategoryUIEditorSimpleDeletableWrapperData.Builder.getDefault().setElement(adderRequest)).setDeletionCallback(this.getDeletionCallback()).build();
                int sortedIndex = Collections.binarySearch(this.list, element);
                if (sortedIndex < 0) {
                    this.list.add(sortedIndex ^= 0xFFFFFFFF, (GuiCategoryUIEditorSimpleDeletableWrapperData<String>)element);
                }
                adder.resetInput("");
            }
        };
    }

    @Override
    public List<GuiCategoryUIEditorExpandableData<?>> getSubExpandables() {
        Consumer<GuiCategoryUIEditorTextFieldOptionsData> adderHandler = this.getAdderHandler();
        adderHandler.accept(this.topAdder);
        adderHandler.accept(this.bottomAdder);
        List<GuiCategoryUIEditorExpandableData<?>> result = this.listFactory.get();
        if (this.list.size() > 0) {
            result.add(this.topAdder);
        }
        result.addAll(this.list);
        result.add(this.bottomAdder);
        return result;
    }

    public static abstract class Builder<ED extends GuiCategoryListUIEditorData, B extends Builder<ED, B>>
    extends GuiCategoryUIEditorExpandableData.Builder<GuiCategoryUIEditorExpandableData<?>, B> {
        private final B self = this;
        protected final List<GuiCategoryUIEditorSimpleDeletableWrapperData.Builder<String>> list;
        protected final GuiCategoryUIEditorTextFieldOptionsData.Builder adderBuilder;
        protected ListFactory listFactory;
        protected GuiCategoryUIEditorSimpleDeletableWrapperData.DeletionCallback deletionCallback;

        protected Builder(ListFactory listFactory) {
            this.list = listFactory.get();
            this.listFactory = listFactory;
            this.adderBuilder = GuiCategoryUIEditorTextFieldOptionsData.Builder.getDefault(listFactory);
        }

        @Override
        public B setDefault() {
            super.setDefault();
            this.list.clear();
            this.setDeletionCallback(null);
            this.adderBuilder.setDefault().setAllowAnyInput(false).setAutoConfirm(false).setDisplayName(class_1074.method_4662((String)"gui.xaero_category_list_add", (Object[])new Object[0]));
            this.setDeletionCallback((parent, element, rowList) -> {
                GuiCategoryListUIEditorData listData = (GuiCategoryListUIEditorData)parent;
                if (listData.getList().remove(element)) {
                    rowList.restoreScrollAfterUpdate();
                    return true;
                }
                return false;
            });
            this.setListEntryFactory((data, parent, index, lineType, rowList, screenWidth, isFinalExpanded) -> new CategorySettingsListEntryWrapper((x, y, width, height, root) -> new CategorySettingsListEntryWidget(x, y, width, height, index, rowList, root, (class_339)new CategorySettingsButton(parent, () -> data.getDisplayName(), true, 216, 20, b -> data.getExpandAction(rowList).run(), rowList), data.getTooltipSupplier(parent)), screenWidth, index, rowList, lineType, data));
            return this.self;
        }

        public List<GuiCategoryUIEditorSimpleDeletableWrapperData.Builder<String>> getList() {
            return this.list;
        }

        public B setDeletionCallback(GuiCategoryUIEditorSimpleDeletableWrapperData.DeletionCallback deletionCallback) {
            this.deletionCallback = deletionCallback;
            return this.self;
        }

        public GuiCategoryUIEditorTextFieldOptionsData.Builder getAdderBuilder() {
            return this.adderBuilder;
        }

        protected List<GuiCategoryUIEditorSimpleDeletableWrapperData<String>> buildList() {
            return this.list.stream().map(builder -> {
                builder.setDeletionCallback(this.deletionCallback);
                return builder.build();
            }).sorted().collect(this.listFactory::get, List::add, List::addAll);
        }

        @Override
        public GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> build() {
            if (this.deletionCallback == null) {
                throw new IllegalStateException("required fields not set!");
            }
            return super.build();
        }

        protected abstract ED buildInternally();
    }
}

