/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer;

import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipError;
import net.fabricmc.installer.LoaderVersion;
import net.fabricmc.installer.server.MinecraftServerDownloader;
import net.fabricmc.installer.server.ServerInstaller;
import net.fabricmc.installer.util.InstallerProgress;
import net.fabricmc.installer.util.Utils;

public final class ServerLauncher {
    private static final String INSTALL_CONFIG_NAME = "install.properties";
    private static final Path DATA_DIR = Paths.get(".fabric", "server");

    public static void main(String[] args) throws Throwable {
        LaunchData launchData;
        try {
            launchData = ServerLauncher.initialise();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to setup fabric server", e);
        }
        Objects.requireNonNull(launchData, "launchData is null, cannot proceed");
        System.setProperty("fabric.gameJarPath", launchData.serverJar.toAbsolutePath().toString());
        URLClassLoader launchClassLoader = new URLClassLoader(new URL[]{launchData.launchJar.toUri().toURL()});
        MethodHandle handle = MethodHandles.publicLookup().findStatic(launchClassLoader.loadClass(launchData.mainClass), "main", MethodType.methodType(Void.TYPE, String[].class));
        handle.invokeExact(args);
    }

    private static LaunchData initialise() throws IOException {
        Properties properties = ServerLauncher.readProperties();
        String customLoaderPath = System.getProperty("fabric.customLoaderPath");
        LoaderVersion loaderVersion = customLoaderPath == null ? new LoaderVersion(Objects.requireNonNull(properties.getProperty("fabric-loader-version"), "no loader-version specified in install.properties")) : new LoaderVersion(Paths.get(customLoaderPath, new String[0]));
        String gameVersion = Objects.requireNonNull(properties.getProperty("game-version"), "no game-version specified in install.properties");
        ServerLauncher.validateLoaderVersion(loaderVersion);
        Path baseDir = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        Path dataDir = baseDir.resolve(DATA_DIR);
        Path serverJar = dataDir.resolve(String.format("%s-server.jar", gameVersion));
        Path serverLaunchJar = dataDir.resolve(String.format("fabric-loader-server-%s-minecraft-%s.jar", loaderVersion.name, gameVersion));
        if (Files.exists(serverJar, new LinkOption[0]) && Files.exists(serverLaunchJar, new LinkOption[0])) {
            try {
                String mainClass = ServerLauncher.readMainClass(serverLaunchJar);
                return new LaunchData(serverJar, serverLaunchJar, mainClass);
            }
            catch (IOException | ZipError e) {
                System.err.println("Failed to read main class from server launch jar: " + e.getMessage());
            }
        }
        Files.createDirectories(dataDir, new FileAttribute[0]);
        ServerInstaller.install(baseDir, loaderVersion, gameVersion, InstallerProgress.CONSOLE, serverLaunchJar);
        InstallerProgress.CONSOLE.updateProgress(Utils.BUNDLE.getString("progress.download.minecraft"));
        MinecraftServerDownloader downloader = new MinecraftServerDownloader(gameVersion);
        downloader.downloadMinecraftServer(serverJar);
        String mainClass = ServerLauncher.readMainClass(serverLaunchJar);
        return new LaunchData(serverJar, serverLaunchJar, mainClass);
    }

    private static Properties readProperties() throws IOException {
        Properties properties = new Properties();
        URL config = ServerLauncher.getConfigFromResources();
        if (config == null) {
            throw new RuntimeException("Jar does not contain unattended install.properties file");
        }
        try (InputStreamReader reader = new InputStreamReader(config.openStream(), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        catch (IOException e) {
            throw new IOException("Failed to read install.properties", e);
        }
        return properties;
    }

    private static String readMainClass(Path path) throws IOException {
        try (JarFile jarFile = new JarFile(path.toFile());){
            Manifest manifest = jarFile.getManifest();
            String mainClass = manifest.getMainAttributes().getValue("Main-Class");
            if (mainClass == null) {
                throw new IOException("Jar does not have a Main-Class attribute");
            }
            String string = mainClass;
            return string;
        }
    }

    private static void validateLoaderVersion(LoaderVersion loaderVersion) {
        if (Utils.compareVersions(loaderVersion.name, "0.12") < 0) {
            throw new UnsupportedOperationException("Fabric loader 0.12 or higher is required for unattended server installs. Please use a newer fabric loader version, or the full installer.");
        }
    }

    private static URL getConfigFromResources() {
        return ServerLauncher.class.getClassLoader().getResource(INSTALL_CONFIG_NAME);
    }

    private static class LaunchData {
        final Path serverJar;
        final Path launchJar;
        final String mainClass;

        private LaunchData(Path serverJar, Path launchJar, String mainClass) {
            this.serverJar = Objects.requireNonNull(serverJar, "serverJar");
            this.launchJar = Objects.requireNonNull(launchJar, "launchJar");
            this.mainClass = Objects.requireNonNull(mainClass, "mainClass");
        }
    }
}

