/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSplitter {
    public static final int MAX_TOTAL_PER_PACKET_S2C = 0x100000;
    public static final int MAX_PAYLOAD_PER_PACKET_S2C = 1048571;
    public static final int MAX_TOTAL_PER_PACKET_C2S = Short.MAX_VALUE;
    public static final int MAX_PAYLOAD_PER_PACKET_C2S = 32762;
    public static final int DEFAULT_MAX_RECEIVE_SIZE_C2S = 0x100000;
    public static final int DEFAULT_MAX_RECEIVE_SIZE_S2C = 0x4000000;
    private static final Map<Pair<class_2547, class_2960>, ReadingSession> READING_SESSIONS = new HashMap<Pair<class_2547, class_2960>, ReadingSession>();

    public static void send(class_3244 networkHandler, class_2960 channel, class_2540 packet) {
        PacketSplitter.send(packet, 1048571, (class_2540 buf) -> networkHandler.method_14364((class_2596)new class_2658(channel, buf)));
    }

    @Environment(value=EnvType.CLIENT)
    public static void send(class_634 networkHandler, class_2960 channel, class_2540 packet) {
        PacketSplitter.send(packet, 32762, (class_2540 buf) -> networkHandler.method_2883((class_2596)new class_2817(channel, buf)));
    }

    private static void send(class_2540 packet, int payloadLimit, Consumer<class_2540> sender) {
        int len = packet.writerIndex();
        packet.resetReaderIndex();
        for (int offset = 0; offset < len; offset += payloadLimit) {
            int thisLen = Math.min(len - offset, payloadLimit);
            class_2540 buf = new class_2540(Unpooled.buffer((int)thisLen));
            buf.resetWriterIndex();
            if (offset == 0) {
                buf.method_10804(len);
            }
            buf.writeBytes((ByteBuf)packet, thisLen);
            sender.accept(buf);
        }
        packet.release();
    }

    @Nullable
    public static class_2540 receive(class_2602 networkHandler, class_2658 message) {
        return PacketSplitter.receive(networkHandler, message, 0x4000000);
    }

    @Nullable
    private static class_2540 receive(class_2602 networkHandler, class_2658 message, int maxLength) {
        Pair key = Pair.of((Object)networkHandler, (Object)message.method_11456());
        return READING_SESSIONS.computeIfAbsent((Pair<class_2547, class_2960>)key, ReadingSession::new).receive(message.method_11458(), maxLength);
    }

    private static class ReadingSession {
        private final Pair<class_2547, class_2960> key;
        private int expectedSize = -1;
        private class_2540 received;

        private ReadingSession(Pair<class_2547, class_2960> key) {
            this.key = key;
        }

        @Nullable
        private class_2540 receive(class_2540 data, int maxLength) {
            if (this.expectedSize < 0) {
                this.expectedSize = data.method_10816();
                if (this.expectedSize > maxLength) {
                    throw new IllegalArgumentException("Payload too large");
                }
                this.received = new class_2540(Unpooled.buffer((int)this.expectedSize));
            }
            this.received.writeBytes(data.readBytes(data.readableBytes()));
            if (this.received.writerIndex() >= this.expectedSize) {
                READING_SESSIONS.remove(this.key);
                return this.received;
            }
            return null;
        }
    }
}

