/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigInteger;
import fi.dy.masa.malilib.config.IConfigOptionList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiColorEditorHSV;
import fi.dy.masa.malilib.gui.GuiRenderLayerEditBase;
import fi.dy.masa.malilib.gui.GuiTextFieldDouble;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.GuiTextFieldInteger;
import fi.dy.masa.malilib.gui.MaLiLibIcons;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.ConfigButtonOptionList;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.interfaces.ICoordinateValueModifier;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.gui.GuiConfigs;
import fi.dy.masa.minihud.gui.GuiShapeManager;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeBox;
import fi.dy.masa.minihud.renderer.shapes.ShapeCircle;
import fi.dy.masa.minihud.renderer.shapes.ShapeCircleBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeSpawnSphere;
import fi.dy.masa.minihud.util.ShapeRenderType;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class GuiShapeEditor
extends GuiRenderLayerEditBase {
    private final ShapeBase shape;
    private ConfigOptionList configBlockSnap;
    private int colorY;

    public GuiShapeEditor(ShapeBase shape) {
        this.shape = shape;
        this.title = StringUtils.translate((String)"minihud.gui.title.shape_editor", (Object[])new Object[0]);
        this.configBlockSnap = new ConfigOptionList("blockSnap", (IConfigOptionListEntry)BlockSnap.NONE, "");
    }

    public void initGui() {
        super.initGui();
        int x = 10;
        int y = 20;
        this.createShapeEditorElements(x, y);
        ButtonGeneric button = new ButtonGeneric(x, this.field_22790 - 24, -1, 20, GuiConfigs.ConfigGuiTab.SHAPES.getDisplayName(), new String[0]);
        this.addButton((ButtonBase)button, new GuiShapeManager.ButtonListenerTab(GuiConfigs.ConfigGuiTab.SHAPES));
        this.createLayerEditControls(146, 162, this.getLayerRange());
    }

    protected LayerRange getLayerRange() {
        return this.shape.getLayerRange();
    }

    private void createColorInput(int x, int y) {
        this.addLabel(x, y, -1, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.color", (Object[])new Object[0])});
        GuiTextFieldGeneric textField = new GuiTextFieldGeneric(x, y += 12, 70, 17, this.textRenderer);
        textField.method_1880(12);
        textField.method_1852(String.format("#%08X", this.shape.getColor().intValue));
        this.addTextField(textField, new TextFieldListenerColor(this.shape));
        this.nextY = y + 20;
        this.colorY = y - 1;
        this.addWidget(new WidgetColorIndicator(x + 74, this.colorY, 19, 19, this.shape.getColor(), this.shape::setColor));
    }

    private void createShapeEditorElements(int x, int y) {
        this.addLabel(x, y, -1, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.display_name_colon", (Object[])new Object[0])});
        GuiTextFieldGeneric textField = new GuiTextFieldGeneric(x, y += 12, 240, 17, this.textRenderer);
        textField.method_1852(this.shape.getDisplayName());
        this.addTextField(textField, txtFld -> {
            this.shape.setDisplayName(txtFld.method_1882());
            return true;
        });
        int renderTypeX = x + 230;
        int renderTypeY = (y += 20) + 2;
        switch (this.shape.getType()) {
            case ADJUSTABLE_SPAWN_SPHERE: {
                this.createShapeEditorElementsSphereBase(x, y, true);
                break;
            }
            case BOX: {
                this.createShapeEditorElementsBox(x, y);
                break;
            }
            case CAN_DESPAWN_SPHERE: 
            case CAN_SPAWN_SPHERE: 
            case DESPAWN_SPHERE: {
                ShapeSpawnSphere shape = (ShapeSpawnSphere)this.shape;
                this.createShapeEditorElementsSphereBase(x, y, false);
                this.createShapeEditorElementDoubleField(x + 150, y + 2, shape::getMargin, shape::setMargin, "minihud.gui.label.margin_colon", false);
                break;
            }
            case CIRCLE: {
                ShapeCircle shape = (ShapeCircle)this.shape;
                this.createShapeEditorElementsSphereBase(x, y, true);
                this.createShapeEditorElementIntField(x + 150, y + 36, shape::getHeight, shape::setHeight, "minihud.gui.label.height_colon", true);
                this.createDirectionButton(x + 230, y + 36, shape::getMainAxis, shape::setMainAxis, "minihud.gui.label.circle.main_axis_colon");
                this.createRenderTypeButton(renderTypeX, renderTypeY, this.shape::getRenderType, this.shape::setRenderType, "minihud.gui.label.render_type_colon");
                break;
            }
            case SPHERE_BLOCKY: {
                this.createShapeEditorElementsSphereBase(x, y, true);
                this.createRenderTypeButton(renderTypeX, renderTypeY, this.shape::getRenderType, this.shape::setRenderType, "minihud.gui.label.render_type_colon");
            }
        }
    }

    private void createShapeEditorElementsSphereBase(int x, int y, boolean addRadiusInput) {
        ShapeCircleBase shape = (ShapeCircleBase)this.shape;
        this.addLabel(x, y, 60, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.center_colon", (Object[])new Object[0])});
        if (addRadiusInput) {
            this.createShapeEditorElementDoubleField(x + 150, y + 2, shape::getRadius, shape::setRadius, "minihud.gui.label.radius_colon", true);
        }
        y += 12;
        GuiUtils.createVec3dInputsVertical((int)x, (int)y, (int)120, (class_243)shape.getCenter(), (ICoordinateValueModifier)new Vec3dEditor(shape::getCenter, shape::setCenter, this), (boolean)true, (GuiBase)this);
        ButtonGeneric button = new ButtonGeneric(x += 11, y += 54, -1, false, "malilib.gui.button.render_layers_gui.set_to_player", new Object[0]);
        this.addButton((ButtonBase)button, (btn, mbtn) -> this.setPositionFromCamera(shape::setCenter));
        this.configBlockSnap.setOptionListValue((IConfigOptionListEntry)shape.getBlockSnap());
        String label = StringUtils.translate((String)"minihud.gui.label.block_snap", (Object[])new Object[]{shape.getBlockSnap().getDisplayName()});
        int width = this.getStringWidth(label) + 10;
        ConfigButtonOptionList buttonSnap = new ConfigButtonOptionList(x + button.getWidth() + 4, y, width, 20, (IConfigOptionList)this.configBlockSnap, label);
        this.addButton((ButtonBase)buttonSnap, new ButtonListenerSphereBlockSnap(shape, this));
        this.createColorInput(x, y += 34);
    }

    private void createShapeEditorElementsBox(int x, int y) {
        ShapeBox shape = (ShapeBox)this.shape;
        this.addLabel(x, y, 60, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.shape_box.minimum_coord", (Object[])new Object[0])});
        GuiUtils.createVec3dInputsVertical((int)x, (int)(y += 12), (int)120, (class_243)this.boxMinToVec3d(shape.getBox()), (ICoordinateValueModifier)new Vec3dEditor(() -> this.boxMinToVec3d(shape.getBox()), v -> this.vecToBoxMin((class_243)v, shape::getBox, shape::setBox), this), (boolean)true, (GuiBase)this);
        this.addLabel(x, y += 54, 60, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.shape_box.maximum_coord", (Object[])new Object[0])});
        GuiUtils.createVec3dInputsVertical((int)x, (int)(y += 12), (int)120, (class_243)this.boxMaxToVec3d(shape.getBox()), (ICoordinateValueModifier)new Vec3dEditor(() -> this.boxMaxToVec3d(shape.getBox()), v -> this.vecToBoxMax((class_243)v, shape::getBox, shape::setBox), this), (boolean)true, (GuiBase)this);
        this.addLabel(x, y += 54, 60, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.grid_size", (Object[])new Object[0])});
        y += 12;
        GuiUtils.createVec3dInputsVertical((int)x, (int)y, (int)120, (class_243)shape.getGridSize(), (ICoordinateValueModifier)new Vec3dEditor(shape::getGridSize, shape::setGridSize, this), (boolean)true, (GuiBase)this);
        this.addLabel(x, y += 54, 60, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.grid_offset", (Object[])new Object[0])});
        y += 12;
        GuiUtils.createVec3dInputsVertical((int)x, (int)y, (int)120, (class_243)shape.getGridOffset(), (ICoordinateValueModifier)new Vec3dEditor(shape::getGridOffset, shape::setGridOffset, this), (boolean)true, (GuiBase)this);
        this.createColorInput(x, y += 54);
    }

    protected class_243 boxMinToVec3d(class_238 box) {
        return new class_243(box.field_1323, box.field_1322, box.field_1321);
    }

    protected class_243 boxMaxToVec3d(class_238 box) {
        return new class_243(box.field_1320, box.field_1325, box.field_1324);
    }

    protected void vecToBoxMin(class_243 vec, Supplier<class_238> boxIn, Consumer<class_238> boxOut) {
        class_238 box = boxIn.get();
        boxOut.accept(new class_238(vec.field_1352, vec.field_1351, vec.field_1350, box.field_1320, box.field_1325, box.field_1324));
    }

    protected void vecToBoxMax(class_243 vec, Supplier<class_238> boxIn, Consumer<class_238> boxOut) {
        class_238 box = boxIn.get();
        boxOut.accept(new class_238(box.field_1323, box.field_1322, box.field_1321, vec.field_1352, vec.field_1351, vec.field_1350));
    }

    private void createShapeEditorElementDoubleField(int x, int y, DoubleSupplier supplier, DoubleConsumer consumer, String translationKey, boolean addButton) {
        this.addLabel(x + 12, y, -1, 12, -1, new String[]{translationKey});
        GuiTextFieldDouble txtField = new GuiTextFieldDouble(x + 12, y += 11, 40, 14, this.textRenderer);
        txtField.method_1852(String.valueOf(supplier.getAsDouble()));
        this.addTextField((GuiTextFieldGeneric)txtField, new TextFieldListenerDouble(consumer));
        if (addButton) {
            String hover = StringUtils.translate((String)"malilib.gui.button.hover.plus_minus_tip", (Object[])new Object[0]);
            ButtonGeneric button = new ButtonGeneric(x + 54, y - 1, (IGuiIcon)MaLiLibIcons.BTN_PLUSMINUS_16, new String[]{hover});
            this.addButton((ButtonBase)button, new ButtonListenerDoubleModifier(supplier, new ChainedDoubleConsumer(consumer, val -> txtField.method_1852(String.valueOf(supplier.getAsDouble())))));
        }
    }

    private void createShapeEditorElementIntField(int x, int y, IntSupplier supplier, IntConsumer consumer, String translationKey, boolean addButton) {
        this.addLabel(x + 12, y, -1, 12, -1, new String[]{translationKey});
        GuiTextFieldInteger txtField = new GuiTextFieldInteger(x + 12, y += 11, 40, 14, this.textRenderer);
        txtField.method_1852(String.valueOf(supplier.getAsInt()));
        this.addTextField((GuiTextFieldGeneric)txtField, new TextFieldListenerInteger(consumer));
        if (addButton) {
            String hover = StringUtils.translate((String)"malilib.gui.button.hover.plus_minus_tip", (Object[])new Object[0]);
            ButtonGeneric button = new ButtonGeneric(x + 54, y - 1, (IGuiIcon)MaLiLibIcons.BTN_PLUSMINUS_16, new String[]{hover});
            this.addButton((ButtonBase)button, new ButtonListenerIntModifier(supplier, new ChainedIntConsumer(consumer, val -> txtField.method_1852(String.valueOf(supplier.getAsInt())))));
        }
    }

    private void createDirectionButton(int x, int y, Supplier<class_2350> supplier, Consumer<class_2350> consumer, String translationKey) {
        this.addLabel(x, y, -1, 12, -1, new String[]{translationKey});
        ButtonGeneric button = new ButtonGeneric(x, y += 10, 50, 20, org.apache.commons.lang3.StringUtils.capitalize((String)supplier.get().toString().toLowerCase()), new String[0]);
        this.addButton((ButtonBase)button, (btn, mouseBtn) -> {
            consumer.accept(GuiShapeEditor.cycleDirection((class_2350)supplier.get(), mouseBtn == 1));
            this.initGui();
        });
    }

    private void createRenderTypeButton(int x, int y, Supplier<ShapeRenderType> supplier, Consumer<ShapeRenderType> consumer, String translationKey) {
        this.addLabel(x, y, -1, 12, -1, new String[]{translationKey});
        ButtonGeneric button = new ButtonGeneric(x, y += 10, -1, 20, supplier.get().getDisplayName(), new String[0]);
        this.addButton((ButtonBase)button, (btn, mouseBtn) -> {
            consumer.accept((ShapeRenderType)((ShapeRenderType)((Object)((Object)supplier.get()))).cycle(mouseBtn == 0));
            this.initGui();
        });
    }

    public static class_2350 cycleDirection(class_2350 direction, boolean reverse) {
        int index = direction.method_10146();
        index = reverse ? (index == 0 ? 5 : index - 1) : (index >= 5 ? 0 : index + 1);
        return class_2350.method_10143((int)index);
    }

    protected void setPositionFromCamera(Consumer<class_243> consumer) {
        class_1297 entity = this.mc.method_1560();
        if (entity != null) {
            consumer.accept(entity.method_19538());
            this.initGui();
        }
    }

    private record TextFieldListenerColor(ShapeBase shape) implements ITextFieldListener<GuiTextFieldGeneric>
    {
        public boolean onTextChange(GuiTextFieldGeneric textField) {
            this.shape.setColorFromString(textField.method_1882());
            return false;
        }
    }

    public static class WidgetColorIndicator
    extends WidgetBase {
        protected final IConfigInteger config;

        public WidgetColorIndicator(int x, int y, int width, int height, Color4f color, IntConsumer consumer) {
            this(x, y, width, height, (IConfigInteger)new ConfigInteger("", color.intValue, ""));
            ((ConfigInteger)this.config).setValueChangeCallback(cfg -> consumer.accept(cfg.getIntegerValue()));
        }

        public WidgetColorIndicator(int x, int y, int width, int height, IConfigInteger config) {
            super(x, y, width, height);
            this.config = config;
        }

        protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
            GuiColorEditorHSV gui = new GuiColorEditorHSV(this.config, null, GuiUtils.getCurrentScreen());
            GuiBase.openGui((class_437)gui);
            return true;
        }

        public void postRenderHovered(int mouseX, int mouseY, boolean selected, class_4587 matrixStack) {
            RenderUtils.drawHoverText((int)mouseX, (int)mouseY, (List)ImmutableList.of((Object)"Open Color Editor"), (class_4587)matrixStack);
        }

        public void render(int mouseX, int mouseY, boolean selected, class_4587 matrixStack) {
            int x = this.getX();
            int y = this.getY();
            int z = this.zLevel;
            int width = this.getWidth();
            int height = this.getHeight();
            RenderUtils.drawRect((int)x, (int)(y + 0), (int)width, (int)height, (int)-1, (float)z);
            RenderUtils.drawRect((int)(x + 1), (int)(y + 1), (int)(width - 2), (int)(height - 2), (int)-16777216, (float)z);
            RenderUtils.drawRect((int)(x + 2), (int)(y + 2), (int)(width - 4), (int)(height - 4), (int)(0xFF000000 | this.config.getIntegerValue()), (float)z);
        }
    }

    public record Vec3dEditor(Supplier<class_243> supplier, Consumer<class_243> consumer, GuiShapeEditor gui) implements ICoordinateValueModifier
    {
        public boolean modifyValue(PositionUtils.CoordinateType type, int amount) {
            this.consumer.accept(PositionUtils.modifyValue((PositionUtils.CoordinateType)type, (class_243)this.supplier.get(), (double)amount));
            this.gui.initGui();
            return true;
        }

        public boolean setValueFromString(PositionUtils.CoordinateType type, String newValue) {
            try {
                this.consumer.accept(PositionUtils.setValue((PositionUtils.CoordinateType)type, (class_243)this.supplier.get(), (double)Double.parseDouble(newValue)));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private record ButtonListenerSphereBlockSnap(ShapeCircleBase shape, GuiShapeEditor gui) implements IButtonActionListener
    {
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            this.shape.setBlockSnap((BlockSnap)this.gui.configBlockSnap.getOptionListValue());
            this.gui.initGui();
        }
    }

    private record TextFieldListenerDouble(DoubleConsumer consumer) implements ITextFieldListener<GuiTextFieldDouble>
    {
        public boolean onTextChange(GuiTextFieldDouble textField) {
            try {
                this.consumer.accept(Double.parseDouble(textField.method_1882()));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static class ButtonListenerDoubleModifier
    implements IButtonActionListener {
        protected final DoubleSupplier supplier;
        protected final DoubleConsumer consumer;
        protected final int modifierShift;
        protected final int modifierControl;
        protected final int modifierAlt;

        public ButtonListenerDoubleModifier(DoubleSupplier supplier, DoubleConsumer consumer) {
            this(supplier, consumer, 8, 1, 4);
        }

        public ButtonListenerDoubleModifier(DoubleSupplier supplier, DoubleConsumer consumer, int modifierShift, int modifierControl, int modifierAlt) {
            this.supplier = supplier;
            this.consumer = consumer;
            this.modifierShift = modifierShift;
            this.modifierControl = modifierControl;
            this.modifierAlt = modifierAlt;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            int amount;
            int n = amount = mouseButton == 1 ? -1 : 1;
            if (GuiBase.isShiftDown()) {
                amount *= this.modifierShift;
            }
            if (GuiBase.isCtrlDown()) {
                amount *= this.modifierControl;
            }
            if (GuiBase.isAltDown()) {
                amount *= this.modifierAlt;
            }
            this.consumer.accept(this.supplier.getAsDouble() + (double)amount);
        }
    }

    private record ChainedDoubleConsumer(DoubleConsumer consumerOne, DoubleConsumer consumerTwo) implements DoubleConsumer
    {
        @Override
        public void accept(double value) {
            this.consumerOne.accept(value);
            this.consumerTwo.accept(value);
        }
    }

    private record TextFieldListenerInteger(IntConsumer consumer) implements ITextFieldListener<GuiTextFieldInteger>
    {
        public boolean onTextChange(GuiTextFieldInteger textField) {
            try {
                this.consumer.accept(Integer.parseInt(textField.method_1882()));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static class ButtonListenerIntModifier
    implements IButtonActionListener {
        protected final IntSupplier supplier;
        protected final IntConsumer consumer;
        protected final int modifierShift;
        protected final int modifierControl;
        protected final int modifierAlt;

        public ButtonListenerIntModifier(IntSupplier supplier, IntConsumer consumer) {
            this(supplier, consumer, 8, 1, 4);
        }

        public ButtonListenerIntModifier(IntSupplier supplier, IntConsumer consumer, int modifierShift, int modifierControl, int modifierAlt) {
            this.supplier = supplier;
            this.consumer = consumer;
            this.modifierShift = modifierShift;
            this.modifierControl = modifierControl;
            this.modifierAlt = modifierAlt;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            int amount;
            int n = amount = mouseButton == 1 ? -1 : 1;
            if (GuiBase.isShiftDown()) {
                amount *= this.modifierShift;
            }
            if (GuiBase.isCtrlDown()) {
                amount *= this.modifierControl;
            }
            if (GuiBase.isAltDown()) {
                amount *= this.modifierAlt;
            }
            this.consumer.accept(this.supplier.getAsInt() + amount);
        }
    }

    private record ChainedIntConsumer(IntConsumer consumerOne, IntConsumer consumerTwo) implements IntConsumer
    {
        @Override
        public void accept(int value) {
            this.consumerOne.accept(value);
            this.consumerTwo.accept(value);
        }
    }
}

