/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.StructureData;
import fi.dy.masa.minihud.util.StructureType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;

public class OverlayRendererStructures
extends OverlayRendererBase {
    public static final OverlayRendererStructures INSTANCE = new OverlayRendererStructures();

    private OverlayRendererStructures() {
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            return false;
        }
        for (StructureType type : StructureType.VALUES) {
            if (!type.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        int hysteresis = 16;
        return DataStorage.getInstance().structureRendererNeedsUpdate() || Math.abs(entity.method_23317() - (double)this.lastUpdatePos.method_10263()) > (double)hysteresis || Math.abs(entity.method_23318() - (double)this.lastUpdatePos.method_10264()) > (double)hysteresis || Math.abs(entity.method_23321() - (double)this.lastUpdatePos.method_10260()) > (double)hysteresis;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        int maxRange = (mc.field_1690.field_1870 + 4) * 16;
        List<WrappedData> data = this.getStructuresToRender(this.lastUpdatePos, maxRange);
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.method_1328(renderQuads.getGlMode(), class_290.field_1576);
        BUFFER_2.method_1328(renderLines.getGlMode(), class_290.field_1576);
        if (!data.isEmpty()) {
            this.renderStructureBoxes(data, cameraPos);
        }
        BUFFER_1.method_1326();
        BUFFER_2.method_1326();
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
    }

    private void renderStructureBoxes(List<WrappedData> wrappedData, class_243 cameraPos) {
        for (WrappedData wrapped : wrappedData) {
            this.renderStructure(wrapped.data, wrapped.mainColor, wrapped.componentColor, cameraPos);
        }
    }

    private void renderStructure(StructureData structure, Color4f mainColor, Color4f componentColor, class_243 cameraPos) {
        RenderUtils.drawBox((IntBoundingBox)structure.getBoundingBox(), (class_243)cameraPos, (Color4f)mainColor, (class_287)BUFFER_1, (class_287)BUFFER_2);
        ImmutableList<IntBoundingBox> components = structure.getComponents();
        if (!(components.isEmpty() || components.size() <= 1 && MiscUtils.areBoxesEqual((IntBoundingBox)components.get(0), structure.getBoundingBox()))) {
            for (IntBoundingBox bb : components) {
                RenderUtils.drawBox((IntBoundingBox)bb, (class_243)cameraPos, (Color4f)componentColor, (class_287)BUFFER_1, (class_287)BUFFER_2);
            }
        }
    }

    private List<WrappedData> getStructuresToRender(class_2338 playerPos, int maxRange) {
        ArrayListMultimap<StructureType, StructureData> structures = DataStorage.getInstance().getCopyOfStructureData();
        ArrayList<WrappedData> data = new ArrayList<WrappedData>();
        for (StructureType type : structures.keySet()) {
            if (!type.isEnabled()) continue;
            for (StructureData structure : structures.get((Object)type)) {
                if (!MiscUtils.isStructureWithinRange(structure.getBoundingBox(), playerPos, maxRange)) continue;
                Color4f mainColor = type.getToggle().getColorMain().getColor();
                Color4f componentColor = type.getToggle().getColorComponents().getColor();
                data.add(new WrappedData(structure, mainColor, componentColor));
            }
        }
        return data;
    }

    private record WrappedData(StructureData data, Color4f mainColor, Color4f componentColor) {
    }
}

