/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeCircleBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.util.ShapeRenderType;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.apache.commons.lang3.StringUtils;

public class ShapeCircle
extends ShapeCircleBase {
    protected int height = 1;

    public ShapeCircle() {
        super(ShapeType.CIRCLE, Configs.Colors.SHAPE_CIRCLE.getColor(), 16.0);
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        this.renderCircleShape(cameraPos);
        this.onPostUpdate(entity.method_19538());
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = class_3532.method_15340((int)height, (int)1, (int)260);
        this.setNeedsUpdate();
    }

    protected void renderCircleShape(class_243 cameraPos) {
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        BUFFER_1.method_1328(renderQuads.getGlMode(), class_290.field_1576);
        class_2338 posCenter = this.getCenterBlock();
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        HashSet<class_2338> circlePositions = new HashSet<class_2338>();
        class_2350.class_2351 axis = this.mainAxis.method_10166();
        for (int i = 0; i < this.height; ++i) {
            posMutable.method_10103(posCenter.method_10263() + this.mainAxis.method_10148() * i, posCenter.method_10264() + this.mainAxis.method_10164() * i, posCenter.method_10260() + this.mainAxis.method_10165() * i);
            if (axis == class_2350.class_2351.field_11052) {
                this.addPositionsOnHorizontalRing(circlePositions, posMutable, class_2350.field_11043);
                continue;
            }
            this.addPositionsOnVerticalRing(circlePositions, posMutable, class_2350.field_11036, this.mainAxis);
        }
        class_2350 mainAxis = this.mainAxis;
        class_2350[] sides = FACING_ALL;
        if (this.renderType != ShapeRenderType.FULL_BLOCK) {
            sides = new class_2350[4];
            int index = 0;
            for (int i = 0; i < 6; ++i) {
                class_2350 side = FACING_ALL[i];
                if (side.method_10166() == mainAxis.method_10166()) continue;
                sides[index++] = side;
            }
        }
        this.renderPositions(circlePositions, sides, mainAxis, this.color, cameraPos);
        BUFFER_1.method_1326();
        renderQuads.uploadData(BUFFER_1);
    }

    @Override
    protected boolean isPositionOnOrInsideRing(int blockX, int blockY, int blockZ, class_2350 outSide, class_2350 mainAxis) {
        double z;
        double y;
        class_2350.class_2351 axis = mainAxis.method_10166();
        double x = axis == class_2350.class_2351.field_11048 ? this.effectiveCenter.field_1352 : (double)blockX + 0.5;
        double dist = this.effectiveCenter.method_1028(x, y = axis == class_2350.class_2351.field_11052 ? this.effectiveCenter.field_1351 : (double)blockY + 0.5, z = axis == class_2350.class_2351.field_11051 ? this.effectiveCenter.field_1350 : (double)blockZ + 0.5);
        double diff = this.radiusSq - dist;
        if (diff > 0.0) {
            return true;
        }
        double xAdj = axis == class_2350.class_2351.field_11048 ? this.effectiveCenter.field_1352 : (double)blockX + (double)outSide.method_10148() + 0.5;
        double yAdj = axis == class_2350.class_2351.field_11052 ? this.effectiveCenter.field_1351 : (double)blockY + (double)outSide.method_10164() + 0.5;
        double zAdj = axis == class_2350.class_2351.field_11051 ? this.effectiveCenter.field_1350 : (double)blockZ + (double)outSide.method_10165() + 0.5;
        double distAdj = this.effectiveCenter.method_1028(xAdj, yAdj, zAdj);
        double diffAdj = this.radiusSq - distAdj;
        return diffAdj > 0.0 && Math.abs(diff) < Math.abs(diffAdj);
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        String aq = GuiBase.TXT_AQUA;
        String gl = GuiBase.TXT_GOLD;
        String gr = GuiBase.TXT_GRAY;
        String rst = GuiBase.TXT_GRAY;
        lines.add(2, gr + fi.dy.masa.malilib.util.StringUtils.translate((String)"minihud.gui.label.height_value", (Object[])new Object[]{gl + this.getHeight() + rst}));
        lines.add(3, gr + fi.dy.masa.malilib.util.StringUtils.translate((String)"minihud.gui.label.circle.main_axis_value", (Object[])new Object[]{aq + StringUtils.capitalize((String)this.getMainAxis().toString().toLowerCase()) + rst}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("height", (JsonElement)new JsonPrimitive((Number)this.height));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        this.setHeight(JsonUtils.getInteger((JsonObject)obj, (String)"height"));
    }
}

