/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.Quadrant;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.shapes.ShapeSphereBlocky;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_243;

public class ShapeSpawnSphere
extends ShapeSphereBlocky {
    protected class_243[] quadrantCenters;
    protected double margin = 1.5;

    public ShapeSpawnSphere() {
        this(ShapeType.ADJUSTABLE_SPAWN_SPHERE, Configs.Colors.SHAPE_DESPAWN_SPHERE.getColor(), 24.0);
        this.margin = 0.0;
    }

    public ShapeSpawnSphere(ShapeType shape, Color4f color, double radius) {
        super(shape, color, radius);
        this.updateQuadrantPoints();
    }

    @Override
    protected void updateEffectiveCenter() {
        super.updateEffectiveCenter();
        this.updateQuadrantPoints();
    }

    private void updateQuadrantPoints() {
        class_243 center = this.effectiveCenter;
        if (this.quadrantCenters == null) {
            this.quadrantCenters = new class_243[4];
        }
        this.quadrantCenters[Quadrant.NORTH_WEST.ordinal()] = new class_243(center.field_1352 - this.margin, center.field_1351, center.field_1350 - this.margin);
        this.quadrantCenters[Quadrant.NORTH_EAST.ordinal()] = new class_243(center.field_1352 + this.margin, center.field_1351, center.field_1350 - this.margin);
        this.quadrantCenters[Quadrant.SOUTH_WEST.ordinal()] = new class_243(center.field_1352 - this.margin, center.field_1351, center.field_1350 + this.margin);
        this.quadrantCenters[Quadrant.SOUTH_EAST.ordinal()] = new class_243(center.field_1352 + this.margin, center.field_1351, center.field_1350 + this.margin);
        this.setNeedsUpdate();
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
        this.updateQuadrantPoints();
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        String gl = GuiBase.TXT_GOLD;
        String gr = GuiBase.TXT_GRAY;
        String rst = GuiBase.TXT_GRAY;
        lines.add(2, gr + StringUtils.translate((String)"minihud.gui.label.margin_value", (Object[])new Object[]{String.format("%s%.2f%s", gl, this.margin, rst)}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("margin", (JsonElement)new JsonPrimitive((Number)this.margin));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        this.margin = JsonUtils.getDouble((JsonObject)obj, (String)"margin");
    }

    @Override
    protected boolean isPositionOnOrInsideRing(int x, int y, int z, class_2350 outSide, class_2350 mainAxis) {
        double dz;
        double dy;
        double dx;
        double maxDistSq = this.radiusSq;
        class_243 quadrantCenter = this.quadrantCenters[Quadrant.getQuadrant((int)x, (int)z, (class_243)this.effectiveCenter).ordinal()];
        return quadrantCenter.method_1028(dx = (double)x + 0.5, dy = (double)(y + 1), dz = (double)z + 0.5) < maxDistSq || this.effectiveCenter.method_1028(dx, dy, dz) < maxDistSq;
    }
}

