/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.program;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.IntSupplier;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.shader.GlShader;
import net.coderbot.iris.gl.shader.ProgramCreator;
import net.coderbot.iris.gl.shader.ShaderConstants;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.gl.shader.StandardMacros;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL21C;

public class ProgramBuilder
extends ProgramUniforms.Builder
implements SamplerHolder {
    private static final ShaderConstants EMPTY_CONSTANTS = ShaderConstants.builder().build();
    public static final ShaderConstants MACRO_CONSTANTS;
    private final int program;
    private final ProgramSamplers.Builder samplers;

    private ProgramBuilder(String name, int program, ImmutableSet<Integer> reservedTextureUnits) {
        super(name, program);
        this.program = program;
        this.samplers = ProgramSamplers.builder(program, reservedTextureUnits);
    }

    public void bindAttributeLocation(int index, String name) {
        GL21C.glBindAttribLocation((int)this.program, (int)index, (CharSequence)name);
    }

    public static ProgramBuilder begin(String name, @Nullable String vertexSource, @Nullable String geometrySource, @Nullable String fragmentSource, ImmutableSet<Integer> reservedTextureUnits) {
        RenderSystem.assertOnRenderThread();
        GlShader vertex = ProgramBuilder.buildShader(ShaderType.VERTEX, name + ".vsh", vertexSource);
        GlShader geometry = geometrySource != null ? ProgramBuilder.buildShader(ShaderType.GEOMETRY, name + ".gsh", geometrySource) : null;
        GlShader fragment = ProgramBuilder.buildShader(ShaderType.FRAGMENT, name + ".fsh", fragmentSource);
        int programId = geometry != null ? ProgramCreator.create(name, vertex, geometry, fragment) : ProgramCreator.create(name, vertex, fragment);
        vertex.destroy();
        if (geometry != null) {
            geometry.destroy();
        }
        fragment.destroy();
        return new ProgramBuilder(name, programId, reservedTextureUnits);
    }

    public Program build() {
        return new Program(this.program, super.buildUniforms(), this.samplers.build());
    }

    private static GlShader buildShader(ShaderType shaderType, String name, @Nullable String source) {
        try {
            return new GlShader(shaderType, name, source, EMPTY_CONSTANTS);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to compile " + (Object)((Object)shaderType) + " shader for program " + name, e);
        }
    }

    @Override
    public void addExternalSampler(int textureUnit, String ... names) {
        this.samplers.addExternalSampler(textureUnit, names);
    }

    @Override
    public boolean hasSampler(String name) {
        return this.samplers.hasSampler(name);
    }

    @Override
    public boolean addDefaultSampler(IntSupplier sampler, String ... names) {
        return this.samplers.addDefaultSampler(sampler, names);
    }

    @Override
    public boolean addDynamicSampler(IntSupplier sampler, String ... names) {
        return this.samplers.addDynamicSampler(sampler, names);
    }

    static {
        try {
            MACRO_CONSTANTS = ShaderConstants.builder().define(StandardMacros.getOsString()).define("MC_VERSION", StandardMacros.getMcVersion()).define("MC_GL_VERSION", StandardMacros.getGlVersion(7938)).define("MC_GLSL_VERSION", StandardMacros.getGlVersion(35724)).define(StandardMacros.getRenderer()).define(StandardMacros.getVendor()).define("MC_RENDER_QUALITY", "1.0").define("MC_SHADOW_QUALITY", "1.0").defineAll(StandardMacros.getIrisDefines()).defineAll(StandardMacros.getGlExtensions()).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize StandardMacros!", e);
        }
    }
}

