/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_155;
import net.minecraft.class_156;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30C;

public class StandardMacros {
    private static final Pattern SEMVER_PATTERN = Pattern.compile("(?<major>\\d+)\\.(?<minor>\\d+)\\.*(?<bugfix>\\d*)(.*)");

    public static String getMcVersion() {
        String version = class_155.method_16673().getReleaseTarget();
        if (version == null) {
            throw new IllegalStateException("Could not get the current minecraft version!");
        }
        String[] splitVersion = version.split("\\.");
        if (splitVersion.length < 2) {
            throw new IllegalStateException("Could not parse game version \"" + version + "\"");
        }
        String major = splitVersion[0];
        String minor = splitVersion[1];
        String bugfix = splitVersion.length < 3 ? "00" : splitVersion[2];
        if (minor.length() == 1) {
            minor = 0 + minor;
        }
        if (bugfix.length() == 1) {
            bugfix = 0 + bugfix;
        }
        return major + minor + bugfix;
    }

    public static String getOsString() {
        switch (class_156.method_668()) {
            case field_1137: {
                return "MC_OS_MAC";
            }
            case field_1135: {
                return "MC_OS_LINUX";
            }
            case field_1133: {
                return "MC_OS_WINDOWS";
            }
        }
        return "MC_OS_UNKNOWN";
    }

    public static String getGlVersion(int name) {
        String info = GL20.glGetString((int)name);
        Matcher matcher = SEMVER_PATTERN.matcher(Objects.requireNonNull(info));
        if (!matcher.matches()) {
            throw new IllegalStateException("Could not parse GL version from \"" + info + "\"");
        }
        String major = StandardMacros.group(matcher, "major");
        String minor = StandardMacros.group(matcher, "minor");
        String bugfix = StandardMacros.group(matcher, "bugfix");
        if (bugfix == null) {
            bugfix = "0";
        }
        if (major == null || minor == null) {
            throw new IllegalStateException("Could not parse GL version from \"" + info + "\"");
        }
        return major + minor + bugfix;
    }

    public static String group(Matcher matcher, String name) {
        try {
            return matcher.group(name);
        }
        catch (IllegalArgumentException | IllegalStateException exception) {
            return null;
        }
    }

    public static List<String> getGlExtensions() {
        int numExtensions = GL30C.glGetInteger((int)33309);
        String[] extensions = new String[numExtensions];
        for (int i = 0; i < numExtensions; ++i) {
            extensions[i] = GL30C.glGetStringi((int)7939, (int)i);
        }
        return Arrays.stream(extensions).map(s -> "MC_" + s).collect(Collectors.toList());
    }

    public static List<String> getIrisDefines() {
        ArrayList<String> defines = new ArrayList<String>();
        return defines;
    }

    public static String getRenderer() {
        String renderer = Objects.requireNonNull(GL11.glGetString((int)7937)).toLowerCase(Locale.ROOT);
        if (renderer.startsWith("amd")) {
            return "MC_GL_RENDERER_RADEON";
        }
        if (renderer.startsWith("ati")) {
            return "MC_GL_RENDERER_RADEON";
        }
        if (renderer.startsWith("radeon")) {
            return "MC_GL_RENDERER_RADEON";
        }
        if (renderer.startsWith("gallium")) {
            return "MC_GL_RENDERER_GALLIUM";
        }
        if (renderer.startsWith("intel")) {
            return "MC_GL_RENDERER_INTEL";
        }
        if (renderer.startsWith("geforce")) {
            return "MC_GL_RENDERER_GEFORCE";
        }
        if (renderer.startsWith("nvidia")) {
            return "MC_GL_RENDERER_GEFORCE";
        }
        if (renderer.startsWith("quadro")) {
            return "MC_GL_RENDERER_QUADRO";
        }
        if (renderer.startsWith("nvs")) {
            return "MC_GL_RENDERER_QUADRO";
        }
        if (renderer.startsWith("mesa")) {
            return "MC_GL_RENDERER_MESA";
        }
        return "MC_GL_RENDERER_OTHER";
    }

    public static String getVendor() {
        String vendor = Objects.requireNonNull(GL11.glGetString((int)7936)).toLowerCase(Locale.ROOT);
        if (vendor.startsWith("ati")) {
            return "MC_GL_VENDOR_ATI";
        }
        if (vendor.startsWith("intel")) {
            return "MC_GL_VENDOR_INTEL";
        }
        if (vendor.startsWith("nvidia")) {
            return "MC_GL_VENDOR_NVIDIA";
        }
        if (vendor.startsWith("amd")) {
            return "MC_GL_VENDOR_AMD";
        }
        if (vendor.startsWith("x.org")) {
            return "MC_GL_VENDOR_XORG";
        }
        return "MC_GL_VENDOR_OTHER";
    }
}

