/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.function.Supplier;
import net.coderbot.iris.gl.uniform.Uniform;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL21;

public class MatrixFromFloatArrayUniform
extends Uniform {
    private FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
    private float[] cachedValue = null;
    private final Supplier<float[]> value;

    MatrixFromFloatArrayUniform(int location, Supplier<float[]> value) {
        super(location);
        this.value = value;
    }

    @Override
    public void update() {
        float[] newValue = this.value.get();
        if (!Arrays.equals(newValue, this.cachedValue)) {
            this.cachedValue = Arrays.copyOf(newValue, 16);
            this.buffer.put(this.cachedValue);
            this.buffer.rewind();
            GL21.glUniformMatrix4fv((int)this.location, (boolean)false, (FloatBuffer)this.buffer);
        }
    }
}

