/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.function.IntFunction;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestFunction;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.newshader.TriforceSodiumPatcher;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.builtin.BuiltinReplacementUniforms;

public class SodiumTerrainPipeline {
    String terrainVertex;
    String terrainGeometry;
    String terrainFragment;
    String terrainCutoutFragment;
    GlFramebuffer terrainFramebuffer;
    BlendModeOverride terrainBlendOverride;
    String translucentVertex;
    String translucentGeometry;
    String translucentFragment;
    GlFramebuffer translucentFramebuffer;
    BlendModeOverride translucentBlendOverride;
    String shadowVertex;
    String shadowGeometry;
    String shadowFragment;
    String shadowCutoutFragment;
    GlFramebuffer shadowFramebuffer;
    BlendModeOverride shadowBlendOverride;
    ProgramSet programSet;
    private final IntFunction<ProgramSamplers> createTerrainSamplers;
    private final IntFunction<ProgramSamplers> createShadowSamplers;

    public SodiumTerrainPipeline(ProgramSet programSet, IntFunction<ProgramSamplers> createTerrainSamplers, IntFunction<ProgramSamplers> createShadowSamplers, RenderTargets targets, ImmutableSet<Integer> flippedBeforeTranslucent, ImmutableSet<Integer> flippedAfterTranslucent, GlFramebuffer shadowFramebuffer) {
        Optional<ProgramSource> terrainSource = SodiumTerrainPipeline.first(programSet.getGbuffersTerrain(), programSet.getGbuffersTexturedLit(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> translucentSource = SodiumTerrainPipeline.first(programSet.getGbuffersWater(), terrainSource);
        this.programSet = programSet;
        this.shadowFramebuffer = shadowFramebuffer;
        terrainSource.ifPresent(sources -> {
            this.terrainFramebuffer = targets.createGbufferFramebuffer(flippedBeforeTranslucent, sources.getDirectives().getDrawBuffers());
        });
        translucentSource.ifPresent(sources -> {
            this.translucentFramebuffer = targets.createGbufferFramebuffer(flippedAfterTranslucent, sources.getDirectives().getDrawBuffers());
        });
        this.createTerrainSamplers = createTerrainSamplers;
        this.createShadowSamplers = createShadowSamplers;
    }

    public void patchShaders(ChunkVertexType vertexType) {
        String fragment;
        ShaderAttributeInputs inputs = new ShaderAttributeInputs(true, true, false, true, true);
        AlphaTest cutoutAlpha = new AlphaTest(AlphaTestFunction.GREATER, 0.1f);
        Optional<ProgramSource> terrainSource = SodiumTerrainPipeline.first(this.programSet.getGbuffersTerrain(), this.programSet.getGbuffersTexturedLit(), this.programSet.getGbuffersTextured(), this.programSet.getGbuffersBasic());
        Optional<ProgramSource> translucentSource = SodiumTerrainPipeline.first(this.programSet.getGbuffersWater(), terrainSource);
        terrainSource.ifPresent(sources -> {
            this.terrainVertex = sources.getVertexSource().orElse(null);
            this.terrainGeometry = sources.getGeometrySource().orElse(null);
            this.terrainFragment = sources.getFragmentSource().orElse(null);
            this.terrainBlendOverride = sources.getDirectives().getBlendModeOverride();
        });
        translucentSource.ifPresent(sources -> {
            this.translucentVertex = sources.getVertexSource().orElse(null);
            this.translucentGeometry = sources.getGeometrySource().orElse(null);
            this.translucentFragment = sources.getFragmentSource().orElse(null);
            this.translucentBlendOverride = sources.getDirectives().getBlendModeOverride();
        });
        this.programSet.getShadow().ifPresent(sources -> {
            this.shadowVertex = sources.getVertexSource().orElse(null);
            this.shadowGeometry = sources.getGeometrySource().orElse(null);
            this.shadowFragment = sources.getFragmentSource().orElse(null);
            this.shadowBlendOverride = sources.getDirectives().getBlendModeOverride();
        });
        if (this.terrainVertex != null) {
            this.terrainVertex = TriforceSodiumPatcher.patch(this.terrainVertex, ShaderType.VERTEX, null, inputs, vertexType);
        }
        if (this.translucentVertex != null) {
            this.translucentVertex = TriforceSodiumPatcher.patch(this.translucentVertex, ShaderType.VERTEX, null, inputs, vertexType);
        }
        if (this.shadowVertex != null) {
            this.shadowVertex = TriforceSodiumPatcher.patch(this.shadowVertex, ShaderType.VERTEX, null, inputs, vertexType);
        }
        if (this.terrainGeometry != null) {
            this.terrainGeometry = TriforceSodiumPatcher.patch(this.terrainGeometry, ShaderType.GEOMETRY, null, inputs, vertexType);
        }
        if (this.translucentGeometry != null) {
            this.translucentGeometry = TriforceSodiumPatcher.patch(this.translucentGeometry, ShaderType.GEOMETRY, null, inputs, vertexType);
        }
        if (this.shadowGeometry != null) {
            this.shadowGeometry = TriforceSodiumPatcher.patch(this.shadowGeometry, ShaderType.GEOMETRY, null, inputs, vertexType);
        }
        if (this.terrainFragment != null) {
            fragment = this.terrainFragment;
            this.terrainFragment = TriforceSodiumPatcher.patch(fragment, ShaderType.FRAGMENT, AlphaTest.ALWAYS, inputs, vertexType);
            this.terrainCutoutFragment = TriforceSodiumPatcher.patch(fragment, ShaderType.FRAGMENT, cutoutAlpha, inputs, vertexType);
        }
        if (this.translucentFragment != null) {
            this.translucentFragment = TriforceSodiumPatcher.patch(this.translucentFragment, ShaderType.FRAGMENT, AlphaTest.ALWAYS, inputs, vertexType);
        }
        if (this.shadowFragment != null) {
            fragment = this.shadowFragment;
            this.shadowFragment = TriforceSodiumPatcher.patch(fragment, ShaderType.FRAGMENT, AlphaTest.ALWAYS, inputs, vertexType);
            this.shadowCutoutFragment = TriforceSodiumPatcher.patch(fragment, ShaderType.FRAGMENT, cutoutAlpha, inputs, vertexType);
        }
    }

    public Optional<String> getTerrainVertexShaderSource() {
        return Optional.ofNullable(this.terrainVertex);
    }

    public Optional<String> getTerrainGeometryShaderSource() {
        return Optional.ofNullable(this.terrainGeometry);
    }

    public Optional<String> getTerrainFragmentShaderSource() {
        return Optional.ofNullable(this.terrainFragment);
    }

    public Optional<String> getTerrainCutoutFragmentShaderSource() {
        return Optional.ofNullable(this.terrainCutoutFragment);
    }

    public GlFramebuffer getTerrainFramebuffer() {
        return this.terrainFramebuffer;
    }

    public BlendModeOverride getTerrainBlendOverride() {
        return this.terrainBlendOverride;
    }

    public Optional<String> getTranslucentVertexShaderSource() {
        return Optional.ofNullable(this.translucentVertex);
    }

    public Optional<String> getTranslucentGeometryShaderSource() {
        return Optional.ofNullable(this.translucentGeometry);
    }

    public Optional<String> getTranslucentFragmentShaderSource() {
        return Optional.ofNullable(this.translucentFragment);
    }

    public GlFramebuffer getTranslucentFramebuffer() {
        return this.translucentFramebuffer;
    }

    public BlendModeOverride getTranslucentBlendOverride() {
        return this.translucentBlendOverride;
    }

    public Optional<String> getShadowVertexShaderSource() {
        return Optional.ofNullable(this.shadowVertex);
    }

    public Optional<String> getShadowGeometryShaderSource() {
        return Optional.ofNullable(this.shadowGeometry);
    }

    public Optional<String> getShadowFragmentShaderSource() {
        return Optional.ofNullable(this.shadowFragment);
    }

    public Optional<String> getShadowCutoutFragmentShaderSource() {
        return Optional.ofNullable(this.shadowCutoutFragment);
    }

    public GlFramebuffer getShadowFramebuffer() {
        return this.shadowFramebuffer;
    }

    public BlendModeOverride getShadowBlendOverride() {
        return this.shadowBlendOverride;
    }

    public ProgramUniforms initUniforms(int programId) {
        ProgramUniforms.Builder uniforms = ProgramUniforms.builder("<sodium shaders>", programId);
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipeline();
        CommonUniforms.addCommonUniforms(uniforms, this.programSet.getPack().getIdMap(), this.programSet.getPackDirectives(), pipeline.getFrameUpdateNotifier(), FogMode.LINEAR);
        BuiltinReplacementUniforms.addBuiltinReplacementUniforms(uniforms);
        return uniforms.buildUniforms();
    }

    public ProgramSamplers initTerrainSamplers(int programId) {
        return this.createTerrainSamplers.apply(programId);
    }

    public ProgramSamplers initShadowSamplers(int programId) {
        return this.createShadowSamplers.apply(programId);
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... candidates) {
        for (Optional<T> candidate : candidates) {
            if (!candidate.isPresent()) continue;
            return candidate;
        }
        return Optional.empty();
    }
}

