/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestFunction;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.layer.GbufferProgram;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.pipeline.ClearPassCreator;
import net.coderbot.iris.pipeline.CustomTextureManager;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.CoreWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ExtendedShader;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.NewShaderTests;
import net.coderbot.iris.pipeline.newshader.WorldRenderingPhase;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.CompositeRenderer;
import net.coderbot.iris.postprocess.FinalPassRenderer;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.EmptyShadowMapRenderer;
import net.coderbot.iris.shadows.ShadowMapRenderer;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1044;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;

public class NewWorldRenderingPipeline
implements WorldRenderingPipeline,
CoreWorldRenderingPipeline {
    private boolean destroyed = false;
    private final RenderTargets renderTargets;
    private final class_5944 basic;
    private final class_5944 basicColor;
    private final class_5944 textured;
    private final class_5944 texturedColor;
    private final class_5944 skyBasic;
    private final class_5944 skyBasicColor;
    private final class_5944 skyTextured;
    private final class_5944 skyTexturedColor;
    private final class_5944 clouds;
    private final class_5944 shadowTerrainCutout;
    private final class_5944 terrainSolid;
    private final class_5944 terrainCutout;
    private final class_5944 terrainCutoutMipped;
    private final class_5944 entitiesSolid;
    private final class_5944 entitiesCutout;
    private final class_5944 entitiesEyes;
    private final class_5944 handCutout;
    private final class_5944 handTranslucent;
    private final class_5944 shadowEntitiesCutout;
    private final class_5944 shadowBeaconBeam;
    private final class_5944 lightning;
    private final class_5944 leash;
    private final class_5944 particles;
    private final class_5944 weather;
    private final class_5944 crumbling;
    private final class_5944 text;
    private final class_5944 textIntensity;
    private final class_5944 block;
    private final class_5944 beacon;
    private final class_5944 glint;
    private final class_5944 lines;
    private final class_5944 shadowLines;
    private final class_5944 terrainTranslucent;
    private WorldRenderingPhase phase = WorldRenderingPhase.NOT_RENDERING_WORLD;
    private final Set<class_5944> loadedShaders;
    private final ImmutableList<ClearPass> clearPassesFull;
    private final ImmutableList<ClearPass> clearPasses;
    private final GlFramebuffer baseline;
    private Runnable createShadowMapRenderer;
    private ShadowMapRenderer shadowMapRenderer;
    private final CompositeRenderer deferredRenderer;
    private final CompositeRenderer compositeRenderer;
    private final FinalPassRenderer finalPassRenderer;
    private final CustomTextureManager customTextureManager;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final SodiumTerrainPipeline sodiumTerrainPipeline;
    private final ImmutableSet<Integer> flippedBeforeTranslucent;
    private final ImmutableSet<Integer> flippedAfterTranslucent;
    boolean isBeforeTranslucent;
    private final int waterId;
    private final float sunPathRotation;
    private final boolean shouldRenderClouds;
    private final boolean oldLighting;
    private final OptionalInt forcedShadowRenderDistanceChunks;

    public NewWorldRenderingPipeline(ProgramSet programSet) throws IOException {
        Path debugOutDir = FabricLoader.getInstance().getGameDir().resolve("patched_shaders");
        if (Files.exists(debugOutDir, new LinkOption[0])) {
            Files.list(debugOutDir).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        Files.createDirectories(debugOutDir, new FileAttribute[0]);
        this.shouldRenderClouds = programSet.getPackDirectives().areCloudsEnabled();
        this.oldLighting = programSet.getPackDirectives().isOldLighting();
        this.updateNotifier = new FrameUpdateNotifier();
        this.renderTargets = new RenderTargets(class_310.method_1551().method_1522(), programSet.getPackDirectives().getRenderTargetDirectives());
        this.waterId = programSet.getPack().getIdMap().getBlockProperties().getOrDefault(new class_2960("minecraft", "water"), -1);
        this.sunPathRotation = programSet.getPackDirectives().getSunPathRotation();
        PackShadowDirectives shadowDirectives = programSet.getPackDirectives().getShadowDirectives();
        this.forcedShadowRenderDistanceChunks = shadowDirectives.isDistanceRenderMulExplicit() ? ((double)shadowDirectives.getDistanceRenderMul() >= 0.0 ? OptionalInt.of(((int)(shadowDirectives.getDistance() * shadowDirectives.getDistanceRenderMul()) + 15) / 16) : OptionalInt.of(-1)) : OptionalInt.empty();
        GlStateManager._activeTexture((int)33986);
        this.customTextureManager = new CustomTextureManager(programSet.getPackDirectives(), programSet.getPack().getCustomTextureDataMap(), programSet.getPack().getCustomNoiseTexture());
        GlStateManager._activeTexture((int)33984);
        ImmutableSet flippedBeforeTerrain = ImmutableSet.of();
        this.createShadowMapRenderer = () -> {
            this.shadowMapRenderer = new ShadowRenderer(this, programSet.getShadow().orElse(null), programSet.getPackDirectives(), () -> flippedBeforeTerrain, this.renderTargets, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular(), this.customTextureManager.getNoiseTexture(), programSet, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object)Object2ObjectMaps.emptyMap())));
            this.createShadowMapRenderer = () -> {};
        };
        BufferFlipper flipper = new BufferFlipper();
        this.centerDepthSampler = new CenterDepthSampler(this.renderTargets, this.updateNotifier);
        this.flippedBeforeTranslucent = flipper.snapshot();
        Supplier<ShadowMapRenderer> shadowMapRendererSupplier = () -> {
            this.createShadowMapRenderer.run();
            return this.shadowMapRenderer;
        };
        this.deferredRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getDeferred(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, shadowMapRendererSupplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.DEFERRED, (Object)Object2ObjectMaps.emptyMap())), programSet.getPackDirectives().getExplicitFlips("deferred_pre"));
        this.flippedAfterTranslucent = flipper.snapshot();
        this.compositeRenderer = new CompositeRenderer(programSet.getPackDirectives(), programSet.getComposite(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, flipper, shadowMapRendererSupplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object)Object2ObjectMaps.emptyMap())), programSet.getPackDirectives().getExplicitFlips("composite_pre"));
        this.finalPassRenderer = new FinalPassRenderer(programSet, this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, flipper.snapshot(), this.centerDepthSampler, shadowMapRendererSupplier, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object)Object2ObjectMaps.emptyMap())), this.compositeRenderer.getFlippedAtLeastOnceFinal());
        Supplier<ImmutableSet> flipped = () -> this.isBeforeTranslucent ? this.flippedBeforeTranslucent : this.flippedAfterTranslucent;
        IntFunction<ProgramSamplers> createTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object)Object2ObjectMaps.emptyMap())));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular());
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                this.createShadowMapRenderer.run();
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowMapRenderer);
            }
            return builder.build();
        };
        IntFunction<ProgramSamplers> createShadowTerrainSamplers = programId -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object)Object2ObjectMaps.emptyMap())));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> flippedBeforeTerrain, this.renderTargets, false);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, (class_1044)this.customTextureManager.getNormals(), (class_1044)this.customTextureManager.getSpecular());
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor) && this.shadowMapRenderer != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowMapRenderer);
            }
            return builder.build();
        };
        Optional<ProgramSource> basicSource = programSet.getGbuffersBasic();
        Optional<ProgramSource> texturedSource = NewWorldRenderingPipeline.first(programSet.getGbuffersTextured(), basicSource);
        Optional<ProgramSource> skyTexturedSource = NewWorldRenderingPipeline.first(programSet.getGbuffersSkyTextured(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> skyBasicSource = NewWorldRenderingPipeline.first(programSet.getGbuffersSkyBasic(), programSet.getGbuffersBasic());
        Optional<ProgramSource> cloudsSource = NewWorldRenderingPipeline.first(programSet.getGbuffersClouds(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> particleSource = NewWorldRenderingPipeline.first(programSet.getGbuffersTexturedLit(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> weatherSource = NewWorldRenderingPipeline.first(programSet.getGbuffersWeather(), particleSource);
        Optional<ProgramSource> terrainSource = NewWorldRenderingPipeline.first(programSet.getGbuffersTerrain(), programSet.getGbuffersTexturedLit(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> translucentSource = NewWorldRenderingPipeline.first(programSet.getGbuffersWater(), terrainSource);
        Optional<ProgramSource> shadowSource = programSet.getShadow();
        Optional<ProgramSource> blockSource = NewWorldRenderingPipeline.first(programSet.getGbuffersBlock(), terrainSource);
        Optional<ProgramSource> beaconSource = NewWorldRenderingPipeline.first(programSet.getGbuffersBeaconBeam(), programSet.getGbuffersTextured());
        Optional<ProgramSource> entitiesSource = NewWorldRenderingPipeline.first(programSet.getGbuffersEntities(), programSet.getGbuffersTexturedLit(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> entityEyesSource = NewWorldRenderingPipeline.first(programSet.getGbuffersEntityEyes(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> handSource = NewWorldRenderingPipeline.first(programSet.getGbuffersHand(), particleSource);
        Optional<ProgramSource> handTranslucentSource = NewWorldRenderingPipeline.first(programSet.getGbuffersHandWater(), handSource);
        Optional<ProgramSource> glintSource = NewWorldRenderingPipeline.first(programSet.getGbuffersGlint(), programSet.getGbuffersTextured());
        Optional<ProgramSource> damagedBlockSource = NewWorldRenderingPipeline.first(programSet.getGbuffersDamagedBlock(), terrainSource);
        this.baseline = this.renderTargets.createFramebufferWritingToMain(new int[]{0});
        AlphaTest terrainCutoutAlpha = new AlphaTest(AlphaTestFunction.GREATER, 0.1f);
        AlphaTest nonZeroAlpha = new AlphaTest(AlphaTestFunction.GREATER, 1.0E-4f);
        this.loadedShaders = new HashSet<class_5944>();
        try {
            this.basic = this.createShader("gbuffers_basic", basicSource, AlphaTest.ALWAYS, class_290.field_1592, FogMode.LINEAR);
            this.basicColor = this.createShader("gbuffers_basic_color", basicSource, nonZeroAlpha, class_290.field_1576, FogMode.OFF);
            this.textured = this.createShader("gbuffers_textured", texturedSource, nonZeroAlpha, class_290.field_1585, FogMode.OFF);
            this.texturedColor = this.createShader("gbuffers_textured_color", texturedSource, terrainCutoutAlpha, class_290.field_1575, FogMode.OFF);
            this.skyBasic = this.createShader("gbuffers_sky_basic", skyBasicSource, AlphaTest.ALWAYS, class_290.field_1592, FogMode.LINEAR);
            this.skyBasicColor = this.createShader("gbuffers_sky_basic_color", skyBasicSource, nonZeroAlpha, class_290.field_1576, FogMode.OFF);
            this.skyTextured = this.createShader("gbuffers_sky_textured", skyTexturedSource, AlphaTest.ALWAYS, class_290.field_1585, FogMode.OFF);
            this.skyTexturedColor = this.createShader("gbuffers_sky_textured_tex_color", skyTexturedSource, AlphaTest.ALWAYS, class_290.field_1575, FogMode.OFF);
            this.clouds = this.createShader("gbuffers_clouds", cloudsSource, terrainCutoutAlpha, class_290.field_1577, FogMode.LINEAR);
            this.terrainSolid = this.createShader("gbuffers_terrain_solid", terrainSource, AlphaTest.ALWAYS, IrisVertexFormats.TERRAIN, FogMode.LINEAR);
            this.terrainCutout = this.createShader("gbuffers_terrain_cutout", terrainSource, terrainCutoutAlpha, IrisVertexFormats.TERRAIN, FogMode.LINEAR);
            this.terrainCutoutMipped = this.createShader("gbuffers_terrain_cutout_mipped", terrainSource, terrainCutoutAlpha, IrisVertexFormats.TERRAIN, FogMode.LINEAR);
            this.entitiesSolid = this.createShader("gbuffers_entities_solid", entitiesSource, AlphaTest.ALWAYS, class_290.field_1580, FogMode.LINEAR);
            this.entitiesCutout = this.createShader("gbuffers_entities_cutout", entitiesSource, terrainCutoutAlpha, class_290.field_1580, FogMode.LINEAR);
            this.entitiesEyes = this.createShader("gbuffers_spidereyes", entityEyesSource, nonZeroAlpha, class_290.field_1580, FogMode.LINEAR);
            this.handCutout = this.createShader("gbuffers_hand_cutout", handSource, terrainCutoutAlpha, class_290.field_1580, FogMode.LINEAR);
            this.handTranslucent = this.createShader("gbuffers_hand_translucent", handTranslucentSource, terrainCutoutAlpha, class_290.field_1580, FogMode.LINEAR);
            this.lightning = this.createShader("gbuffers_lightning", entitiesSource, AlphaTest.ALWAYS, class_290.field_1576, FogMode.LINEAR);
            this.leash = this.createShader("gbuffers_leash", basicSource, AlphaTest.ALWAYS, class_290.field_21468, FogMode.LINEAR);
            this.particles = this.createShader("gbuffers_particles", particleSource, terrainCutoutAlpha, class_290.field_1584, FogMode.LINEAR);
            this.weather = this.createShader("gbuffers_weather", weatherSource, terrainCutoutAlpha, class_290.field_1584, FogMode.LINEAR);
            this.crumbling = this.createShader("gbuffers_damagedblock", damagedBlockSource, terrainCutoutAlpha, class_290.field_1590, FogMode.OFF);
            this.text = this.createShader("gbuffers_entities_text", entitiesSource, nonZeroAlpha, class_290.field_20888, FogMode.LINEAR);
            this.textIntensity = this.createShader("gbuffers_entities_text_intensity", entitiesSource, nonZeroAlpha, class_290.field_20888, FogMode.LINEAR);
            this.block = this.createShader("gbuffers_block", blockSource, terrainCutoutAlpha, class_290.field_1580, FogMode.LINEAR);
            this.beacon = this.createShader("gbuffers_beaconbeam", beaconSource, AlphaTest.ALWAYS, class_290.field_1590, FogMode.LINEAR);
            this.glint = this.createShader("gbuffers_glint", glintSource, nonZeroAlpha, class_290.field_1585, FogMode.LINEAR);
            this.lines = this.createShader("gbuffers_lines", programSet.getGbuffersBasic(), AlphaTest.ALWAYS, class_290.field_29337, FogMode.LINEAR);
            this.terrainTranslucent = translucentSource != terrainSource ? this.createShader("gbuffers_translucent", translucentSource, AlphaTest.ALWAYS, IrisVertexFormats.TERRAIN, FogMode.LINEAR) : this.terrainSolid;
        }
        catch (RuntimeException e) {
            this.destroyShaders();
            throw e;
        }
        BlockRenderingSettings.INSTANCE.setIdMap(programSet.getPack().getIdMap());
        BlockRenderingSettings.INSTANCE.setAmbientOcclusionLevel(programSet.getPackDirectives().getAmbientOcclusionLevel());
        BlockRenderingSettings.INSTANCE.setDisableDirectionalShading(this.shouldDisableDirectionalShading());
        BlockRenderingSettings.INSTANCE.setUseSeparateAo(programSet.getPackDirectives().shouldUseSeparateAo());
        this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, programSet.getPackDirectives().getRenderTargetDirectives());
        this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, programSet.getPackDirectives().getRenderTargetDirectives());
        if (this.shadowMapRenderer == null) {
            this.shadowMapRenderer = new EmptyShadowMapRenderer(programSet.getPackDirectives().getShadowDirectives().getResolution());
            this.shadowTerrainCutout = null;
            this.shadowEntitiesCutout = null;
            this.shadowBeaconBeam = null;
            this.shadowLines = null;
        } else {
            try {
                this.shadowTerrainCutout = this.createShadowShader("shadow_terrain_cutout", shadowSource, terrainCutoutAlpha, IrisVertexFormats.TERRAIN);
                this.shadowEntitiesCutout = this.createShadowShader("shadow_entities_cutout", shadowSource, terrainCutoutAlpha, class_290.field_1580);
                this.shadowBeaconBeam = this.createShadowShader("shadow_beacon_beam", shadowSource, AlphaTest.ALWAYS, class_290.field_1590);
                this.shadowLines = this.createShadowShader("shadow_lines", shadowSource, AlphaTest.ALWAYS, class_290.field_29337);
            }
            catch (RuntimeException e) {
                this.destroyShaders();
                throw e;
            }
        }
        this.sodiumTerrainPipeline = new SodiumTerrainPipeline(programSet, createTerrainSamplers, createShadowTerrainSamplers, this.renderTargets, this.flippedBeforeTranslucent, this.flippedAfterTranslucent, this.shadowMapRenderer instanceof ShadowRenderer ? ((ShadowRenderer)this.shadowMapRenderer).getFramebuffer() : null);
    }

    @Nullable
    private class_5944 createShader(String name, Optional<ProgramSource> source, AlphaTest fallbackAlpha, class_293 vertexFormat, FogMode fogMode) throws IOException {
        if (!source.isPresent()) {
            return null;
        }
        return this.createShader(name, source.get(), fallbackAlpha, vertexFormat, fogMode);
    }

    private class_5944 createShader(String name, ProgramSource source, AlphaTest fallbackAlpha, class_293 vertexFormat, FogMode fogMode) throws IOException {
        GlFramebuffer beforeTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedBeforeTranslucent, source.getDirectives().getDrawBuffers());
        GlFramebuffer afterTranslucent = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, source.getDirectives().getDrawBuffers());
        ExtendedShader extendedShader = NewShaderTests.create(name, source, beforeTranslucent, afterTranslucent, this.baseline, fallbackAlpha, vertexFormat, this.updateNotifier, this, fogMode);
        this.loadedShaders.add(extendedShader);
        Supplier<ImmutableSet<Integer>> flipped = () -> this.isBeforeTranslucent ? this.flippedBeforeTranslucent : this.flippedAfterTranslucent;
        TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(extendedShader, (Object2ObjectMap<String, IntSupplier>)((Object2ObjectMap)this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)textureStage, (Object)Object2ObjectMaps.emptyMap())));
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, flipped, this.renderTargets, false);
        customTextureSamplerInterceptor.addDynamicSampler(() -> ((NativeImageBackedSingleColorTexture)this.customTextureManager.getNormals()).method_4624(), "normals");
        customTextureSamplerInterceptor.addDynamicSampler(() -> ((NativeImageBackedSingleColorTexture)this.customTextureManager.getSpecular()).method_4624(), "specular");
        IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            this.createShadowMapRenderer.run();
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowMapRenderer);
        }
        return extendedShader;
    }

    private class_5944 createShadowShader(String name, Optional<ProgramSource> source, AlphaTest fallbackAlpha, class_293 vertexFormat) throws IOException {
        if (!source.isPresent()) {
            return null;
        }
        return this.createShadowShader(name, source.get(), fallbackAlpha, vertexFormat);
    }

    private class_5944 createShadowShader(String name, ProgramSource source, AlphaTest fallbackAlpha, class_293 vertexFormat) throws IOException {
        int i;
        GlFramebuffer framebuffer = ((ShadowRenderer)this.shadowMapRenderer).getFramebuffer();
        ExtendedShader extendedShader = NewShaderTests.create(name, source, framebuffer, framebuffer, this.baseline, fallbackAlpha, vertexFormat, this.updateNotifier, this, FogMode.LINEAR);
        this.loadedShaders.add(extendedShader);
        extendedShader.addIrisSampler("normals", this.customTextureManager.getNormals().method_4624());
        extendedShader.addIrisSampler("specular", this.customTextureManager.getSpecular().method_4624());
        extendedShader.addIrisSampler("shadow", this.shadowMapRenderer.getDepthTextureId());
        extendedShader.addIrisSampler("watershadow", this.shadowMapRenderer.getDepthTextureId());
        extendedShader.addIrisSampler("shadowtex0", this.shadowMapRenderer.getDepthTextureId());
        extendedShader.addIrisSampler("shadowtex1", this.shadowMapRenderer.getDepthTextureNoTranslucentsId());
        extendedShader.addIrisSampler("depthtex0", this.renderTargets.getDepthTexture().getTextureId());
        extendedShader.addIrisSampler("depthtex1", this.renderTargets.getDepthTextureNoTranslucents().getTextureId());
        extendedShader.addIrisSampler("noisetex", this.customTextureManager.getNoiseTexture().getAsInt());
        extendedShader.addIrisSampler("shadowcolor", this.shadowMapRenderer.getColorTexture0Id());
        extendedShader.addIrisSampler("shadowcolor0", this.shadowMapRenderer.getColorTexture0Id());
        extendedShader.addIrisSampler("shadowcolor1", this.shadowMapRenderer.getColorTexture1Id());
        for (i = 0; i < 8; ++i) {
            extendedShader.addIrisSampler("colortex" + i, this.renderTargets.get(i).getMainTexture());
        }
        for (i = 1; i <= 4; ++i) {
            extendedShader.addIrisSampler("gaux" + i, this.renderTargets.get(i + 3).getMainTexture());
        }
        return extendedShader;
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... candidates) {
        for (Optional<T> candidate : candidates) {
            if (!candidate.isPresent()) continue;
            return candidate;
        }
        return Optional.empty();
    }

    @Override
    public void setPhase(WorldRenderingPhase phase) {
        this.phase = phase;
    }

    @Override
    public WorldRenderingPhase getPhase() {
        return this.phase;
    }

    @Override
    public void beginLevelRendering() {
        ImmutableList<ClearPass> passes;
        RenderSystem.activeTexture((int)33984);
        this.updateNotifier.onNewFrame();
        class_276 main = class_310.method_1551().method_1522();
        this.renderTargets.resizeIfNeeded(main.field_1482, main.field_1481);
        if (this.renderTargets.isFullClearRequired()) {
            this.renderTargets.onFullClear();
            passes = this.clearPassesFull;
        } else {
            passes = this.clearPasses;
        }
        class_243 fogColor3 = CapturedRenderingState.INSTANCE.getFogColor();
        Vector4f fogColor = new Vector4f((float)fogColor3.field_1352, (float)fogColor3.field_1351, (float)fogColor3.field_1350, 1.0f);
        for (ClearPass clearPass : passes) {
            clearPass.execute(fogColor);
        }
        main.method_1235(true);
        this.isBeforeTranslucent = true;
    }

    @Override
    public void renderShadows(LevelRendererAccessor worldRenderer, class_4184 playerCamera) {
        this.shadowMapRenderer.renderShadows(worldRenderer, playerCamera);
    }

    @Override
    public void addDebugText(List<String> messages) {
        ShadowMapRenderer shadowMapRenderer = this.shadowMapRenderer;
        if (shadowMapRenderer instanceof ShadowRenderer) {
            messages.add("");
            shadowMapRenderer.addDebugText(messages);
        } else if (shadowMapRenderer instanceof EmptyShadowMapRenderer) {
            messages.add("");
            messages.add("[Iris] Shadow Maps: not used by shader pack");
        } else {
            throw new IllegalStateException("Unknown shadow map renderer type!");
        }
    }

    @Override
    public OptionalInt getForcedShadowRenderDistanceChunksForDisplay() {
        return this.forcedShadowRenderDistanceChunks;
    }

    @Override
    public void beginShadowRender() {
    }

    @Override
    public void endShadowRender() {
    }

    @Override
    public void beginHand() {
        this.baseline.bindAsReadBuffer();
        GlStateManager._bindTexture((int)this.renderTargets.getDepthTextureNoHand().getTextureId());
        GL20C.glCopyTexImage2D((int)3553, (int)0, (int)6402, (int)0, (int)0, (int)this.renderTargets.getCurrentWidth(), (int)this.renderTargets.getCurrentHeight(), (int)0);
        GlStateManager._bindTexture((int)0);
    }

    @Override
    public void beginTranslucents() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use a destroyed world rendering pipeline");
        }
        this.isBeforeTranslucent = false;
        this.baseline.bindAsReadBuffer();
        GlStateManager._bindTexture((int)this.renderTargets.getDepthTextureNoTranslucents().getTextureId());
        GL20C.glCopyTexImage2D((int)3553, (int)0, (int)6402, (int)0, (int)0, (int)this.renderTargets.getCurrentWidth(), (int)this.renderTargets.getCurrentHeight(), (int)0);
        GlStateManager._bindTexture((int)0);
        this.deferredRenderer.renderAll();
        RenderSystem.enableBlend();
        class_310.method_1551().field_1773.method_22974().method_3316();
        class_310.method_1551().field_1773.method_22975().method_23209();
        RenderSystem.setShader(class_757::method_34539);
    }

    @Override
    public void pushProgram(GbufferProgram program) {
    }

    @Override
    public void popProgram(GbufferProgram program) {
    }

    @Override
    public void finalizeLevelRendering() {
        this.compositeRenderer.renderAll();
        this.finalPassRenderer.renderFinalPass();
    }

    @Override
    public boolean shouldDisableVanillaEntityShadows() {
        return true;
    }

    @Override
    public boolean shouldRenderClouds() {
        return this.shouldRenderClouds;
    }

    @Override
    public boolean shouldDisableDirectionalShading() {
        return !this.oldLighting;
    }

    @Override
    public class_5944 getBasic() {
        return this.basic;
    }

    @Override
    public class_5944 getBasicColor() {
        return this.basicColor;
    }

    @Override
    public class_5944 getTextured() {
        return this.textured;
    }

    @Override
    public class_5944 getTexturedColor() {
        return this.texturedColor;
    }

    @Override
    public class_5944 getSkyBasic() {
        return this.skyBasic;
    }

    @Override
    public class_5944 getSkyBasicColor() {
        return this.skyBasicColor;
    }

    @Override
    public class_5944 getSkyTextured() {
        return this.skyTextured;
    }

    @Override
    public class_5944 getSkyTexturedColor() {
        return this.skyTexturedColor;
    }

    @Override
    public class_5944 getClouds() {
        return this.clouds;
    }

    @Override
    public class_5944 getTerrain() {
        return this.terrainSolid;
    }

    @Override
    public class_5944 getTerrainCutout() {
        return this.terrainCutout;
    }

    @Override
    public class_5944 getTerrainCutoutMipped() {
        return this.terrainCutoutMipped;
    }

    @Override
    public class_5944 getEntitiesCutout() {
        return this.entitiesCutout;
    }

    @Override
    public class_5944 getEntitiesEyes() {
        return this.entitiesEyes;
    }

    @Override
    public class_5944 getHandCutout() {
        return this.handCutout;
    }

    @Override
    public class_5944 getHandTranslucent() {
        return this.handTranslucent;
    }

    @Override
    public class_5944 getLeash() {
        return this.leash;
    }

    @Override
    public class_5944 getLightning() {
        return this.lightning;
    }

    @Override
    public class_5944 getParticles() {
        return this.particles;
    }

    @Override
    public class_5944 getWeather() {
        return this.weather;
    }

    @Override
    public class_5944 getCrumbling() {
        return this.crumbling;
    }

    @Override
    public class_5944 getText() {
        return this.text;
    }

    @Override
    public class_5944 getTextIntensity() {
        return this.textIntensity;
    }

    @Override
    public class_5944 getBlock() {
        return this.block;
    }

    @Override
    public class_5944 getBeacon() {
        return this.beacon;
    }

    @Override
    public class_5944 getEntitiesSolid() {
        return this.entitiesSolid;
    }

    @Override
    public class_5944 getShadowTerrainCutout() {
        return this.shadowTerrainCutout;
    }

    @Override
    public class_5944 getShadowEntitiesCutout() {
        return this.shadowEntitiesCutout;
    }

    @Override
    public class_5944 getShadowBeaconBeam() {
        return this.shadowEntitiesCutout;
    }

    @Override
    public class_5944 getTranslucent() {
        return this.terrainTranslucent;
    }

    @Override
    public class_5944 getGlint() {
        return this.glint;
    }

    @Override
    public class_5944 getLines() {
        return this.lines;
    }

    @Override
    public class_5944 getShadowLines() {
        return this.shadowLines;
    }

    private void destroyShaders() {
        this.loadedShaders.forEach(shader -> {
            shader.method_34585();
            shader.close();
        });
    }

    @Override
    public void destroy() {
        int i;
        this.destroyed = true;
        this.destroyShaders();
        for (i = 0; i < 16; ++i) {
            GlStateManager.glActiveTexture((int)(33984 + i));
            GlStateManager._bindTexture((int)0);
        }
        GlStateManager.glActiveTexture((int)33984);
        for (i = 0; i < 12; ++i) {
            RenderSystem.setShaderTexture((int)i, (int)0);
        }
        this.compositeRenderer.destroy();
        this.customTextureManager.destroy();
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
        GlStateManager._glBindFramebuffer((int)36009, (int)0);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
        class_310.method_1551().method_1522().method_1235(false);
        this.shadowMapRenderer.destroy();
        this.renderTargets.destroy();
    }

    @Override
    public SodiumTerrainPipeline getSodiumTerrainPipeline() {
        return this.sodiumTerrainPipeline;
    }

    @Override
    public FrameUpdateNotifier getFrameUpdateNotifier() {
        return this.updateNotifier;
    }

    @Override
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }
}

