/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.shaderpack.CommentDirectiveParser;
import net.coderbot.iris.shaderpack.ConstDirectiveParser;
import net.coderbot.iris.shaderpack.DispatchingDirectiveHolder;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.ShaderProperties;
import org.jetbrains.annotations.Nullable;

public class ProgramDirectives {
    private static final ImmutableList<String> LEGACY_RENDER_TARGETS = PackRenderTargetDirectives.LEGACY_RENDER_TARGETS;
    private final int[] drawBuffers;
    private final float viewportScale;
    @Nullable
    private final AlphaTest alphaTestOverride;
    @Nullable
    private final BlendModeOverride blendModeOverride;
    private final ImmutableSet<Integer> mipmappedBuffers;
    private final ImmutableMap<Integer, Boolean> explicitFlips;

    ProgramDirectives(ProgramSource source, ShaderProperties properties, Set<Integer> supportedRenderTargets) {
        this.drawBuffers = ProgramDirectives.findDrawbuffersDirective(source.getFragmentSource()).orElse(new int[]{0});
        if (properties != null) {
            this.viewportScale = properties.getViewportScaleOverrides().getOrDefault((Object)source.getName(), 1.0f);
            this.alphaTestOverride = (AlphaTest)properties.getAlphaTestOverrides().get((Object)source.getName());
            this.blendModeOverride = (BlendModeOverride)properties.getBlendModeOverrides().get((Object)source.getName());
            this.explicitFlips = source.getParent().getPackDirectives().getExplicitFlips(source.getName());
        } else {
            this.viewportScale = 1.0f;
            this.alphaTestOverride = null;
            this.blendModeOverride = null;
            this.explicitFlips = ImmutableMap.of();
        }
        HashSet mipmappedBuffers = new HashSet();
        DispatchingDirectiveHolder directiveHolder = new DispatchingDirectiveHolder();
        supportedRenderTargets.forEach(index -> {
            BooleanConsumer mipmapHandler = shouldMipmap -> {
                if (shouldMipmap) {
                    mipmappedBuffers.add(index);
                } else {
                    mipmappedBuffers.remove(index);
                }
            };
            directiveHolder.acceptConstBooleanDirective("colortex" + index + "MipmapEnabled", mipmapHandler);
            if (index < LEGACY_RENDER_TARGETS.size()) {
                directiveHolder.acceptConstBooleanDirective((String)LEGACY_RENDER_TARGETS.get(index.intValue()) + "MipmapEnabled", mipmapHandler);
            }
        });
        source.getFragmentSource().map(ConstDirectiveParser::findDirectives).ifPresent(directives -> {
            for (ConstDirectiveParser.ConstDirective directive : directives) {
                directiveHolder.processDirective(directive);
            }
        });
        this.mipmappedBuffers = ImmutableSet.copyOf(mipmappedBuffers);
    }

    private static Optional<int[]> findDrawbuffersDirective(Optional<String> stageSource) {
        return stageSource.flatMap(fragment -> CommentDirectiveParser.findDirective(fragment, "DRAWBUFFERS")).map(String::toCharArray).map(ProgramDirectives::parseDigits);
    }

    private static int[] parseDigits(char[] directiveChars) {
        int[] buffers = new int[directiveChars.length];
        int index = 0;
        for (char buffer : directiveChars) {
            buffers[index++] = Character.digit(buffer, 10);
        }
        return buffers;
    }

    public int[] getDrawBuffers() {
        return this.drawBuffers;
    }

    public float getViewportScale() {
        return this.viewportScale;
    }

    public Optional<AlphaTest> getAlphaTestOverride() {
        return Optional.ofNullable(this.alphaTestOverride);
    }

    public BlendModeOverride getBlendModeOverride() {
        return this.blendModeOverride;
    }

    public ImmutableSet<Integer> getMipmappedBuffers() {
        return this.mipmappedBuffers;
    }

    public ImmutableMap<Integer, Boolean> getExplicitFlips() {
        return this.explicitFlips;
    }
}

