/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.AlphaTestFunction;
import net.coderbot.iris.gl.blending.BlendMode;
import net.coderbot.iris.gl.blending.BlendModeFunction;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.texture.TextureStage;

public class ShaderProperties {
    private boolean enableClouds = true;
    private OptionalBoolean oldHandLight = OptionalBoolean.DEFAULT;
    private OptionalBoolean dynamicHandLight = OptionalBoolean.DEFAULT;
    private OptionalBoolean oldLighting = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowTerrain = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowTranslucent = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowEntities = OptionalBoolean.DEFAULT;
    private OptionalBoolean shadowBlockEntities = OptionalBoolean.DEFAULT;
    private OptionalBoolean underwaterOverlay = OptionalBoolean.DEFAULT;
    private OptionalBoolean sun = OptionalBoolean.DEFAULT;
    private OptionalBoolean moon = OptionalBoolean.DEFAULT;
    private OptionalBoolean vignette = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceSolid = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceCutout = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceCutoutMipped = OptionalBoolean.DEFAULT;
    private OptionalBoolean backFaceTranslucent = OptionalBoolean.DEFAULT;
    private OptionalBoolean rainDepth = OptionalBoolean.DEFAULT;
    private OptionalBoolean beaconBeamDepth = OptionalBoolean.DEFAULT;
    private OptionalBoolean separateAo = OptionalBoolean.DEFAULT;
    private OptionalBoolean frustumCulling = OptionalBoolean.DEFAULT;
    private final Object2ObjectMap<String, AlphaTest> alphaTestOverrides = new Object2ObjectOpenHashMap();
    private final Object2FloatMap<String> viewportScaleOverrides = new Object2FloatOpenHashMap();
    private final Object2ObjectMap<String, BlendModeOverride> blendModeOverrides = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<TextureStage, Object2ObjectMap<String, String>> customTextures = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, Object2BooleanMap<String>> explicitFlips = new Object2ObjectOpenHashMap();
    private String noiseTexturePath = null;

    private ShaderProperties() {
    }

    public ShaderProperties(Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(keyObject, valueObject) -> {
            String key = (String)keyObject;
            String value = (String)valueObject;
            if ("texture.noise".equals(key)) {
                this.noiseTexturePath = value;
                return;
            }
            if ("clouds".equals(key) && value.equals("off")) {
                this.enableClouds = false;
            }
            ShaderProperties.handleBooleanDirective(key, value, "oldHandLight", bool -> {
                this.oldHandLight = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "dynamicHandLight", bool -> {
                this.dynamicHandLight = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "oldLighting", bool -> {
                this.oldLighting = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowTerrain", bool -> {
                this.shadowTerrain = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowTranslucent", bool -> {
                this.shadowTranslucent = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowEntities", bool -> {
                this.shadowEntities = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "shadowBlockEntities", bool -> {
                this.shadowBlockEntities = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "underwaterOverlay", bool -> {
                this.underwaterOverlay = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "sun", bool -> {
                this.sun = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "moon", bool -> {
                this.moon = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "vignette", bool -> {
                this.vignette = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "backFace.solid", bool -> {
                this.backFaceSolid = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "backFace.cutout", bool -> {
                this.backFaceCutout = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "backFace.cutoutMipped", bool -> {
                this.backFaceCutoutMipped = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "backFace.translucent", bool -> {
                this.backFaceTranslucent = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "rain.depth", bool -> {
                this.rainDepth = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "beacon.beam.depth", bool -> {
                this.beaconBeamDepth = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "separateAo", bool -> {
                this.separateAo = bool;
            });
            ShaderProperties.handleBooleanDirective(key, value, "frustum.culling", bool -> {
                this.frustumCulling = bool;
            });
            ShaderProperties.handlePassDirective("scale.", key, value, pass -> {
                float scale;
                try {
                    scale = Float.parseFloat(value);
                }
                catch (NumberFormatException e) {
                    Iris.logger.error("Unable to parse scale directive for " + pass + ": " + value, (Throwable)e);
                    return;
                }
                this.viewportScaleOverrides.put(pass, scale);
            });
            ShaderProperties.handlePassDirective("alphaTest.", key, value, pass -> {
                float reference;
                if ("off".equals(value)) {
                    this.alphaTestOverrides.put(pass, (Object)AlphaTest.ALWAYS);
                    return;
                }
                String[] parts = value.split(" ");
                if (parts.length > 2) {
                    Iris.logger.warn("Weird alpha test directive for " + pass + " contains more parts than we expected: " + value);
                } else if (parts.length < 2) {
                    Iris.logger.error("Invalid alpha test directive for " + pass + ": " + value);
                    return;
                }
                Optional<AlphaTestFunction> function = AlphaTestFunction.fromString(parts[0]);
                if (!function.isPresent()) {
                    Iris.logger.error("Unable to parse alpha test directive for " + pass + ", unknown alpha test function " + parts[0] + ": " + value);
                    return;
                }
                try {
                    reference = Float.parseFloat(parts[1]);
                }
                catch (NumberFormatException e) {
                    Iris.logger.error("Unable to parse alpha test directive for " + pass + ": " + value, (Throwable)e);
                    return;
                }
                this.alphaTestOverrides.put(pass, (Object)new AlphaTest(function.get(), reference));
            });
            ShaderProperties.handlePassDirective("blend.", key, value, pass -> {
                if (pass.contains(".")) {
                    Iris.logger.warn("Per-buffer pass blending directives are not supported, ignoring blend directive for " + key);
                    return;
                }
                if ("off".equals(value)) {
                    this.blendModeOverrides.put(pass, (Object)BlendModeOverride.OFF);
                    return;
                }
                String[] modeArray = value.split(" ");
                int[] modes = new int[4];
                int i = 0;
                for (String modeName : modeArray) {
                    modes[i] = BlendModeFunction.fromString(modeName).get().getGlId();
                    ++i;
                }
                this.blendModeOverrides.put(pass, (Object)new BlendModeOverride(new BlendMode(modes[0], modes[1], modes[2], modes[3])));
            });
            ShaderProperties.handleTwoArgDirective("texture.", key, value, (stageName, samplerName) -> {
                String[] parts = value.split(" ");
                if (parts.length > 1) {
                    Iris.logger.warn("Custom texture directive for stage " + stageName + ", sampler " + samplerName + " contains more parts than we expected: " + value);
                    return;
                }
                Optional<TextureStage> optionalTextureStage = TextureStage.parse(stageName);
                if (!optionalTextureStage.isPresent()) {
                    Iris.logger.warn("Unknown texture stage \"" + stageName + "\", ignoring custom texture directive for " + key);
                    return;
                }
                TextureStage stage = optionalTextureStage.get();
                Object2ObjectMap customTexturePropertyMap = (Object2ObjectMap)this.customTextures.getOrDefault((Object)stage, (Object)new Object2ObjectOpenHashMap());
                customTexturePropertyMap.put(samplerName, (Object)value);
                this.customTextures.put((Object)stage, (Object)customTexturePropertyMap);
            });
            ShaderProperties.handleTwoArgDirective("flip.", key, value, (pass, buffer) -> ShaderProperties.handleBooleanValue(key, value, shouldFlip -> ((Object2BooleanMap)this.explicitFlips.computeIfAbsent(pass, _pass -> new Object2BooleanOpenHashMap())).put(buffer, shouldFlip)));
        }));
    }

    private static void handleBooleanValue(String key, String value, BooleanConsumer handler) {
        if ("true".equals(value)) {
            handler.accept(true);
        } else if ("false".equals(value)) {
            handler.accept(false);
        } else {
            Iris.logger.warn("Unexpected value for boolean key " + key + " in shaders.properties: got " + value + ", but expected either true or false");
        }
    }

    private static void handleBooleanDirective(String key, String value, String expectedKey, Consumer<OptionalBoolean> handler) {
        if (!expectedKey.equals(key)) {
            return;
        }
        if ("true".equals(value)) {
            handler.accept(OptionalBoolean.TRUE);
        } else if ("false".equals(value)) {
            handler.accept(OptionalBoolean.FALSE);
        } else {
            Iris.logger.warn("Unexpected value for boolean key " + key + " in shaders.properties: got " + value + ", but expected either true or false");
        }
    }

    private static void handlePassDirective(String prefix, String key, String value, Consumer<String> handler) {
        if (key.startsWith(prefix)) {
            String pass = key.substring(prefix.length());
            handler.accept(pass);
        }
    }

    private static void handleTwoArgDirective(String prefix, String key, String value, BiConsumer<String, String> handler) {
        if (key.startsWith(prefix)) {
            int endOfPassIndex = key.indexOf(".", prefix.length());
            String stage = key.substring(prefix.length(), endOfPassIndex);
            String sampler = key.substring(endOfPassIndex + 1);
            handler.accept(stage, sampler);
        }
    }

    public static ShaderProperties empty() {
        return new ShaderProperties();
    }

    public boolean areCloudsEnabled() {
        return this.enableClouds;
    }

    public OptionalBoolean getOldHandLight() {
        return this.oldHandLight;
    }

    public OptionalBoolean getDynamicHandLight() {
        return this.dynamicHandLight;
    }

    public OptionalBoolean getOldLighting() {
        return this.oldLighting;
    }

    public OptionalBoolean getShadowTerrain() {
        return this.shadowTerrain;
    }

    public OptionalBoolean getShadowTranslucent() {
        return this.shadowTranslucent;
    }

    public OptionalBoolean getShadowEntities() {
        return this.shadowEntities;
    }

    public OptionalBoolean getShadowBlockEntities() {
        return this.shadowBlockEntities;
    }

    public OptionalBoolean getUnderwaterOverlay() {
        return this.underwaterOverlay;
    }

    public OptionalBoolean getSun() {
        return this.sun;
    }

    public OptionalBoolean getMoon() {
        return this.moon;
    }

    public OptionalBoolean getVignette() {
        return this.vignette;
    }

    public OptionalBoolean getBackFaceSolid() {
        return this.backFaceSolid;
    }

    public OptionalBoolean getBackFaceCutout() {
        return this.backFaceCutout;
    }

    public OptionalBoolean getBackFaceCutoutMipped() {
        return this.backFaceCutoutMipped;
    }

    public OptionalBoolean getBackFaceTranslucent() {
        return this.backFaceTranslucent;
    }

    public OptionalBoolean getRainDepth() {
        return this.rainDepth;
    }

    public OptionalBoolean getBeaconBeamDepth() {
        return this.beaconBeamDepth;
    }

    public OptionalBoolean getSeparateAo() {
        return this.separateAo;
    }

    public OptionalBoolean getFrustumCulling() {
        return this.frustumCulling;
    }

    public Object2ObjectMap<String, AlphaTest> getAlphaTestOverrides() {
        return this.alphaTestOverrides;
    }

    public Object2FloatMap<String> getViewportScaleOverrides() {
        return this.viewportScaleOverrides;
    }

    public Object2ObjectMap<String, BlendModeOverride> getBlendModeOverrides() {
        return this.blendModeOverrides;
    }

    public Object2ObjectMap<TextureStage, Object2ObjectMap<String, String>> getCustomTextures() {
        return this.customTextures;
    }

    public Optional<String> getNoiseTexturePath() {
        return Optional.ofNullable(this.noiseTexturePath);
    }

    public Object2ObjectMap<String, Object2BooleanMap<String>> getExplicitFlips() {
        return this.explicitFlips;
    }
}

