/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadow;

import java.nio.FloatBuffer;
import net.minecraft.class_1159;
import net.minecraft.class_1160;

public class ShadowMatrices {
    private static final float NEAR = 0.05f;
    private static final float FAR = 256.0f;

    public static float[] createOrthoMatrix(float halfPlaneLength) {
        return new float[]{1.0f / halfPlaneLength, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / halfPlaneLength, 0.0f, 0.0f, 0.0f, 0.0f, -0.007814026f, 0.0f, 0.0f, 0.0f, -1.0003906f, 1.0f};
    }

    public static void createBaselineModelViewMatrix(class_1159 target, float shadowAngle, float sunPathRotation) {
        float skyAngle = shadowAngle < 0.25f ? shadowAngle + 0.75f : shadowAngle - 0.25f;
        target.method_22668();
        target.method_22672(class_1159.method_24021((float)0.0f, (float)0.0f, (float)-100.0f));
        target.method_22670(class_1160.field_20703.method_23214(90.0f));
        target.method_22670(class_1160.field_20707.method_23214(skyAngle * -360.0f));
        target.method_22670(class_1160.field_20703.method_23214(sunPathRotation));
    }

    public static void snapModelViewToGrid(class_1159 target, float shadowIntervalSize, double cameraX, double cameraY, double cameraZ) {
        float offsetX = (float)cameraX % shadowIntervalSize;
        float offsetY = (float)cameraY % shadowIntervalSize;
        float offsetZ = (float)cameraZ % shadowIntervalSize;
        float halfIntervalSize = shadowIntervalSize / 2.0f;
        target.method_22672(class_1159.method_24021((float)(offsetX -= halfIntervalSize), (float)(offsetY -= halfIntervalSize), (float)(offsetZ -= halfIntervalSize)));
    }

    public static void createModelViewMatrix(class_1159 target, float shadowAngle, float shadowIntervalSize, float sunPathRotation, double cameraX, double cameraY, double cameraZ) {
        ShadowMatrices.createBaselineModelViewMatrix(target, shadowAngle, sunPathRotation);
        ShadowMatrices.snapModelViewToGrid(target, shadowIntervalSize, cameraX, cameraY, cameraZ);
    }

    private static final class Tests {
        private Tests() {
        }

        public static void main(String[] args) {
            float[] expected = new float[]{0.03125f, 0.0f, 0.0f, 0.0f, 0.0f, 0.03125f, 0.0f, 0.0f, 0.0f, 0.0f, -0.007814026f, 0.0f, 0.0f, 0.0f, -1.0003906f, 1.0f};
            Tests.test("ortho projection hpl=32", expected, ShadowMatrices.createOrthoMatrix(32.0f));
            float[] expected110 = new float[]{0.009090909f, 0.0f, 0.0f, 0.0f, 0.0f, 0.009090909f, 0.0f, 0.0f, 0.0f, 0.0f, -0.007814026f, 0.0f, 0.0f, 0.0f, -1.0003906f, 1.0f};
            Tests.test("ortho projection hpl=110", expected110, ShadowMatrices.createOrthoMatrix(110.0f));
            float[] expectedModelViewAtDawn = new float[]{0.2154504f, 5.8204815E-8f, 0.9765147f, 0.0f, -0.97651476f, 1.2841845E-8f, 0.21545039f, 0.0f, 0.0f, -0.99999994f, 5.9604645E-8f, 0.0f, 0.3800215f, 1.0264281f, -100.44631f, 1.0f};
            class_1159 modelView = new class_1159();
            ShadowMatrices.createModelViewMatrix(modelView, 0.03451777f, 2.0f, 0.0f, 0.646045982837677, 82.53274536132812, -514.0264282226562);
            Tests.test("model view at dawn", expectedModelViewAtDawn, Tests.toFloatArray(modelView));
        }

        private static float[] toFloatArray(class_1159 matrix4f) {
            FloatBuffer buffer = FloatBuffer.allocate(16);
            matrix4f.method_4932(buffer);
            return buffer.array();
        }

        private static void test(String name, float[] expected, float[] created) {
            if (!Tests.areMatricesEqualWithinEpsilon(expected, created)) {
                System.err.println("test " + name + " failed: ");
                System.err.println("    expected: ");
                System.err.print(Tests.printMatrix(expected, 8));
                System.err.println("    created: ");
                System.err.print(Tests.printMatrix(created, 8));
            } else {
                System.out.println("test " + name + " passed");
            }
        }

        private static boolean areMatricesEqualWithinEpsilon(float[] expected, float[] created) {
            for (int i = 0; i < 16; ++i) {
                if (!(Math.abs(expected[i] - created[i]) > 5.0E-4f)) continue;
                return false;
            }
            return true;
        }

        private static String printMatrix(float[] matrix, int spaces) {
            StringBuilder lines = new StringBuilder();
            for (int row = 0; row < 4; ++row) {
                for (int i = 0; i < spaces; ++i) {
                    lines.append(' ');
                }
                lines.append('[');
                for (int column = 0; column < 4; ++column) {
                    lines.append(' ');
                    lines.append(matrix[column * 4 + row]);
                }
                lines.append(" ]");
                lines.append('\n');
            }
            return lines.toString();
        }
    }
}

