/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public interface RegistrySupplier<T>
extends Supplier<T> {
    public class_2960 getRegistryId();

    public class_2960 getId();

    public boolean isPresent();

    @Nullable
    default public T getOrNull() {
        if (this.isPresent()) {
            return this.get();
        }
        return null;
    }

    default public Optional<T> toOptional() {
        return Optional.ofNullable(this.getOrNull());
    }

    default public void ifPresent(Consumer<? super T> action) {
        if (this.isPresent()) {
            action.accept(this.get());
        }
    }

    default public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (this.isPresent()) {
            action.accept(this.get());
        } else {
            emptyAction.run();
        }
    }

    default public Stream<T> stream() {
        if (!this.isPresent()) {
            return Stream.empty();
        }
        return Stream.of(this.get());
    }

    default public T orElse(T other) {
        return this.isPresent() ? this.get() : other;
    }

    default public T orElseGet(Supplier<? extends T> supplier) {
        return this.isPresent() ? this.get() : supplier.get();
    }
}

