/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.event;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.hotkeys.KeyCallbackAdjustable;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererSlimeChunks;
import java.util.List;

public class InputHandler
implements IKeybindProvider,
IMouseInputHandler {
    private static final InputHandler INSTANCE = new InputHandler();

    private InputHandler() {
    }

    public static InputHandler getInstance() {
        return INSTANCE;
    }

    public void addKeysToMap(IKeybindManager manager) {
        for (InfoToggle infoToggle : InfoToggle.values()) {
            manager.addKeybindToMap(infoToggle.getKeybind());
        }
        for (Enum enum_ : RendererToggle.values()) {
            manager.addKeybindToMap(((RendererToggle)enum_).getKeybind());
        }
        for (IHotkey iHotkey : Configs.Generic.HOTKEY_LIST) {
            manager.addKeybindToMap(iHotkey.getKeybind());
        }
    }

    public void addHotkeys(IKeybindManager manager) {
        manager.addHotkeysForCategory("MiniHUD", "minihud.hotkeys.category.generic_hotkeys", Configs.Generic.HOTKEY_LIST);
        manager.addHotkeysForCategory("MiniHUD", "minihud.hotkeys.category.info_toggle_hotkeys", (List)ImmutableList.copyOf((Object[])InfoToggle.values()));
        manager.addHotkeysForCategory("MiniHUD", "minihud.hotkeys.category.renderer_toggle_hotkeys", (List)ImmutableList.copyOf((Object[])RendererToggle.values()));
    }

    public boolean onMouseScroll(int mouseX, int mouseY, double dWheel) {
        if (GuiUtils.getCurrentScreen() == null && dWheel != 0.0 && RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY.getBooleanValue() && RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY.getKeybind().isKeybindHeld()) {
            OverlayRendererSlimeChunks.overlayTopY += (double)(dWheel < 0.0 ? 1 : -1);
            KeyCallbackAdjustable.setValueChanged();
            return true;
        }
        return false;
    }
}

