/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.minihud.renderer.IOverlayRenderer;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1159;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_757;

public abstract class OverlayRendererBase
implements IOverlayRenderer {
    protected static final class_287 BUFFER_1 = new class_287(0x200000);
    protected static final class_287 BUFFER_2 = new class_287(0x200000);
    protected final List<RenderObjectBase> renderObjects = new ArrayList<RenderObjectBase>();
    protected boolean renderThrough = false;
    protected float glLineWidth = 1.0f;
    protected class_2338 lastUpdatePos = class_2338.field_10980;
    private class_243 updateCameraPos = class_243.field_1353;

    @Override
    public final class_243 getUpdatePosition() {
        return this.updateCameraPos;
    }

    @Override
    public final void setUpdatePosition(class_243 cameraPosition) {
        this.updateCameraPos = cameraPosition;
    }

    protected void preRender() {
        RenderSystem.lineWidth((float)this.glLineWidth);
        if (this.renderThrough) {
            RenderSystem.disableDepthTest();
        }
    }

    protected void postRender() {
        if (this.renderThrough) {
            RenderSystem.enableDepthTest();
        }
    }

    @Override
    public void draw(class_4587 matrixStack, class_1159 projMatrix) {
        this.preRender();
        for (RenderObjectBase obj : this.renderObjects) {
            obj.draw(matrixStack, projMatrix);
        }
        this.postRender();
    }

    @Override
    public void deleteGlResources() {
        for (RenderObjectBase obj : this.renderObjects) {
            obj.deleteGlResources();
        }
        this.renderObjects.clear();
    }

    protected RenderObjectBase allocateBuffer(class_293.class_5596 glMode) {
        return this.allocateBuffer(glMode, class_290.field_1576, class_757::method_34540);
    }

    protected RenderObjectBase allocateBuffer(class_293.class_5596 glMode, class_293 format, Supplier<class_5944> shader) {
        RenderObjectVbo obj = new RenderObjectVbo(glMode, format, shader);
        this.renderObjects.add(obj);
        return obj;
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(class_293.class_5596.field_27382);
        this.allocateBuffer(class_293.class_5596.field_29344);
    }

    public void setRenderThrough(boolean renderThrough) {
        this.renderThrough = renderThrough;
    }

    public String getSaveId() {
        return "";
    }

    @Nullable
    public JsonObject toJson() {
        return null;
    }

    public void fromJson(JsonObject obj) {
    }
}

