/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.IOverlayRenderer;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererBlockGrid;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererRandomTickableChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererRegion;
import fi.dy.masa.minihud.renderer.OverlayRendererSlimeChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnableColumnHeights;
import fi.dy.masa.minihud.renderer.OverlayRendererStructures;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class RenderContainer {
    public static final RenderContainer INSTANCE = new RenderContainer();
    private final List<OverlayRendererBase> renderers = new ArrayList<OverlayRendererBase>();
    protected boolean resourcesAllocated;
    protected int countActive;

    private RenderContainer() {
        this.addRenderer(new OverlayRendererBeaconRange());
        this.addRenderer(new OverlayRendererBlockGrid());
        this.addRenderer(new OverlayRendererLightLevel());
        this.addRenderer(new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_FIXED));
        this.addRenderer(new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER));
        this.addRenderer(new OverlayRendererRegion());
        this.addRenderer(new OverlayRendererSlimeChunks());
        this.addRenderer(new OverlayRendererSpawnableColumnHeights());
        this.addRenderer(new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL));
        this.addRenderer(new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER));
        this.addRenderer(OverlayRendererStructures.INSTANCE);
    }

    private void addRenderer(OverlayRendererBase renderer) {
        if (this.resourcesAllocated) {
            renderer.allocateGlResources();
        }
        this.renderers.add(renderer);
    }

    public void addShapeRenderer(ShapeBase renderer) {
        this.addRenderer(renderer);
    }

    public void removeShapeRenderer(ShapeBase renderer) {
        this.renderers.remove(renderer);
        if (this.resourcesAllocated) {
            renderer.deleteGlResources();
        }
    }

    public void render(class_1297 entity, class_4587 matrixStack, class_1159 projMatrix, class_310 mc) {
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        this.update(cameraPos, entity, mc);
        this.draw(cameraPos, matrixStack, projMatrix, mc);
    }

    protected void update(class_243 cameraPos, class_1297 entity, class_310 mc) {
        this.allocateResourcesIfNeeded();
        this.countActive = 0;
        for (int i = 0; i < this.renderers.size(); ++i) {
            OverlayRendererBase renderer = this.renderers.get(i);
            if (!renderer.shouldRender(mc)) continue;
            if (renderer.needsUpdate(entity, mc)) {
                renderer.lastUpdatePos = PositionUtils.getEntityBlockPos((class_1297)entity);
                renderer.setUpdatePosition(cameraPos);
                renderer.update(cameraPos, entity, mc);
            }
            ++this.countActive;
        }
    }

    protected void draw(class_243 cameraPos, class_4587 matrixStack, class_1159 projMatrix, class_310 mc) {
        if (this.resourcesAllocated && this.countActive > 0) {
            RenderSystem.disableTexture();
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
            RenderSystem.enablePolygonOffset();
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (IOverlayRenderer iOverlayRenderer : this.renderers) {
                if (!iOverlayRenderer.shouldRender(mc)) continue;
                class_243 updatePos = iOverlayRenderer.getUpdatePosition();
                matrixStack.method_22903();
                matrixStack.method_22904(updatePos.field_1352 - cameraPos.field_1352, updatePos.field_1351 - cameraPos.field_1351, updatePos.field_1350 - cameraPos.field_1350);
                iOverlayRenderer.draw(matrixStack, projMatrix);
                matrixStack.method_22909();
            }
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableTexture();
        }
    }

    protected void allocateResourcesIfNeeded() {
        if (!this.resourcesAllocated) {
            this.deleteGlResources();
            this.allocateGlResources();
        }
    }

    protected void allocateGlResources() {
        if (!this.resourcesAllocated) {
            for (int i = 0; i < this.renderers.size(); ++i) {
                this.renderers.get(i).allocateGlResources();
            }
            this.resourcesAllocated = true;
        }
    }

    protected void deleteGlResources() {
        if (this.resourcesAllocated) {
            for (int i = 0; i < this.renderers.size(); ++i) {
                this.renderers.get(i).deleteGlResources();
            }
            this.resourcesAllocated = false;
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        for (int i = 0; i < this.renderers.size(); ++i) {
            OverlayRendererBase renderer = this.renderers.get(i);
            String id = renderer.getSaveId();
            if (id.isEmpty()) continue;
            obj.add(id, (JsonElement)renderer.toJson());
        }
        return obj;
    }

    public void fromJson(JsonObject obj) {
        for (int i = 0; i < this.renderers.size(); ++i) {
            OverlayRendererBase renderer = this.renderers.get(i);
            String id = renderer.getSaveId();
            if (id.isEmpty() || !JsonUtils.hasObject((JsonObject)obj, (String)id)) continue;
            renderer.fromJson(obj.get(id).getAsJsonObject());
        }
    }
}

