/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.util.ShapeRenderType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_310;

public abstract class ShapeBase
extends OverlayRendererBase
implements IRangeChangeListener {
    protected final class_310 mc = class_310.method_1551();
    protected final ShapeType type;
    protected final LayerRange layerRange;
    protected String displayName;
    protected ShapeRenderType renderType;
    protected Color4f color;
    protected boolean enabled;
    protected boolean needsUpdate;

    public ShapeBase(ShapeType type, Color4f color) {
        this.type = type;
        this.color = color;
        this.layerRange = new LayerRange((IRangeChangeListener)this);
        this.renderType = ShapeRenderType.OUTER_EDGE;
        this.displayName = type.getDisplayName();
        this.needsUpdate = true;
    }

    public ShapeType getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LayerRange getLayerRange() {
        return this.layerRange;
    }

    public Color4f getColor() {
        return this.color;
    }

    public ShapeRenderType getRenderType() {
        return this.renderType;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setRenderType(ShapeRenderType renderType) {
        this.renderType = renderType;
        this.setNeedsUpdate();
    }

    public void setColor(int newColor) {
        if (newColor != this.color.intValue) {
            this.color = Color4f.fromColor((int)newColor);
            this.setNeedsUpdate();
        }
    }

    public void setColorFromString(String newValue) {
        this.setColor(StringUtils.getColor((String)newValue, (int)0));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void toggleEnabled() {
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            this.setNeedsUpdate();
        }
    }

    public void setNeedsUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return this.enabled && RendererToggle.SHAPE_RENDERER.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        return this.needsUpdate;
    }

    public void updateAll() {
        this.setNeedsUpdate();
    }

    public void updateBetweenX(int minX, int maxX) {
        this.setNeedsUpdate();
    }

    public void updateBetweenY(int minY, int maxY) {
        this.setNeedsUpdate();
    }

    public void updateBetweenZ(int minZ, int maxZ) {
        this.setNeedsUpdate();
    }

    public List<String> getWidgetHoverLines() {
        ArrayList<String> lines = new ArrayList<String>();
        String aq = GuiBase.TXT_AQUA;
        String rst = GuiBase.TXT_GRAY;
        lines.add(StringUtils.translate((String)"minihud.gui.label.shape.type_value", (Object[])new Object[]{aq + this.type.getDisplayName() + rst}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("type", (JsonElement)new JsonPrimitive(this.type.getId()));
        obj.add("color", (JsonElement)new JsonPrimitive((Number)this.color.intValue));
        obj.add("enabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.enabled)));
        obj.add("display_name", (JsonElement)new JsonPrimitive(this.displayName));
        obj.add("render_type", (JsonElement)new JsonPrimitive(this.renderType.getStringValue()));
        obj.add("layers", (JsonElement)this.layerRange.toJson());
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        ShapeRenderType type;
        this.enabled = JsonUtils.getBoolean((JsonObject)obj, (String)"enabled");
        if (JsonUtils.hasInteger((JsonObject)obj, (String)"color")) {
            this.color = Color4f.fromColor((int)JsonUtils.getInteger((JsonObject)obj, (String)"color"));
        }
        if (JsonUtils.hasObject((JsonObject)obj, (String)"layers")) {
            this.layerRange.fromJson(JsonUtils.getNestedObject((JsonObject)obj, (String)"layers", (boolean)false));
        }
        if (JsonUtils.hasString((JsonObject)obj, (String)"render_type") && (type = ShapeRenderType.fromStringStatic(obj.get("render_type").getAsString())) != null) {
            this.renderType = type;
        }
        if (JsonUtils.hasString((JsonObject)obj, (String)"display_name")) {
            this.displayName = obj.get("display_name").getAsString();
        }
    }
}

